unit LadenSpeichern;

interface

uses classes, Graphics, SysUtils;

type
TLoadSave = class(TObject)
private
protected
   filename: String;
   F: TextFile;
   lastdata: String;

public
  function OpenFileRead(PFilename: String): boolean;
  function OpenFileWrite(PFilename: String): boolean;
  procedure CloseFile;
  function EndOfFile: boolean;
  function TestChar(c: char): boolean;
  function ReadString:String;
  procedure WriteString(s: String);
  function readInteger: Integer;
  procedure WriteInteger(i: integer);
  function readDouble: double;
  procedure writeDouble(d: double);
  function readBoolean: boolean;
  procedure writeBoolean(b: boolean);
  function readfont: TFont;
  procedure writeFont(font: TFont);
  procedure newline;

  function ReadStringd(data: String; default: String): String;
  procedure WriteStringd(data: String; s: String);
  function ReadIntegerd(data: String; default: integer):integer;
  procedure writeIntegerd(data: String; i: integer);
  function readdoubled(data: String; default: double): double;
  procedure writedoubled(data: String; d: double);
  function readBooleand(data: String; default: boolean):boolean;
  procedure writeBooleand(data: string; b: boolean);
  function Testdata(data: String): boolean;
end;


implementation


function TLoadSave.ReadStringd(data: String; default: String): String;
Var s: string;
begin
   if lastdata = '' then
      lastdata := readstring;
   if lastdata <> data then s := default
      else
      begin
         s := readstring; lastdata := '';
      end;
   ReadStringd := s;
end;

function TLoadSave.ReadIntegerd(data: String; default: Integer): Integer;
Var i: integer;
begin
   if lastdata = '' then
      lastdata := readstring;
   if lastdata <> data then i := default
      else
      begin
         i := readinteger; lastdata := '';
      end;
   ReadIntegerd := i;
end;

function TLoadSave.Readdoubled(data: String; default: double): double;
Var d: double;
begin
   if lastdata = '' then
      lastdata := readstring;
   if lastdata <> data then d := default
      else
      begin
         d := readdouble; lastdata := '';
      end;
   Readdoubled := d;
end;

function TLoadSave.Readbooleand(data: String; default: boolean): boolean;
Var b: boolean;
begin
   if lastdata = '' then
      lastdata := readstring;
   if lastdata <> data then b := default
      else
      begin
         b := readboolean; lastdata := '';
      end;
   Readbooleand := b;
end;


function TLoadSave.testdata(data: String): boolean;
Var b: boolean;
begin
   if lastdata = '' then
      lastdata := readstring;
   if lastdata <> data then b := false
   else
   begin
      b := true; lastdata := '';
   end;
   testdata := b;
end;

procedure TLoadSave.WriteStringd(data: String; s: String);
begin
   writeString(data); writeString(s);
end;

procedure TLoadSave.writeIntegerd(data: String; i: integer);
begin
   writeString(data); writeInteger(i);
end;

procedure TLoadSave.writedoubled(data: String; d: double);
begin
   writeString(data); writedouble(d);
end;

procedure TLoadSave.writeBooleand(data: String; b: boolean);
begin
   writeString(data); writeboolean(b);
end;



function TLoadSave.OpenFileRead(PFilename:String): boolean;
Var Fehler : boolean;
begin
   AssignFile(F,PFilename);
    {$I-}
    Reset(F);
    lastdata := '';
    Fehler := false;
    if (IOResult <> 0) or (PFilename = '') then Fehler := true;
    {$I+}
    OpenFileRead := Fehler;
end;

function TLoadSave.OpenFilewrite(PFilename:String): boolean;
Var Fehler : boolean;
begin
   AssignFile(F,PFilename);
    {$I-}
    Rewrite(F);
    Fehler := false;
    if (IOResult <> 0) or (PFilename = '') then Fehler := true;
    {$I+}
    OpenFilewrite := Fehler;
end;

procedure TLoadSave.closeFile;
begin
   close(F);
end;

function TLoadSave.endOfFile: boolean;
begin
   endOfFile := eof(F);
end;

function TLoadSave.TestChar(c: char): Boolean;
Var ch: char;
    ok: boolean;
begin
 ch := ' ';
 while ch in [' ',chr(13), chr(10)] do
 read(F,ch);
 if ch = c then ok := true else ok := false;
 TestChar := ok;
end;

procedure TLoadSave.WriteString(s:STring);
Var i: integer;
    c: char;
begin
   write(F,'[');
   for i := 1 to length(s) do
   begin
     c := s[i];
     if c = '[' then write(F,'\[')
     else if c = '\' then write(F,'\\')
        else write(F,c);
   end;
   write(F,']');
end;

function TLoadSave.ReadString:String;
Var s: string;
    c: char;
    StringEnde: boolean;
begin
   s := '';
   StringEnde := false;
   if TestChar('[') then
   repeat
      read(F,c);
      if c = ']' then StringEnde := true;
      if c = '\' then read(F,c);
      if not StringEnde then s := s + c;
   until eof(F) or (c = ']');
   ReadString := s;
end;

procedure TLoadSave.WriteInteger(i: integer);
begin
   write(F,' ');
   write(F,i);
   write(F,' ');
end;
function TLoadSave.readInteger:integer;
Var zahl: integer;
    s: string;
    ch: char;
begin
    s := '';
    repeat
       read(F,ch);
    until ( ( ord(ch) >= ord('0') ) and ( ord(ch) <= ord('9') )) or (ch = '-');
    repeat
       s := s + ch;
       read(F,ch);
    until   ( ord(ch) > ord('9') ) or ( ord(ch) < ord('0') ) or eof(F);
    zahl := strtoint(s);
    readInteger := zahl;
end;

procedure TLoadSave.writeDouble(d: Double);
begin
   write(F,' ');
   write(F,d);
   write(F,' ');
end;

function TLoadSave.readDouble:double;
Var zahl: double;
    s: string;
    ch: char;
begin
    s := '';
    repeat
       read(F,ch);
    until (( ord(ch) >= ord('0') ) and ( ord(ch) <= ord('9') )) or (ch = '-') or (ch = '+');
    repeat
       s := s + ch;
       read(F,ch);
    until  (ord(ch) = 13) {or (ord(ch) = 12)} or (ch = ' ') or eof(F);
    DecimalSeparator := '.';
    zahl := strtofloat(s);
    readdouble := zahl;
end;

procedure TLoadSave.writeBoolean(b: Boolean);
begin
   write(F,' ');
   if b then write (F,'true') else write(F,'false');
   write(F,' ');
end;

function TLoadSave.readBoolean:boolean;
Var wert: boolean;
    s: string;
    ch: char;
begin
    s := '';
    repeat
       read(F,ch);
    until (( ord(ch) >= ord('a') ) and ( ord(ch) <= ord('z') ));
    repeat
       s := s + ch;
       read(F,ch);
    until  (ord(ch) < ord('a') ) or (ord(ch) > ord('z') ) or eof(F);
    if s = 'true' then wert := true
    else wert := false;
    readboolean := wert;
end;

function TLoadSave.readFont: TFont;
var font: TFont;
begin
   font := TFont.Create;
   testchar('[');
   font.Name := readstring;
   font.Size := readinteger;
   font.Style := TFontStyles(Byte(readinteger));
   font.Color := TColor(readinteger);
   font.Charset := TFontCharSet(readinteger);
   testchar(']');
   readFont := font;
end;

procedure TLoadSave.writeFont(font: TFont);
begin
   write(F,' [');
   writeString(font.Name);
   writeInteger(font.Size);
   writeInteger(byte(font.Style));
   writeInteger(integer(font.Color));
   writeInteger(integer(font.Charset));
   writeln(F,'] ');
end;

procedure TLoadSave.newline;
begin
  writeln(F,'');
end;


end.
