unit UScanner;

interface
uses classes,SysUtils,UConstants,StdCtrls, USHControl, windows, UCriticalSections;

type TScanner = class(TObject)
   private
     LastChar: Char;
     BBAck: Boolean;  // Nchstesmal dasselbe ausgeben?
     LastPos: Integer;
     // Nur, solange aus einem TMemo gelesen wird
     pos: integer;
     bufferString: String;
     ZeilenArray: Array of integer;  // Da sind die Anfangspositionen der Zeilen drin
     function GetChar:Char;
     procedure BackChar;

   public
     shc: TSHControl;
     EndOfText: Boolean;
     Text: string;
     IntWert: Integer;
     RealWert: double;
     Stringgelesen: String;
     Spalte: Integer;
     yZeile, ySpalte: integer;

     procedure StopPositionensetzen;
     function TokenOut(Token:EToken): String; // Test
     procedure init(shc: TSHControl);
     procedure initStrings(source: TStrings);
     function TRead:EToken;
     procedure Back;
     procedure SetPos(pos: integer);
     function getPos: Integer;
     procedure SkipSpace; // Leerraum berlesen, pos auf nchstes Zeichen setzten
     procedure getZeileSpalte(Var Zeile,Spalte: integer);

     procedure hgetZeileSpalte;  // Fr UFehler
     destructor destroy; override;
   end;

TFormatClass = class
     function FormatProcedure(var s: String;
           GeschweifteKlammerdavoroffen: Boolean; Einruecken: Integer; zinfo: TZeilenInformation): Integer;
end;

function MyUpperCase(const S: string): string;

implementation

function MyUpperCase(const S: string): string;
var
  Ch: Char;
  L: Integer;
  Source, Dest: PChar;
begin
  L := Length(S);
  SetLength(Result, L);
  Source := Pointer(S);
  Dest := Pointer(Result);
  while L <> 0 do
  begin
    Ch := Source^;
    if (Ch >= 'a') and (Ch <= 'z') then Dec(Ch, 32);
    case Ch of
    '': ch := '';
    '': ch := '';
    '': ch := '';
    end; // case
    Dest^ := Ch;
    Inc(Source);
    Inc(Dest);
    Dec(L);
  end;
end;


procedure TScanner.init(shc: TSHControl);
var i: integer;
    Source: TStrings;
    hpos: integer;
begin
   setlength(ZeilenArray,shc.Zeile.Count); // von 0 bis shc.zeile.count -1

   self.shc := shc;
   Source := shc.Zeile;

   Lastchar := ' ';

   // Was jetzt folgt ist nur wichtig, falls aus einem Memo gelesen wird.
   // Im Zeilenarray[i] steht immer die Position, die auf das chr(13) der
   // vorhergehenden Zeile Zeigt. So kann es durch chr(1)=OStop ersetzt
   // werden!
   bufferString := '' + chr(13); hpos := 1;
   for i := 0 to Source.Count - 1 do
   begin
   ZeilenArray[i] := hpos;
   bufferString := bufferString + Source.Strings[i];
   // das ' ' ist ntig, damit der richtige Fehler angezeigt wird, wenn man nur "solange" eingibt!
   bufferString := bufferString + ' ' + chr(13);
   hpos := hpos + length(source.Strings[i]) + 2;
   end;
   pos := 1; Spalte := 1; EndOfText := false;
   LastPos := 0; // Wird bentigt, um einen Token zurckzugehen
end;

function TScanner.GetChar:Char;
var c : char;
begin
   begin
     if Pos < Length(bufferString) then
     begin
        c := bufferString[pos];
        if not (c in [chr(13),chr(0)]) then
           Stringgelesen := Stringgelesen + c;
     end
     else begin c := chr(0); EndOfText := true; end;
     pos := pos + 1;
   end;
   LastChar := c; GetChar := c;
end;

procedure TScanner.BackChar;
begin
   Setpos(getpos - 1);
   if pos < length(bufferstring) - 1 then EndOfText := false;
end;

procedure TScanner.back; // Sorgt dafr, dass beim nchsten Aufruf von tread nochmal dasselbe Token ausgegeben wird.
begin
   if BBAck then
   begin
      SetPos(lastpos);
      BBack := false;
   end;
   if pos < length(bufferstring)- 1 then EndOfText := false;
end;

function TScanner.tread:EToken;
Var c: Char;
    oc,i,SternPos : integer;
    SVorkomma, SNachkomma, SExponent: String;
    Vorkomma{, Exponent}: integer;
    BNAchkomma, BExponent : boolean;
    RToken:EToken;
    PunktPunktMerk: Boolean;
    Zahlenfehler: Boolean;
begin
  Zahlenfehler := false;
  PunktPunktMerk := false;
  lastpos := pos; BBack := true;
  begin
    repeat
       Stringgelesen := '';
       c := getchar;
       oc := ord(c);
       if oc <> 0 then
       begin
          if c = '*' then
          begin
             SternPos := GetPos;
             Text := '';
             Text := Text + c; c := getchar; oc := ord(c);
             while (CharTable[oc] = OTC) or (CharTable[oc] = OTZ) do //solange Alph oder Ziffer
             begin
                Text := Text + c;
                c := getchar; oc := ord(c);
             end; backchar;
             if myuppercase(Text) = '*WIEDERHOLE' then
                 RToken := OSternWiederhole
             else
             if myuppercase(Text) = '*WENN' then RToken := OSternWenn
             else
             if myuppercase(Text) = '*SOLANGE' then RToken := OSTernSolange
             else
             if myuppercase(Text) = '*FR' then RToken := OSTernFuer
             else
             begin
                setpos(Sternpos);
                RToken := OMal;
             end;
          end
          else
          begin
            If (CharTable[oc] = OTC) then
            begin
               Text := '';
               Text := Text + c; c := getchar; oc := ord(c);
               while (CharTable[oc] = OTC) or (CharTable[oc] = OTZ) do //solange Alph oder Ziffer
               begin
                  Text := Text + c;
                  c := getchar; oc := ord(c);
               end;
               backchar;
               RToken := OIdentifier;
               for i := 0 to ord(OFalse)-ord(OFuer) do
                 if comparestr(myuppercase(Text),ResWordsTable[i]) = 0 then
                    RToken := EToken(Ord(OFuer) + i);
            end   // Reserved Word oder Identifier
            else if CharTable[oc] = OTZ then  // Zahlenkonstante
            begin
               text := '';SVorkomma := ''; SNachkomma := ''; SExponent := '';
               while CharTable[oc] = OTZ do
               begin
                  SVorkomma := SVorkomma + c;
                  c := getchar; oc := ord(c);
               end;
               Vorkomma := 0;
               try
               Vorkomma := StrtoInt (SVorkomma);
               except on EConvertError do
                   begin
                   Zahlenfehler := true;
                   end;
                 end; // try..except..end
               BNAchkomma := false;
               if c = '.' then
               begin
                  c := getchar; backchar;
                  if c <> '.' then
                  begin
                     bnachkomma := true; c := getchar; oc := ord(c);
                     while CharTable[oc] = OTZ do
                     begin
                        SNachkomma := SNachkomma + c;
                        c := getchar; oc := ord(c);
                     end;
                   //Nachkomma := StrtoInt(SNachkomma);
                  end else PunktPunktMerk := true;
               end else BNachkomma := false;
               //Exponent := 0;
               if myuppercase(c) = 'E' then
               begin
                 bexponent := true; c := getchar; oc := ord(c);
                 if c = '-' then
                 begin
                    SExponent := '-'; c := getchar; oc := ord(c);
                 end;
                 if c = '+' then
                 begin
                    SExponent := '+'; c := getchar; oc := ord(c);
                 end;
                 while CharTable[oc] = OTZ do
                 begin
                    SExponent := SExponent + c;
                    c := getchar; oc := ord(c);
                 end;
               //Exponent := StrtoInt(SExponent);
               end else BExponent := false;
               backchar; // Auf jeden Fall!
               if not(BNAchkomma or BExponent) then
               begin
                  RToken := OIntegerconst;
                  Intwert := Vorkomma;
               end
               else begin
                  RToken := ORealconst;
                  DecimalSeparator := '.';
                  if not BExponent then SExponent := '0';
                  try
                  Zahlenfehler := false;
                  RealWert := StrToFloat(SVorkomma+'.'+SNAchkomma+'e'+SExponent);
                  except on EConvertError do Zahlenfehler := true; end;
               end;
            end   // Ziffer
            else if charTable[oc] = OAnfZeich then
              begin
                RToken := OStringConst;
                Text := '';c := getchar; oc := ord(c);
                while (charTable[oc] <> OAnfZeich) and (oc <> 0) do
                begin
                   if (oc <> 13) and (oc <> 9) then text := text + c;
                   c := getchar; oc := ord(c);
                end;
              end  // Stringkonstante
            else
            begin
              case c of
              chr(1): RToken := OStop;
              '('..'-' : RToken := charTable[oc];
              ';','[',']','^','@' : RToken := charTable[oc];
              '=' : begin
                       RToken := OGleich; c := getchar;
                       if c = '=' then RToken := OGleichgleich
                            else backchar;
                    end; // '='
              '/' : begin
                      c := getchar; RToken := OSpace;
                      if c = '/' then
                         begin
                         repeat
                            c := getchar; oc := ord(c);
                         until (oc = 13) or (oc = 0) or (oc = 1);
// nderung 2.10.07 (oc = 1) und if oc = 1 then backchar
                         if oc = 1 then backchar;
                         end
                      else
                      begin
                         backchar;
                         RToken := OGeteilt;
                      end;
                    end;
              ':' : begin
                       RToken := ODoppelpunkt; c := getchar;
                       if c = '=' then RToken := ODoppelpunktgleich
                       else backchar;
                    end; // ':'
              '<' : begin
                       RToken := OKleiner; c := getchar;
                       if c = '=' then RToken := OKleinergleich
                       else if c = '>' then RToken := OUngleich
                            else backchar;
                    end; // '<'
              '>' : begin
                       RToken := OGroesser; c := getchar;
                       if c = '=' then RToken := OGroessergleich
                       else backchar;
                    end; // '>'
              '.' : begin
                       RToken := OPunkt; c := getchar;
                       if c = '.' then RToken := OPunktPunkt
                       else backchar;
                    end; // '.'
              '{' : begin
                    RToken := OSpace;
                    while (ord(c) <> 0) and (c <> '}') do c := getchar;
                    end;
              else RToken := OSpace; // else des case c of ...
              end; //case
              text := Stringgelesen;
            end;
          end;
       end // if oc <> 0
         else RToken := OEOF; // if ord(c) <> 0 then...
       if Zahlenfehler then RToken := OZahlenfehler;
    until RToken <> OSpace;
  end;
  if PunktPunktMerk then
  begin
    Setpos(getpos-2);
  end;
  tread := RToken;
end; //TScan.read

function TScanner.TokenOut(Token:EToken): STring; // Test
Var str: String;
begin
  str := 'T: '+TokenStrings[ord(Token)];
  if Token = ORealConst then str := str + '    r:'+floattostr(realWert);
  if Token = OIntegerConst then str := str +'    i:'+inttostr(Intwert);
  if (Token = OStringConst) or ( Token = OIdentifier)  then str := str +'   s:'+text;
  TokenOut := str;
end;

procedure TScanner.SetPos(pos: integer);
begin
   self.pos := pos; 
   Lastchar := ' ';
end;


function TScanner.getPos: Integer;
begin
   getPos := pos;
end;

procedure TScanner.SkipSpace;
Var c: char;
    weiter: Boolean;
begin
   repeat
      c := getchar;
      case ord(c) of
      32,10,13,12: weiter := true;
      0: weiter := false;
      ord('{'): begin
                   repeat
                      c := getchar;
                   until (c = '}') or (ord(c) = 0);
                weiter := true;
                end;
      ord('/'): begin
                   if getchar = '/' then
                   repeat
                      c := getchar;
                   until (ord(c) = 13) or (ord(c) = 0) or (ord(c) = 1);
// nderung 2.10.07  (ord(c) = 1) und if ord(c) = 1 then backchar;
                   if ord(c) = 1 then backchar;
                   weiter := true;
                end;
      else weiter := false;
      end; // case
   until not weiter;
   backchar;
end;

procedure TScanner.getZeileSpalte(Var Zeile,Spalte: integer);
Var i: integer; // Zeilennummer
    weiter: boolean;
begin
   i := 0; weiter := true;
   while ( i <= length(zeilenArray) -1 ) and weiter do
      if Zeilenarray[i] > pos then weiter := false else inc(i);
      Zeile := i -1;
      Spalte := pos - ZeilenArray[i-1];
end;

{ THighLightScanner }

function TFormatClass.FormatProcedure(var s: String;
  GeschweifteKlammerdavoroffen: Boolean; Einruecken: Integer;
  zinfo: TZeilenInformation): integer;
Var pos, posb, posmerk,i: integer;
    fs, text,s1,fs1,hs: string;
    c: char;
    stil: TZeichenStil;
    dieseeinruecken, naechsteeinruecken: integer;
    Inkrement, eingerueckt: integer;
    wennindieserZeile, wiederholeindieserZeile,
      solangeindieserZeile, fuerindieserZeile: integer;
    sternwiederholeInDieserZeile: integer;
    gefunden : boolean;
function getchar: char;
begin
   if pos <= length(s) then
   begin
      c := s[pos];
   end else c := chr(0);
   inc(pos);
   getchar := c;
end;

begin
   wennindieserZeile := 0; wiederholeindieserZeile := 0; solangeindieserZeile := 0; fuerindieserZeile := 0;
   sternwiederholeInDieserZeile := 0;
   Inkrement := 3;
   dieseeinruecken := einruecken; naechsteeinruecken := einruecken;
   pos := 1; fs := '';
   while pos <= length(s) do
   begin
     stil := ZNormal;
     posb := pos; c := getchar;
     if c = '*' then
      begin
         posmerk := pos;
         Text := '';
         Text := Text + c; c := getchar;
         while (CharTable[ord(c)] = OTC) or (CharTable[ord(c)] = OTZ) do //solange Alph oder Ziffer
         begin
            Text := Text + c;
            c := getchar;
         end;
         if myuppercase(Text) = '*WIEDERHOLE' then
         begin
            stil := ZKeyword;
            inc(sternwiederholeInDieserZeile);
            if wiederholeindieserZeile > 0 then dec(wiederholeindieserZeile) else
               dieseeinruecken := dieseeinruecken - Inkrement;
            naechsteeinruecken := naechsteeinruecken - Inkrement;
         end
         else
         if myuppercase(Text) = '*WENN' then
         begin
            stil := ZKeyword;
            if wennindieserZeile > 0 then dec(wennindieserZeile) else
              dieseeinruecken := dieseeinruecken - Inkrement;
            naechsteeinruecken := naechsteeinruecken - Inkrement;
         end
         else
         if myuppercase(Text) = '*SOLANGE' then
         begin
            stil := ZKeyword;
            if solangeindieserZeile > 0 then dec(solangeindieserZeile) else
              dieseeinruecken := dieseeinruecken - Inkrement;
            naechsteeinruecken := naechsteeinruecken - Inkrement;
         end
         else
         if myuppercase(Text) = '*FR' then
         begin
            stil := ZKeyword;
            if fuerindieserZeile > 0 then dec(fuerindieserZeile) else
               dieseeinruecken := dieseeinruecken - Inkrement;
            naechsteeinruecken := naechsteeinruecken - Inkrement;
         end
         else begin pos := posmerk; c := '*'; end;
      end;
     if stil = ZNormal then
       begin
         If (CharTable[ord(c)] = OTC) then
            begin
               Text := '';
               Text := Text + c; c := getchar;
               while (CharTable[ord(c)] = OTC) or (CharTable[ord(c)] = OTZ) do //solange Alph oder Ziffer
               begin
                  Text := Text + c;
                  c := getchar;
               end;
               dec(pos);
               stil := ZNormal; gefunden := false; i := 0;
               while (i <= ord(OFalse)-ord(OFuer)) and (not gefunden) do
               begin
                 text := myuppercase(Text);
                 if comparestr(Text,ResWordsTable[i]) = 0 then
                 begin
                    stil := ZKeyword; gefunden := true;
                    case EToken(Ord(OFuer) + i) of
                    OMethode,OWiederhole, OWenn,OFuer:
                                      naechsteeinruecken := naechsteeinruecken + Inkrement;
                    OSolange: if (wiederholeindieserZeile = 0) and
                                (sternwiederholeInDieserZeile = 0)  then  // Eine wiederhole solange - Kombination
                              // ist faktisch nur eine Spielart der wiederhole-Anweisung, daher nur eine Aktion,
                              // wenn das solange alleine steht.
                              begin
                                 inc(solangeindieserZeile);
                                 naechsteeinruecken := naechsteeinruecken + Inkrement;
                              end;
{                    OSonst: dieseeinruecken := dieseeinruecken - Inkrement;}
                    OEnde:  begin
                              dieseeinruecken := dieseeinruecken - Inkrement;
                              naechsteeinruecken := naechsteeinruecken - Inkrement;
                            end;
                     end; // case
                     case ETOken(Ord(OFuer) + i) of
                     OWiederhole: inc(wiederholeindieserZeile);
                     OWenn: inc(wennindieserZeile);
                     OFuer: inc(fuerindieserZeile);
                     end; // case
                 end;
                 inc(i);
               end;
            end   // Reserved Word oder Identifier
            else if CharTable[ord(c)] = OTZ then  // Zahlenkonstante
            begin
               stil := ZZahl;
               if (pos >= 3) and (s[pos-2] = '-') then fs[pos-2] := chr(Integer(ZZahl));
               while CharTable[ord(c)] = OTZ do c := getchar;
               if (c='e') or (c='E') then
               while CharTable[ord(c)] = OTZ do c := getchar;
               dec(pos);
            end // Zahlenkonstante
            else if c = '/' then
            begin
                if getchar = '/' then
                begin
                   stil := ZComment; pos := length(s)+1;
                end else dec(pos);
            end
            else if c = '{' then
            begin
               GeschweifteKlammerdavoroffen := true;
            end
            else if c = '}' then
            begin
               GeschweifteKlammerdavoroffen := false;
               Stil := ZComment;
            end
            else if c = '''' then
            begin
               repeat
                 c := getchar;
               until (c = '''') or (ord(c) = 0);
               Stil := ZString;
            end;
       end;
     if GeschweifteKlammerdavoroffen then stil := ZComment;
     if pos > length(s)+1 then pos := length(s)+1;
     for i := posb to pos -1 do fs := fs + chr(Integer(stil));
   end;
   fs := fs + chr(Integer(ZNormal));

   // Einrcken!
   //
   if dieseeinruecken < 0 then dieseeinruecken := 0;
   if naechsteeinruecken < 0 then naechsteeinruecken := 0;
   pos := 1;
   while (pos <= Length(s)) and (s[pos] = ' ') do inc(pos);
   dec(pos);
   eingerueckt := dieseeinruecken - pos;
   if (pos <> dieseeinruecken) {and (s <> '')} then
   begin
     s1 := s; fs1 := fs; text := '';hs := '';
     if pos >= 1 then
     begin // Leerzeichen vorne weglschen
        s1 := copy(s,pos + 1,length(s)-pos);
        fs1 := copy(fs,pos + 1,length(fs) - pos);
     end;
     for i := 1 to dieseeinruecken do
     begin
        text := text + ' '; hs := hs + chr(Integer(ZNormal));
     end;
     s := text + s1;
     fs := hs + fs1;
   end;

   zinfo.dieseeinruecken := dieseeinruecken;
   zinfo.FormatString := fs;
   zinfo.GeschweifteKlammeroffen := GeschweifteKlammerdavoroffen;
   zinfo.Einruecken := naechsteeinruecken;
   FormatProcedure := eingerueckt;
end;

procedure TScanner.initStrings(source: TStrings);
Var i: integer;
begin
   bufferString := '';
   for i := 0 to Source.Count - 1 do
   begin
   bufferString := bufferString + Source.Strings[i];
   bufferString := bufferString + chr(13);
   end;
   pos := 1; Spalte := 1; EndOfText := false;
   LastPos := 0; // Wird bentigt, um einen Token zurckzugehen
end;

procedure TScanner.hgetZeileSpalte;
begin
  getZeileSpalte(yZeile,ySpalte);
end;

destructor TScanner.destroy;
begin
  Zeilenarray := nil;
  inherited;
end;

procedure TScanner.StopPositionensetzen;
Var i: integer;
    zi: TZeilenInformation;
begin
   try
     EnterCriticalSection(CriticalSectionProgrammZeilen);
     for i := 0 to shc.Zeile.Count -1 do
     begin
        zi := TZeilenInformation(shc.Zeile.Objects[i]);
        bufferstring[ZeilenArray[i]] := chr(13);
        if zi <> nil then
          if zi.Stop then
              bufferstring[ZeilenArray[i]] := chr(1);
     end;
   finally
     LeaveCriticalSection(CriticalSectionProgrammZeilen);
   end;
end;

end.
