unit UCompilerConstants;

interface

type
TBefehl = ( // Tut nichts:
            BNop,
            // Holt einen Wert vom Konstantenspeicher auf den Stack.
            // Bsp.: KonstantetoStack 15
            // Der Konstantenspeicher ist ein groes TVariant-Feld!
            // WICHTIG: Auf dem Stack liegt dann eine Referenz, die auf
            // den Konstantenspeicher zeigt. Sie darf nicht gelscht werden!
            BKonstantetoStack,
            // Rechenoperationen auf dem Stack. Das Ergebnis ist ein
            // temporrer TVAriant, der auf dem Stack erzeugt wird.
            BAdd, BSub, BMult, BDivide, BMod, BDiv, BAnd, BOr, BNot, BNegiere,
            BKleiner, BGroesser, BKleinerGleich, BGroesserGleich, BGleich, BUngleich,
            // Holt einen Wert auf den Stack
            // Bsp.: BGlobalVartoStack 27
            // Die Nummer bezeichnet den Index im VarSpace
            // Auf dem Stack liegt dann eine Referenz auf den Wert. Sie darf nicht
            // gelscht werden!
            BGlobalVartoStack, BLokalVartoStack,
            // In die Variablen, deren Referenz in Stack[STackpointer -1]
            // liegt, wird der Wert KOPIERT, der in Stack[Stackpointer] liegt
            BZuweisung,
            // BAttributtoStack 10
            // Nimmt das Objekt aus Stack[Stackpointer] heraus,
            // sucht darin das Attribut Nr. 10 und ldt eine Referenz des
            // Wertes dieses Attributs auf den Stack
            BWaehleAttribut,
            // dasselbe mit TMethode; der erzeugte TVariant ist temporr
            BWaehleMethode,
            // ruft die Methode auf, die auf Stack[STackpointer] liegt.
            // die notwendigen Parameter liegen "darunter".
            BMethodenAufruf
            );



implementation

end.

{Bemerkung: Auf dem Stack liegen entweder Referenzen auf TVariants (die nicht
  gelscht werden drfen) oder temporre TVariants (die wieder gelscht werden
  mssen). Die temporren TVariants kommen durch Termberechnung zustande.
  Der Stack fhrt also ein zweites temporaer: Array of Boolean, in dem verzeichnet
  ist, ob die Variablen temporr sind.

{ Beispiele:
   a: Real b,c:Integer
   b := (a+10)*c
      BVarDekl vtDouble 12      // an 12. Stelle im Stringspeicher steht 'a'
      BVarDekl vtInteger 13
      BVarDekl vtInteger 14
      // a,b,c seien an den Stellen 20,21,22 im Globalen VarSpace
      BGlobalVartoStack 21 // b
      BGlobalVartoStack 20 // kopiert a auf den Stack
      BKonstantetoStack 8       // die 10 liegt an 8. STelle im Konstantenspeicher
      BAdd
      BGlobalVartoStack 22
      BMult
      BZuweisung

   wenn b < c dann r.verschiebe(10.0,14) sonst r.links := 20 *wenn
      BGlobalVartoStack 21
      BGlobalVartoStack 22
      BKleiner
      BJumpifNotEqual l1  // l1: sonst...
      BKonstantetoStack 13 // da liegt die 10. Gecastet wird zur Laufzeit!
      BKonstantetoSTack 14 // da liegt die 14
      BGlobalVartoStack 24 // r
      BWaehleMethode 5 // verschiebe ist die 5. methode von r
      BJump l2
   l1:BGlobalVartoStack 24 //r
      BWaehleAttribut 3 // links
      BKonstantetoStack 19 // 20!
      BZuweisung
   l2: ...

   Problem: bei r.verschiebe(10.0,14) mssen zuerst die Parameter auf den
   Stack, dann die Methode.
   Lsung: Whrend des Kompilierens gibt es einen Stack, auf den man Code schieben kann und
   den man dann in Portionen wieder leeren kann.
   TBefehlStack.newFrame // initialisert eine Portion
   TBefehlStack.pushBefehl(b:TBefehl)
   TBefehlStack.pushOperator(i: integer)
   ...
   Abschlieen braucht der Frame nicht. Das tut irgendeine andere Methode
   durch TBefehlSTack.newFrame
   TBefehlStack.Frameleeren // leert den Frame in den Code aus!


   }
