unit UConstants;

interface

type TBasicVarTyp = ( VBoolean, VByte, VWord, VInteger, VReal,VDouble,
                      VChar, VString, VArray,VRecord,VClass,VEnum,VPointer,
                      VNone ); // VNone ist der Rckgabewert einer Prozedur

type EToken = ( OTC, OTZ, OTS, OTA, OTN, // Alphabet, Ziffer, Space, Sonst, Verboten
                OEOF, OZeiger, OAdresse, OAnfZeich, OGeschweiftAuf, OGeschweiftZu,ODoppelpunkt,
                OKlammAuf, OKlammZu, OEckAuf, OEckZu, OStrichpunkt, OKomma, OPunkt,
                OMal, OGeteilt, OPlus, OMinus,
                OGleich,OGroesser, OKleiner,
                OGroessergleich, OKleinergleich, OUngleich, OPunktPunkt, ODoppelpunktgleich,
                OFuer, OWiederhole, OSternWiederhole,OImmer, OMalWort,
                OSolange, OSternsolange, OTue, Obis, OMethode,OEnde,
                OVar, OWenn, OSternWenn, ODann, OSonst, OSternFuer,
                OBoolean, OInteger,OReal, OChar,OString,
                ONot, OAnd, OOr,OTrue,OFalse,OIdentifier,
                OIntegerconst, ORealConst, OStringConst, OSpace, OGleichGleich,
                OStop, OZahlenfehler );
const TokenStrings: Array[0..ord(high(EToken))] of String = (
                'OTC', 'OTZ', 'OTS', 'OTA', 'OTN', // Alphabet, Ziffer, Space, Sonst, Verboten
                'OEOF', 'Zeiger(^)','Adresse(@)','OAnfZeich', 'OGeschweiftAuf',  'OGeschweiftZu', 'ODoppelpunkt',
                'Klammer auf', 'Klammer zu', 'Eckige Klammer auf', 'Eckige Klammer zu', 'Strichpunkt', 'Komma','Punkt',
                'OMal', 'OGeteilt', 'OPlus', 'OMinus',
                'OGleich','OGroesser', 'OKleiner',
                'OGroessergleich', 'OKleinergleich', 'OUngleich', 'PunktPunkt','Doppelpunktgleich',
                'Fr', 'Wiederhole','*Wiederhole', 'Immer','Mal',
                'Solange', '*Solange', 'tue', 'Bis','Methode','Ende',
                'Var', 'Wenn', '*Wenn', 'Dann','Sonst','*Fr',
                'Boolean', 'Integer', 'Real', 'Char', 'String',
                'Nicht','Und','Oder','Wahr','falsch','OIdentifier',
                'OIntegerconst', 'ORealConst', 'OStringConst', 'OSpace','OGleichGleich',
                'OStop','OZahlenfehler' );

     ResWordsTable: Array [0..ord(OFalse)-ord(OFuer)] of String = (
     'FR','WIEDERHOLE','*WIEDERHOLE','IMMER','MAL',
     'SOLANGE','*SOLANGE','TUE','BIS','METHODE','ENDE',
     'VAR','WENN','*WENN','DANN','SONST','*FR',
     'BOOLEAN', 'INTEGER',
     'REAL','CHAR','STRING','NICHT','UND','ODER','WAHR','FALSCH');

     CharTable : Array [0..255] of EToken = (
     OTN,OTA,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTS,OTN,OTN,OTN,OTS,OTN,OTN, // 0 - 15
     OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN, // 16-31
     OTS,OTA,OTA,OTA,OTA,OTA,OTA,OAnfZeich, OKlammAuf, OKlammZu, OMal,
     OPlus, OKomma, OMinus, OPunkt, OGeteilt,                         // 32-47
     OTZ,OTZ,OTZ,OTZ,OTZ,OTZ,OTZ,OTZ,OTZ,OTZ,ODoppelpunkt, OStrichpunkt,
     OKleiner, OGleich, OGroesser,OTS,                                // 48-63
     OAdresse,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC, // 64 - 79
     OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OEckAuf,OTA,OEckZu,OZeiger,OTC, //80-95
     OTA,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC, // 96-111
     OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OGeschweiftAuf, OTA,OGeschweiftZu,OTA, OTN, // 112-127
     OTA,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN, //128-143
     OTN,OTA,OTA,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN,OTN, //144-159
     OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA, //160-175
     OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA,OTA, //176-191
     OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC, //192-207
     OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC, //208-223
     OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC, //224-239
     OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC,OTC); //240-255

implementation

end.
