unit UKlassen;

interface

uses SysUtils,classes, forms, Graphics, Controls, ExtCtrls,
     UDaten, UZeichenfenster, Types;

const PI = 3.1415926535897932384626433832795028841;
      ZPId360 = 0.01745329251994329576923690768488;
      PIh = PI/2;
type
TGruppe = class;
TLineSegment = Record
                 x1,y1,x2,y2: double;
                 Farbe: TColor;
                 Linienart: word;
                 Linienstaerke: word;
               end;

TPunkt = Record
              x,y: double;
         end;

TRichtung = (RLinksRechts,RObenUnten);

TFenster = class(Tobjekt)
   private
      x,y,breite,hoehe,aname: TAttribut;
      strichabstand: TAttribut;
      Hintergrundfarbe, Gitterfarbe: TAttribut;
   public
      form: TFZeichnen;

     procedure verschiebe(x,y: Integer);
     procedure addObjekt(o: TObjekt);
     procedure removeObjekt(o: TOBjekt);
     procedure zeichne;

     function Kopie(fName: string; owner: TObjekt): TObjekt; override;
     procedure paint(c: TDrawCanvas); override; // leer
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;

     constructor create(fName: String; Owner: TObjekt; inheritedFlag: Boolean); // ci := 41
     destructor destroy; override;
end;


TFarbe = class(Tobjekt)
   private
     r,g,b: TAttribut;
   public
     color: TColor;
     procedure setzergb(r,g,b: integer);
     procedure setzefarbe(c:TColor);
     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     procedure copyfrom(o: TObjekt); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);  // ci := 67
     destructor destroy; override;
end;


TFigur = class(TObjekt)
   private
     linksalt, rechtsalt, obenalt, untenalt: double;
     flinks,frechts,foben,Funten: double;
     links,oben,rechts,unten: TAttribut;
     Rahmenfarbe, Rahmenstaerke, Linienart: TAttribut;
     sichtbar: TAttribut;
     Breite, Hoehe: TAttribut;

     msetzeEcken, msetzeLinksOben, msetzerechtsunten:TMethode;
     mverschiebenach, mdrehe, mstrecke, mdrehenUm: TMethode;
     mstreckenAn: TMethode;

     procedure setzeEcken(links,oben,rechts,unten: integer);
     procedure setzeLinksOben(links,oben: integer); virtual;
     procedure setzerechtsunten(rechts,unten: integer);
     procedure strecken(faktor: double);
     procedure verschiebenach(links,oben: integer);
     procedure DrehePunktUm(var x,y:integer; dx,dy: double; Winkel: double); overload;
     procedure DrehePunktUm(var x,y:double; dx,dy: double; Winkel: double); overload;
   public
     procedure setzeAttributelinksrechtsobenunten;
     procedure verschiebe(dx,dy: integer); virtual;
     procedure copyfrom(o: TObjekt); override;

     procedure strecke(faktor: double; vonKoordinatex, vonKoordinatey: double); virtual;
     procedure spieglex(Achse:double); virtual;
     procedure spiegley(Achse:double); virtual;
     procedure drehe(dx,dy,Winkel: double); virtual;

     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean); // ci := 2
     destructor destroy; override;
end;

TTurtle = class(TFigur)
   private
     Farbe, Linienstaerke: TAttribut;

     turtlesichtbar: TAttribut;

     turtleX,turtleY: TAttribut;
     kurs: TAttribut;

     penstate: boolean;
     x,y, Richtung: double;  // x,y in Bildschirmkoo, Richtung in Grad
     xneu,yneu: double;
     Segmente: Array of TLineSegment;
     SegmentCount: integer; // Anzahl der gezeichneten
     SegmentSpace: integer; // Anzahl der reservierten
     Aufpunkt, VorPunkt: Boolean;

     procedure pforward(n: double);
     procedure pback(n: double);
     procedure setXY(y,x: double);
     procedure left(n: double);
     procedure right(n: double);
     procedure pendown;
     procedure penup;
     procedure clearall;


     procedure Richtungnormalisieren;
     procedure createSegment;
     procedure GrenzenSetzen;
   public
     procedure TestAufVorPunkt(c:TDrawCanvas);
     procedure verschiebe(dx,dy: integer); override;
     procedure copyfrom(o: TObjekt); override;
     procedure drehe(dx,dy,Winkel: double); override;

     procedure strecke(faktor: double; vonKoordinatex, vonKoordinatey: double); override;
     procedure spieglex(Achse:double); override;
     procedure spiegley(Achse:double); override;

     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean); // ci := 2 * 31
     destructor destroy; override;

end;




TGefuellteFigur = class(TFigur)
   private
     Fuellfarbe, Fuellart: TAttribut;
   public

     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure copyfrom(o: TObjekt); override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);   // ci := 4
     destructor destroy; override;
end;

TLinie = class(TFigur)
  private
     fx1,fy1,fx2,fy2: double;
     x1,y1,x2,y2: TAttribut;
     Farbe, Dicke: TAttribut;
     procedure setzePunkt1(x,y: integer);
     procedure setzePunkt2(x,y: integer);
     procedure setzePunkte(x1,y1,x2,y2: integer);
  public
     procedure setzeAttributex1y1x2y2;
     procedure strecke(faktor: double; vonKoordinatex, vonKoordinatey: double); override;
     procedure spieglex(Achse:double); override;
     procedure spiegley(Achse:double); override;
     procedure drehe(dx,dy,Winkel: double); override;
     procedure verschiebe(dx,dy: integer); override;

     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure copyfrom(o: TObjekt); override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);  // ci := 2*23
     destructor destroy; override;
end;

TGruppe = class(TGefuellteFigur)
  private
     flinksalt,frechtsalt,fobenalt,funtenalt: double;
     figur: TList; // Hier sind die Elemente der Gruppe drin
     kopien: TList; // Hier wird vermerkt, welche Unterobjekte Kopien sind
                    // und daher entsorgt werden mssen.
     procedure korrigiereobenuntenlinksrechts;
  public
     procedure ermittleGrenzen;

     procedure strecke(faktor: double; vonKoordinatex, vonKoordinatey: double); override;
     procedure spieglex(Achse:double); override;
     procedure spiegley(Achse:double); override;
     procedure verschiebe(dx,dy: Integer); override;
     procedure drehe(dx,dy,Winkel: double); override;

     // wird vor jeder Streckung aufgerufen
     procedure testGrenzen;

     procedure kopiereObjekt(o: TFigur; schlucken: boolean);
     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure copyfrom(o: TObjekt); override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);  // ci := 4*29
     destructor destroy; override;
end;

TRechteck = class(TGefuellteFigur)
   private
     wurdegedreht: boolean;
     Ecken: Array[1..4] of TPunkt;
     ZeichenPUnkte: Array[1..4] of TPoint;
   public
     procedure strecke(faktor: double; vonKoordinatex, vonKoordinatey: double); override;
     procedure spieglex(Achse: double); override;
     procedure spiegley(Achse: double); override;
     procedure verschiebe(dx,dy: Integer); override;
     procedure drehe(dx,dy,Winkel: double); override;
//     procedure setzelinksoben(links,oben: integer); override;
     procedure Grenzensetzen;

     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure copyfrom(o: TObjekt); override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);  // ci := 16
     destructor destroy; override;
end;

TTextfeld = class(TRechteck)
   private
     Zeile: TStrings;
     GroesseAutomatischAnpassen: TAttribut;
     procedure ZeileHinzufuegen(text: string);
     procedure Loeschen;
     procedure GroesseAnpassen;
   public
     ausrichtunghorizontal, ausrichtungvertikal: TAttribut;
     schriftart,schriftgroesse,schriftfarbe,durchsichtig: TAttribut;
     procedure strecke(faktor: double; vonKoordinatex, vonKoordinatey: double); override;
     // vorerst ohne Funktion
     procedure drehe(dx,dy,Winkel: double); override;

     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure copyfrom(o: TObjekt); override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);  // ci := 16
     destructor destroy; override;
end;


TQuadrat = class(TRechteck)
   private
   Seitenlaenge: TAttribut;
   FSeitenlaenge: double;
   // Keine eigenen Attribute, nur die "geerbten"
   public
     procedure qstrecke(faktor: double; Richtung: TRichtung; vonKoordinate: integer);
     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure copyfrom(o: TObjekt); override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);  // ci := 32
     destructor destroy; override;
end;

TEllipse = class(TGefuellteFigur)
   private
      Radiusx,Radiusy, Mittex,Mittey: TAttribut;
      FRadiusx,FRadiusy,FMittex,FMittey: double;
      winkel: double;

      // Fr welche Werte wurde als letzes gezeichnet?
      prx,pry,pmx,pmy: Integer;
      mx,my: integer;
      pwinkel: double;
      punkte: Array of TPoint;

   public
     procedure setzeAttributeVonDouble;
     procedure strecke(faktor: double; vonKoordinatex, vonKoordinatey: double); override;
     procedure spieglex(Achse: double); override;
     procedure spiegley(Achse: double); override;
     procedure verschiebenach(x,y: integer);
     procedure drehe(dx,dy,Winkel: double); override;
     procedure Grenzensetzen;


     procedure verschiebe(dx,dy: integer);  override;
     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure copyfrom(o: TObjekt); override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);  // ci := 4*11
     destructor destroy; override;
end;

TKreis = class(TGefuellteFigur)
   private
   dRadius, dMittex, dMittey: double;
   Radius: TAttribut;
   Mittex,Mittey: TAttribut;
   procedure aktualisiereAttribute;
   public
     procedure strecke(faktor: double; vonKoordinatex, vonKoordinatey: double); override;
     procedure spieglex(Achse: double); override;
     procedure spiegley(Achse: double); override;
     procedure verschiebenach(x,y: integer);
     procedure drehe(dx,dy,Winkel: double); override;


     procedure verschiebe(dx,dy:integer); override;
     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure copyfrom(o: TObjekt); override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);  // ci := 4*13
     destructor destroy; override;
end;


TDreieck = class(TGefuellteFigur)
   private
   Punkte: Array[1..3] of TPunkt;
   ZeichenPunkte: Array[1..3] of TPoint;
   procedure setzePunkte(x1,y1,x2,y2,x3,y3: integer);
   procedure grenzenueberpruefen;
   public
     procedure strecke(faktor: double; vonKoordinatex, vonKoordinatey: double); override;
     procedure spieglex(Achse: double); override;
     procedure spiegley(Achse: double); override;
     procedure verschiebe(dx,dy:integer); override;
     procedure drehe(dx,dy,Winkel: double); override;
     procedure drehen(Winkel: double);

     function Kopie(Name: string; owner: TObjekt): TObjekt; override;
     procedure copyfrom(o: TObjekt); override;
     procedure attributaenderung(a: TAttribut); override;
     procedure methodenaufruf(Nummer: Integer; stack: TStack); override;
     procedure paint(c: TDrawCanvas); override;
     constructor create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);  // ci := 4*91
     destructor destroy; override;
end;



TKlassenFabrik = class(Tobject)
  public
  Klassenliste: TList;
  function erstelleObjekt(KlassenName, ObjektName: String; Owner: TObjekt):TObjekt;
  function gibtes(Klassenname:String): Boolean;
  function getci(Klassenname: String): Integer;
  function getKlasse(ci: integer):TObjekt;
  function getKLasseByName(name: String):TObjekt;
  constructor create;
  destructor destroy; override;
end;


implementation



{ TFarbe }

procedure TFarbe.attributaenderung(a: TAttribut);
begin
  inherited;
  if r.Wert.i < 0 then r.Wert.i := 0;
  if r.Wert.i > 255 then r.Wert.i := 255;
  if g.Wert.i < 0 then g.Wert.i := 0;
  if g.Wert.i > 255 then g.Wert.i := 255;
  if b.Wert.i < 0 then b.Wert.i := 0;
  if b.Wert.i > 255 then b.Wert.i := 255;
  color := r.Wert.i + 256 * g.Wert.i + 256*256*b.Wert.i;
end;

procedure TFarbe.copyfrom(o: TObjekt);
var f: TFarbe;
begin
  inherited;
  f := TFarbe(o);
  setzergb(f.r.Wert.i,f.g.Wert.i,f.b.Wert.i);
end;

constructor TFarbe.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
var m: TMethode;
begin
   inherited create(Name, Owner, true);
   ci := 67; Klassenname := 'FARBE';

   // Methoden registrieren

   m := TMethode.create('setzergb',self,1,vtKeiner,0);
   m.addparameter('Rotwert',vtInteger,0);
   m.addparameter('Grnwert',vtInteger,0);
   m.addparameter('Blauwert',vtInteger,0);
   AddMethode(m);

   // Attribute registrieren
   r := TAttribut.create('rot',self,vtInteger,0);
   AddAttribut(r);
   g := TAttribut.create('grn',self,vtInteger,0);
   AddAttribut(g);
   b := TAttribut.create('blau',self,vtInteger,0);
   AddAttribut(b);
   // Attribute initialisieren
   r.Wert.i := 0; g.Wert.i := 0; b.Wert.i := 0;

   CreateSetzeMethoden(inheritedFlag);
end;

destructor TFarbe.destroy;
begin
  inherited destroy;
end;

function TFarbe.Kopie(Name: string; owner: TObjekt): TObjekt;
Var f: TFarbe;
begin
   f := TFarbe.create(Name,Owner,false);
   f.copyfrom(self);
   kopie := f;
end;

procedure TFarbe.methodenaufruf(Nummer: Integer; stack: TStack);
begin
   case Nummer of
   1: setzergb(stack.popInteger, stack.popInteger, stack.popInteger);
   end; // case;
end;

procedure TFarbe.paint(c: TDrawCanvas);
begin
  inherited;
end;

procedure TFarbe.setzergb(r,g,b: integer);
begin
   self.r.Wert.i := r; self.g.Wert.i := g; self.b.Wert.i := b;
   attributaenderung(nil);
end;

procedure TFarbe.setzefarbe(c: TColor);
begin
   r.Wert.i := c and $FF;
   g.wert.i := (c and $FF00) div $100;
   b.wert.i := (c and $FF0000) div $10000;
   color := c;
end;

{ TFigur }

procedure TFigur.attributaenderung(a: TAttribut);
//var z: integer;
begin
  inherited;
  if links.wert.i > rechts.wert.i then
  begin
     if a = links then
     begin
        rechts.Wert.i := links.Wert.i + round(rechtsalt - linksalt);
        frechts := rechts.wert.i;
     end;
     if a = rechts then
     begin
        links.Wert.i := rechts.Wert.i - round(rechtsalt - linksalt);
        flinks := links.wert.i;
     end;
  end;

  if oben.wert.i < unten.Wert.i then
  begin
     if a = unten then
     begin
       oben.wert.i := unten.wert.i + round(obenalt - untenalt);
       foben := oben.wert.i;
     end;
     if a = oben then
     begin
       unten.wert.i := oben.wert.i - round(obenalt - untenalt);
       funten := unten.wert.i;
     end;
  end;

  if ( a <> breite) and (a <> hoehe) then
  begin
    breite.Wert.i := abs(links.Wert.i - rechts.Wert.i);
    hoehe.wert.i := abs(oben.wert.i - unten.wert.i);
  end;

  flinks := links.wert.i;
  frechts := rechts.wert.i;
  foben := oben.wert.i;
  funten := unten.wert.i;

  obenalt := foben;
  untenalt := funten;
  rechtsalt := frechts;
  linksalt := flinks;

end;

procedure TFigur.copyfrom(o: TObjekt);
begin
  inherited copyfrom(o);
  flinks := TFigur(o).flinks;
  frechts := TFigur(o).frechts;
  foben := TFigur(o).foben;
  funten := TFigur(o).funten;

  setzeAttributelinksrechtsobenunten;

  sichtbar.wert.b := TFigur(o).sichtbar.wert.b;

  Rahmenstaerke.Wert.i := TFigur(o).Rahmenstaerke.wert.i;
  Linienart.Wert.i := TFigur(o).Linienart.Wert.i;
  TFarbe(Rahmenfarbe.Wert.o).copyfrom(TFigur(o).Rahmenfarbe.wert.o);
end;

constructor TFigur.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
Var m: TMethode;
begin
   ci := 2; KLassenname := 'FIGUR';
   inherited create(Name, Owner,true);

   // Methoden registrieren

   m := TMethode.create('verschieben',self,1,vtKeiner,0);
   m.addparameter('x-Verschiebung',vtInteger,0);
   m.addparameter('y-Verschiebung',vtInteger,0);
   AddMethode(m);

   m := TMethode.create('eckenSetzen',self,7,vtKeiner,0);
   m.addparameter('links',vtInteger,0);
   m.addparameter('oben',vtInteger,0);
   m.addparameter('rechts',vtInteger,0);
   m.addparameter('unten',vtInteger,0);
   AddMethode(m); msetzeEcken := m;

   m := TMethode.create('linksObenSetzen',self,8,vtKeiner,0);
   m.addparameter('links',vtInteger,0);
   m.addparameter('oben',vtInteger,0);
   AddMethode(m); msetzeLinksOben := m;

   m := TMethode.create('rechtsUntenSetzen',self,9,vtKeiner,0);
   m.addparameter('rechts',vtInteger,0);
   m.addparameter('unten',vtInteger,0);
   AddMethode(m); msetzerechtsunten := m;

   m := TMethode.create('strecken',self,30,vtKeiner,0);
   m.addparameter('Streckugsfaktor',vtDouble,0);
   AddMethode(m);
   mstrecke := m;

   m := TMethode.create('verschiebenNach',self,31,vtKeiner,0);
   m.addparameter('links',vtInteger,0);
   m.addparameter('oben',vtInteger,0);
   AddMethode(m); mverschiebenach := m;

   m := TMethode.create('drehen',self,45,vtKeiner,0);
   m.addparameter('Drehwinkel',vtDouble,0);
   AddMethode(m); mdrehe := m;

   m := TMethode.create('drehenUm',self,146,vtKeiner,0);
   m.addparameter('X-Koord. Drehpunkt',vtInteger,0);
   m.addparameter('Y-Koord. Drehpunkt',vtInteger,0);
   m.addparameter('Drehwinkel',vtDouble,0);
   AddMethode(m); mdrehenUm := m;

   m := TMethode.create('streckenAn',self,147,vtKeiner,0);
   m.addparameter('x-Koord. Zentrum',vtInteger,0);
   m.addparameter('y-Koord. Zentrum',vtInteger,0);
   m.addparameter('Faktor',vtDouble,0);
   AddMethode(m); mstreckenAn := m;

   // Attribute registrieren
   sichtbar := TAttribut.create('sichtbar',self,vtBoolean,0);
   AddAttribut(sichtbar);
   sichtbar.Wert.b := true;
   links := TAttribut.create('links',self,vtInteger,0);
   AddAttribut(links);
   oben := TAttribut.create('oben',self,vtInteger,0);
   AddAttribut(oben);
   rechts := TAttribut.create('rechts',self,vtInteger,0);
   AddAttribut(rechts);
   unten := TAttribut.create('unten',self,vtInteger,0);
   AddAttribut(unten);
   Rahmenstaerke := TAttribut.create('randstrke',self,vtInteger,0);
   AddAttribut(Rahmenstaerke);
   Linienart := TAttribut.create('randart',self,vtInteger,0);
   AddAttribut(Linienart);
   Rahmenfarbe := TAttribut.create('randfarbe',self,vtObjekt,67);
   Rahmenfarbe.Wert.o := TFarbe.create('',self,false);
   AddAttribut(Rahmenfarbe);

   Breite := TAttribut.create('breite',self,vtInteger,0);
   AddAttribut(Breite);

   Hoehe := TAttribut.create('hhe',self,vtInteger,0);
   AddAttribut(Hoehe);

   // Attribute initialisieren
   links.Wert.i := -10; rechts.Wert.i := 10; oben.Wert.i := 10; unten.Wert.i := -10;
   flinks := -10; frechts := 10; foben := 10; funten := -10;
   breite.Wert.i := 20; Hoehe.Wert.i := 20;
   Rahmenstaerke.Wert.i := 1; Linienart.Wert.i := Integer(psSolid);

   CreateSetzeMethoden(inheritedFlag);
end;

destructor TFigur.destroy;
begin

  inherited;
end;

procedure TFigur.DrehePunktUm(var x, y: integer; dx, dy: double;
  Winkel: double);
var cosw,sinw: double;
    sx,sy: double;
begin
    sinw := sin(winkel * ZPId360); cosw := cos(winkel * zPId360);
    sx := x - dx; sy := y - dy;
    x := round( dx + ( sx*cosw - sy*sinw) );
    y := round( dy + ( sx*sinw + sy*cosw) );
end;

procedure TFigur.drehe(dx, dy, Winkel: double);
begin

end;

procedure TFigur.DrehePunktUm(var x, y: double; dx, dy: double;
  Winkel: double);
var cosw,sinw: double;
    sx,sy: double;
begin
    sinw := sin(winkel * ZPId360); cosw := cos(winkel * zPId360);
    sx := x - dx; sy := y - dy;
    x := dx + ( sx*cosw - sy*sinw);
    y := dy + ( sx*sinw + sy*cosw);
end;

function TFigur.Kopie(Name: string; owner: TObjekt): TObjekt;
Var f: TFigur;
begin
  f := TFigur.create(Name, Owner,false);
  f.copyfrom(self);
  Kopie := f;
end;

procedure TFigur.methodenaufruf(Nummer: Integer; stack: TStack);
var l,o,r,u: integer;
    dx,dy,zx,zy: integer;
    w,faktor: double;
begin
inherited;
  linksalt := flinks; rechtsalt := frechts;
  obenalt := foben; untenalt := funten;
  case Nummer of
  1: verschiebe(stack.popInteger,stack.popInteger);
  7: begin
     u := stack.popInteger; r := stack.popInteger;
     o := stack.popInteger; l := stack.popInteger;
     setzeEcken(l,o,r,u);
     end;
  8: setzeLinksOben(stack.popInteger,stack.popInteger);
  9: setzerechtsunten(stack.popInteger,stack.popInteger);
  30: begin
         strecken(stack.popdouble);
      end;
  31: verschiebenach(stack.popInteger,stack.popInteger);
  45: drehe((frechts + flinks)/2,
            (foben + funten)/2,
              stack.popdouble);
  146: begin
         w := stack.popdouble;
         dy := stack.popInteger;
         dx := stack.popInteger;
         drehe(dx,dy,w);
       end;
  147: begin
         faktor := stack.popdouble;
         zy := stack.popInteger;
         zx := stack.popInteger;
         strecke(faktor,zx,zy);
       end;
  end; // case
end;

procedure TFigur.paint(c: TDrawCanvas);
begin
  inherited;
  if sichtbar.Wert.b then
  begin
    c.c.Pen.Width := Rahmenstaerke.Wert.i;
    c.c.Pen.Style := TPenStyle(Linienart.Wert.i);
    c.c.Pen.Color := TFarbe(Rahmenfarbe.wert.o).color;
  end;
end;

procedure TFigur.setzeEcken(links, oben,rechts, unten: integer);
begin
   flinks := links; frechts := rechts;
   foben := oben; funten := unten;
   setzeAttributelinksrechtsobenunten;
   Attributaenderung(nil);
end;

procedure TFigur.setzeLinksOben(links,oben: integer);
begin
   verschiebenach(links,oben);
   //flinks := links; foben := oben;
   //setzeAttributelinksrechtsobenunten;
   //Attributaenderung(nil);
end;

procedure TFigur.setzerechtsunten(rechts,unten: integer);
begin
   frechts := rechts; funten := unten;
   setzeAttributelinksrechtsobenunten;
   Attributaenderung(nil);
end;

procedure TFigur.spieglex(Achse: double);
var z: double;
begin
   flinks := Achse - (flinks - Achse);
   frechts := Achse - (frechts - Achse);
   z := flinks; flinks := frechts;
   frechts := z;
   setzeAttributelinksrechtsobenunten;
end;

procedure TFigur.spiegley(Achse: double);
var z: double;
begin
   foben := Achse - (foben - Achse);
   funten := Achse - (funten - Achse);
   z := foben; foben := funten; funten := z;
   setzeAttributelinksrechtsobenunten;
end;

procedure TFigur.strecke(faktor: double; vonKoordinatex, vonKoordinatey: double);
begin
   if abs(vonKoordinatex + (frechts - vonKoordinatex)*faktor) < 100000 then
   frechts := vonKoordinatex + (frechts - vonKoordinatex)*faktor;
   if abs(vonKoordinatex + (flinks - vonKoordinatex)*faktor) < 100000 then
   flinks := vonKoordinatex + (flinks - vonKoordinatex)*faktor;
   if abs(vonKoordinatey + (foben - vonKoordinatey)*faktor) < 100000 then
   foben := vonKoordinatey + (foben - vonKoordinatey)*faktor;
   if abs(vonKoordinatey + (funten - vonKoordinatey)*faktor) < 100000 then
   funten := vonKoordinatey + (funten - vonKoordinatey)*faktor;

   setzeAttributelinksrechtsobenunten;
end;

procedure TFigur.strecken(faktor: double);
begin
   if abs(faktor) > 0.00001 then
      strecke(faktor,(flinks + frechts)/2,(foben + funten)/2);
   Attributaenderung(nil);
end;

procedure TFigur.verschiebe(dx, dy: integer);
begin
   flinks := flinks + dx;
   frechts := frechts + dx;
   foben := foben + dy;
   funten := funten + dy;
   setzeAttributelinksrechtsobenunten;
end;

procedure TFigur.verschiebenach(links, oben: integer);
begin
    verschiebe(round(links - flinks),round(oben - foben));
end;

procedure TFigur.setzeAttributelinksrechtsobenunten;
Var z: double;
begin
   if flinks > frechts then
   begin
      z := flinks; flinks := frechts; frechts := z;
   end;
   if funten > foben then
   begin
      z := funten; funten := foben; foben := z;
   end;

   if abs(flinks) < 100000 then
   links.Wert.i := round(flinks);
   if abs(frechts) < 100000 then
   rechts.Wert.i := round(frechts);
   if abs(foben) < 100000 then
   oben.Wert.i := round(foben);
   if abs(funten) < 100000 then
   unten.Wert.i := round(funten);

   breite.wert.i := rechts.wert.i - links.wert.i;
   hoehe.wert.i := oben.Wert.i - unten.wert.i;

end;

{ TRechteck }

procedure TRechteck.attributaenderung(a: TAttribut);
begin
  if a = breite then
     if breite.wert.i >= 0 then
     begin
        rechts.wert.i := links.wert.i + breite.wert.i;
        a := rechts;
     end;
  if a = hoehe then
     if hoehe.wert.i >= 0 then
     begin
        unten.wert.i := oben.wert.i - hoehe.wert.i;
        a := unten;
     end;
  inherited attributaenderung(a);
end;

procedure TRechteck.copyfrom(o: TObjekt);
var r: TRechteck;
    i: integer;
begin
  inherited;
  r := TRechteck(o);
  wurdegedreht := r.wurdegedreht;
  for i := 1 to 4 do
     Ecken[i] := r.Ecken[i];
end;

constructor TRechteck.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
begin
   inherited create(Name,Owner,true);
   wurdegedreht := false;
   ci := 16; zeichenbar := true; Klassenname := 'RECHTECK';

   CreateSetzeMethoden(inheritedFlag);
end;

destructor TRechteck.destroy;
begin
  inherited destroy;
end;

procedure TRechteck.drehe(dx, dy, Winkel: double);
var i: integer;
begin
   if not wurdegedreht then
   begin
      Ecken[1].X := links.Wert.i; Ecken[1].Y := oben.wert.i;
      Ecken[2].X := links.wert.i; Ecken[2].y := unten.Wert.i;
      Ecken[3].X := rechts.wert.i; Ecken[3].Y := unten.wert.i;
      Ecken[4].x := rechts.wert.i; Ecken[4].y := oben.wert.i;
      wurdegedreht := true;
   end;
   for i := 1 to 4 do
      DrehePunktUm(Ecken[i].x,Ecken[i].y,dx,dy,winkel);
   Grenzensetzen;
end;

procedure TRechteck.Grenzensetzen;
Var i,xmin,ymin,xmax,ymax: integer;
begin
    xmin := 10000; ymin := 10000; xmax := -10000; ymax := -10000;
    for i := 1 to 4 do
    begin
       if Ecken[i].X < xmin then xmin := round(Ecken[i].X);
       if Ecken[i].X > xmax then xmax := round(Ecken[i].X);
       if Ecken[i].y < ymin then ymin := round(Ecken[i].y);
       if Ecken[i].y > ymax then ymax := round(Ecken[i].y);
    end;
    flinks := xmin; frechts := xmax;
    foben := ymax; funten := ymin;
    setzeAttributelinksrechtsobenunten;
end;

function TRechteck.Kopie(Name: string; owner: TObjekt): TObjekt;
Var r: TRechteck;
begin
  r := TRechteck.create(name, owner,false);
  r.copyfrom(self);
  Kopie := r;
end;

procedure TRechteck.methodenaufruf(Nummer: Integer; stack: TStack);
begin
  inherited methodenaufruf(Nummer,stack);
end;

procedure TRechteck.paint(c: TDrawCanvas);
var x1,x2,y1,y2,i: integer;
begin
  inherited paint(c);
  if sichtbar.wert.b then
  begin
  if wurdegedreht then
  begin
    for i := 1 to 4 do
    begin
       ZeichenPunkte[i].X := c.xWtoScr(Ecken[i].x);
       ZeichenPunkte[i].y := c.yWtoScr(Ecken[i].y);
    end;
    c.c.Polygon(ZeichenPunkte);
  end else
  begin
    x1 := c.xWtoScr(links.wert.i); x2 := c.xWtoScr(rechts.wert.i);
    y1 := c.yWtoScr(oben.wert.i); y2 := c.yWtoScr(unten.wert.i);
    c.c.Rectangle(x1,y1,x2+1,y2+1);
  end;
  end;
end;

{procedure TRechteck.setzelinksoben(links, oben: integer);
begin
   verschiebe(links - self.links.wert.i,oben - self.oben.wert.i);
end;
}

procedure TRechteck.spieglex(Achse: double);
Var i: integer;
begin
   if not wurdegedreht then inherited
   else
   begin
      for i := 1 to 4 do
      begin
         Ecken[i].x := Achse - (Ecken[i].x - Achse);
      end;
      Grenzensetzen;
   end;
end;

procedure TRechteck.spiegley(Achse: double);
Var i: integer;
begin
   if not wurdegedreht then inherited
   else
   begin
      for i := 1 to 4 do
      begin
         Ecken[i].y := Achse - (Ecken[i].y - Achse);
      end;
      Grenzensetzen;
   end;
end;

procedure TRechteck.strecke(faktor: double; vonKoordinatex, vonKoordinatey: double);
Var i: integer;
begin
   if not wurdegedreht then inherited
   else
   begin
      for i := 1 to 4 do
      begin
         if abs( vonKoordinatex + (Ecken[i].x - vonkoordinatex)*faktor) < 100000 then
            Ecken[i].X := ( vonKoordinatex + (Ecken[i].x - vonkoordinatex)*faktor);
         if abs( vonKoordinatey + (Ecken[i].y - vonkoordinatey)*faktor) < 100000 then
            Ecken[i].y := ( vonKoordinatey + (Ecken[i].y - vonkoordinatey)*faktor);
      end;
      Grenzensetzen;
   end;
end;

procedure TRechteck.verschiebe(dx, dy: Integer);
Var i: integer;
begin
   if not wurdegedreht then inherited
   else
   begin
      for i := 1 to 4 do
      begin
         Ecken[i].x := Ecken[i].x + dx;
         Ecken[i].y := Ecken[i].y + dy;
      end;
      Grenzensetzen;
   end;
end;

{ TGefuellteFigur }

procedure TGefuellteFigur.attributaenderung(a: TAttribut);
begin
  inherited attributaenderung(a);
end;

procedure TGefuellteFigur.copyfrom(o: TObjekt);
begin
  inherited copyfrom(o);
    TFarbe(FuellFarbe.Wert.o).copyfrom(TGefuellteFigur(o).FuellFarbe.wert.o);
    Fuellart.Wert.i := TGefuellteFigur(o).Fuellart.Wert.i;
end;

constructor TGefuellteFigur.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
begin
   inherited create(Name, Owner,true);
   ci := 4; Klassenname := 'GEFLLTEFIGUR';

   // Attribute registrieren
   Fuellfarbe := TAttribut.create('fllfarbe',self,vtObjekt,67);
   Fuellfarbe.Wert.o := TFArbe.create('',self,false);
   TFarbe(Fuellfarbe.Wert.o).setzergb(255,255,255);
   addAttribut(Fuellfarbe);

   Fuellart := TAttribut.create('fllart',self,vtInteger,0);
   addAttribut(Fuellart);

   // Attribute initialisieren
   Fuellart.Wert.i := Integer(bsSolid);

   CreateSetzeMethoden(inheritedFlag);
end;

destructor TGefuellteFigur.destroy;
begin
  inherited;
end;

function TGefuellteFigur.Kopie(Name: string; owner: TObjekt): TObjekt;
Var g: TGefuellteFigur;
begin
  g := TGefuellteFigur.create(name, Owner,false);
  g.copyfrom(self);
  Kopie := g;
end;

procedure TGefuellteFigur.methodenaufruf(Nummer: Integer; stack: TStack);
begin
  inherited methodenaufruf(Nummer,stack);
end;

procedure TGefuellteFigur.paint(c: TDrawCanvas);
begin
  inherited paint(c);
  if sichtbar.Wert.b then
  begin
    c.c.Brush.Color := TFarbe(Fuellfarbe.Wert.o).color;
    c.c.Brush.Style := TBrushStyle(Fuellart.Wert.i);
  end;
end;

{ TQuadrat }

procedure TQuadrat.attributaenderung(a: TAttribut);
Var mx,my,d: double;
    i: integer;
begin
  inherited;
  if a = links then frechts := flinks + fSeitenlaenge
  else if a = oben then funten := foben - fSeitenlaenge;

  setzeAttributelinksrechtsobenunten;

  if a = Seitenlaenge then
  begin
    if Seitenlaenge.Wert.i < 0 then Seitenlaenge.Wert.i := abs(Seitenlaenge.Wert.i);
    if Seitenlaenge.Wert.i = 0 then Seitenlaenge.Wert.i := 2;
    FSeitenlaenge := Seitenlaenge.Wert.i;
     if not wurdegedreht then
     begin
        Ecken[1].X := links.Wert.i; Ecken[1].Y := oben.wert.i;
        Ecken[2].X := links.wert.i; Ecken[2].y := oben.Wert.i - FSeitenlaenge;
        Ecken[3].X := links.wert.i + FSeitenlaenge; Ecken[3].Y := oben.wert.i - FSeitenlaenge;
        Ecken[4].x := links.wert.i + FSeitenlaenge; Ecken[4].y := oben.wert.i;
        //wurdegedreht := true;
     end else
     begin
       mx := (Ecken[1].x + Ecken[3].x)/2;
       my := (Ecken[1].y + Ecken[3].y)/2;
       for i := 1 to 4 do
         begin
             d := sqrt( sqr(Ecken[i].x-mx) + sqr(Ecken[i].y-my) );
             if abs(d) < 0.0001 then d := 0.0001;
             Ecken[i].x := mx + (Ecken[i].x-mx)*FSeitenlaenge/(d*sqrt(2));
             Ecken[i].y := my + (Ecken[i].y-my)*FSeitenlaenge/(d*sqrt(2));
         end;
     end;
     Grenzensetzen;
  end;
end;

procedure TQuadrat.copyfrom(o: TObjekt);
begin
  FSeitenlaenge := TQuadrat(o).FSeitenlaenge;
  if FSeitenlaenge < 100000 then
  Seitenlaenge.wert.i := round(FSeitenlaenge);
  inherited;

end;

constructor TQuadrat.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
var m: TMethode;
begin
   inherited create(Name,Owner,true);
   ci := 32; Klassenname := 'QUADRAT';
   Seitenlaenge := TAttribut.create('seitenlnge',self,vtInteger,0);
   AddAttribut(Seitenlaenge);
   Seitenlaenge.Wert.i := rechts.Wert.i - links.wert.i;
   FSeitenlaenge := Seitenlaenge.wert.i;
   // Attribute/Methoden verstecken
   links.versteckt := true; rechts.versteckt := true; oben.versteckt := true; unten.versteckt := true;
   breite.versteckt := true; hoehe.versteckt := true;
   msetzeEcken.versteckt := true; msetzerechtsunten.versteckt := true;
   mstrecke.versteckt := true;

   m := TMethode.create('strecken',self,30,vtKeiner,0);
   m.addparameter('Faktor',vtDouble,0);
   AddMethode(m);

   CreateSetzeMethoden(inheritedFlag);
end;

destructor TQuadrat.destroy;
begin
  inherited;
end;

function TQuadrat.Kopie(Name: string; owner: TObjekt): TObjekt;
VAr q: TQuadrat;
begin
  q := TQuadrat.create(name, owner,false);
  q.copyfrom(self);
  Kopie := q;
end;

procedure TQuadrat.methodenaufruf(Nummer: Integer; stack: TStack);
var faktor: double;
begin
  case nummer of
     30: if wurdegedreht then
         begin
            faktor := stack.popdouble;
            strecken(faktor);
         end else qstrecke(stack.popdouble,RLinksRechts,0);
     else inherited methodenaufruf(Nummer,stack);
  end; // case
end;

procedure TQuadrat.paint(c: TDrawCanvas);
begin
  inherited paint(c);
end;

procedure TQuadrat.qstrecke(faktor: double; Richtung: TRichtung;
  vonKoordinate: integer);
Var mx,my,d: double;
    i: integer;
begin
  fSeitenlaenge := (fSeitenlaenge * faktor);
  if fSeitenlaenge < 100000 then
  Seitenlaenge.Wert.i := round(fSeitenlaenge);

     if not wurdegedreht then
     begin
        Ecken[1].X := links.Wert.i; Ecken[1].Y := oben.wert.i;
        Ecken[2].X := links.wert.i; Ecken[2].y := unten.Wert.i;
        Ecken[3].X := rechts.wert.i; Ecken[3].Y := unten.wert.i;
        Ecken[4].x := rechts.wert.i; Ecken[4].y := oben.wert.i;
        wurdegedreht := true;
     end;

     mx := (Ecken[1].x + Ecken[3].x)/2;
     my := (Ecken[1].y + Ecken[3].y)/2;
     for i := 1 to 4 do
       begin
           d := sqrt( sqr(Ecken[i].x-mx) + sqr(Ecken[i].y-my) );
           if abs(d) < 0.0001 then d := 0.0001;
           Ecken[i].x := mx + (Ecken[i].x-mx)*FSeitenlaenge/(d*sqrt(2));
           Ecken[i].y := my + (Ecken[i].y-my)*FSeitenlaenge/(d*sqrt(2));
       end;
     Grenzensetzen;
end;

{ TKlassenFabrik }

constructor TKlassenFabrik.create;
var f: TFenster;
begin
   Klassenliste := TList.Create;
   Klassenliste.Add(TRechteck.create('RECHTECK',nil,false));
   Klassenliste.Add(TQuadrat.create('QUADRAT',nil,false));
   f := TFenster.create('FENSTER',nil,false);
   //f.form.Release;
   Klassenliste.Add(f);
   Klassenliste.Add(TEllipse.create('ELLIPSE',nil,false));
   Klassenliste.Add(TKreis.create('KREIS',nil,false));
   Klassenliste.Add(TDreieck.create('DREIECK',nil,false));
   Klassenliste.Add(TLinie.create('LINIE',nil,false));
   Klassenliste.Add(TTextfeld.create('TEXTFELD',nil,false));
   Klassenliste.Add(TTurtle.create('TURTLE',nil,false));
   Klassenliste.Add(TGruppe.create('GRUPPE',nil,false));
   Klassenliste.Add(TFarbe.create('FARBE',nil,false));
   Klassenliste.Add(TFigur.create('FIGUR',nil,false));
   Klassenliste.Add(TGefuellteFigur.create('GEFLLTEFIGUR',nil,false));

end;

destructor TKlassenFabrik.destroy;
var i: integer;
begin
  for i := 0 to Klassenliste.Count -1 do
    TObjekt(Klassenliste.Items[i]).Free;
  Klassenliste.Free;
  inherited;
end;

function TKlassenFabrik.erstelleObjekt(KlassenName, ObjektName: String; Owner: TObjekt): TObjekt;
Var o: TObjekt;
    i: integer;
begin
   o := nil;
   i := 0;
   while (i <= Klassenliste.Count -1) and ( o = nil) do
   begin
      if lowercase(TObjekt(Klassenliste.Items[i]).Klassenname) = lowercase(KlassenName) then
         o := TObjekt(Klassenliste.Items[i]).Kopie(ObjektName, Owner);
   inc(i);
   end;
   erstelleObjekt := o;
end;

function TKlassenFabrik.getci(Klassenname: String): Integer;
var i: integer;
    kn: string;
    ci: integer;
begin
   kn := lowercase(Klassenname);
   i := 0; ci := 0;
   while (i <= Klassenliste.Count -1) and ( ci = 0) do
   begin
      if lowercase(TObjekt(Klassenliste.Items[i]).Klassenname) = kn then
         ci := TObjekt(Klassenliste.Items[i]).ci;
      inc(i);
   end;
   getci := ci;
end;

function TKlassenFabrik.getKlasse(ci: integer): TObjekt;
Var i: integer;
    o: TObjekt;
begin
   i := 0; o := nil;
   while (i <= Klassenliste.Count -1) and ( o = nil) do
     begin
      if TObjekt(Klassenliste.Items[i]).ci = ci then
           o := TObjekt(Klassenliste.Items[i]);
      inc(i);
     end;
   getKlasse := o;
end;

function TKlassenFabrik.getKLasseByName(name: String): TObjekt;
var i: integer;
    kn: string;
    o: TObjekt;
begin
   kn := lowercase(name);
   i := 0; o := nil;
   while (i <= Klassenliste.Count -1) and ( o = nil) do
   begin
      if lowercase(TObjekt(Klassenliste.Items[i]).Klassenname) = kn then
         o := TObjekt(Klassenliste.Items[i]);
      inc(i);
   end;
   getKLasseByName := o;
end;

function TKlassenFabrik.gibtes(Klassenname: String): Boolean;
var i: integer;
    kn: string;
    g: boolean;
begin
   kn := lowercase(Klassenname);
   i := 0; g := false;
   while (i <= Klassenliste.Count -1) and ( g = false) do
   begin
      if lowercase(TObjekt(Klassenliste.Items[i]).Klassenname) = kn then
         g := true;
      inc(i);
   end;
   gibtes := g;
end;

{ TFenster }

procedure TFenster.addObjekt(o: TObjekt);
begin
   if o <> nil then
   if o.zeichenbar then
   begin
     form.dc.addObject(o);
   end;
   form.pb.Repaint;
end;

procedure TFenster.attributaenderung(a: TAttribut);
begin
  inherited;
  if a = aname then
  begin
    form.NameDesFensters := aname.Wert.s;
    form.setCaption;
  end else
  if a = strichabstand then form.dc.Gitterabstand := strichabstand.Wert.i else
  if (a = Hintergrundfarbe) or (a = Gitterfarbe) then
  begin
     form.dc.Hintergrundfarbe := TFarbe(Hintergrundfarbe.Wert.o).color;
     form.dc.Gitterfarbe := TFarbe(Gitterfarbe.Wert.o).color;
     form.Repaint;
  end else
  begin
    if x.Wert.i < 0 then x.Wert.i := 0;
    if x.Wert.i > screen.Width - 10 then x.Wert.i := screen.Width - 10;
    if y.Wert.i < 0 then y.wert.i := 0;
    if y.wert.i > screen.height - 10 then y.wert.i := screen.Height - 10;
    if breite.Wert.i > screen.Width then breite.Wert.i := screen.Width;
    if breite.Wert.i < 10 then breite.Wert.i := 10;
    if hoehe.Wert.i > screen.Height then hoehe.Wert.i := screen.Height;
    if hoehe.Wert.i < 10 then hoehe.Wert.i := 10;
    // Das genderte Setzen
    if a = x then form.Left := x.Wert.i;
    if a = y then form.Top := y.wert.i;
    if a = breite then form.Width := breite.Wert.i;
    if a = hoehe then form.Height := hoehe.Wert.i;
  end
end;

constructor TFenster.create(fName: String; Owner: TObjekt; inheritedFlag: Boolean);
Var m: TMethode;
begin
   inherited create(fName, Owner,true);
   if fName <> 'FENSTER' then
   begin
      Application.CreateForm(TFZeichnen,form);
      form.fenster := self;

      form.dc.Gitterein := true;
      form.dc.Gitterabstand := 10;

      form.Show;
   end;

   ci := 41; Klassenname := 'FENSTER';
   if form <> nil then form.dc.Gitterein := true;
   // Methoden registrieren

   m := TMethode.create('verschiebe',self,1,vtKeiner,0);
   m.addparameter('x-Verschiebung',vtInteger,0);
   m.addparameter('y-Verschiebung',vtInteger,0);
   AddMethode(m);

   m := TMethode.create('zeichne',self,2,vtKeiner,0);
   m.addparameter('Figur',vtObjekt,2); // 2 bedeutet TFigur!!!
   AddMethode(m);

   m := TMethode.create('gitterein',self,80,vtKeiner,0);
   AddMethode(m);

   m := TMethode.create('gitteraus',self,81,vtKeiner,0);
   AddMethode(m);

   // Attribute registrieren

   strichabstand := TAttribut.create('strichabstand',self,vtInteger,0);
   AddAttribut(strichabstand);
   strichabstand.Wert.i := 10;

   aName := TAttribut.create('name',self,vtString,0);
   AddAttribut(aname);
   aName.Wert.s := 'Fenster';
   x := TAttribut.create('links',self,vtInteger,0);
   AddAttribut(x);
   y := TAttribut.create('oben',self,vtInteger,0);
   AddAttribut(y);
   breite := TAttribut.create('breite',self,vtInteger,0);
   AddAttribut(breite);
   hoehe := TAttribut.create('hhe',self,vtInteger,0);
   AddAttribut(hoehe);

   Hintergrundfarbe := TAttribut.create('hintergrundfarbe',self,vtObjekt,67);
   Hintergrundfarbe.Wert.o := TFarbe.create('',self,false);
   AddAttribut(Hintergrundfarbe);
   if fName <> 'FENSTER' then
   TFarbe(Hintergrundfarbe.Wert.o).setzefarbe(form.dc.Hintergrundfarbe);

   Gitterfarbe := TAttribut.create('gitterfarbe',self,vtObjekt,67);
   Gitterfarbe.Wert.o := TFarbe.create('',self,false);
   AddAttribut(Gitterfarbe);
   if fName <> 'FENSTER' then
   TFarbe(Gitterfarbe.Wert.o).setzefarbe(form.dc.Gitterfarbe);


   // Attribute initialisieren
   if name <> 'FENSTER' then
   begin
   x.Wert.i := form.Left; y.Wert.i := form.Top;
   breite.Wert.i := form.Width; Hoehe.Wert.i := form.Height;
   end;

   CreateSetzeMethoden(inheritedFlag);
end;

destructor TFenster.destroy;
begin
  inherited;
end;


function TFenster.Kopie(fName: string; owner: TObjekt): TObjekt;
Var k: TFenster;
begin
    k := TFenster.create(fName, Owner,false);
    k.aname.Wert.s := aname.wert.s;
    if (form <> nil) and (k.form <> nil) then
       k.form.dc.Gitterein := form.dc.Gitterein;
    k.strichabstand.wert.i := strichabstand.Wert.i;
    Kopie := k;
end;

procedure TFenster.methodenaufruf(Nummer: Integer; stack: TStack);
begin
  inherited;
   case Nummer of
   1: verschiebe(stack.popInteger, stack.popInteger);
   2: addObjekt(stack.popObjekt);
   80: form.dc.Gitterein := true;
   81: form.dc.Gitterein := false;
   end; // case;
end;


procedure TFenster.paint(c: TDrawCanvas);
begin
  inherited;

end;

procedure TFenster.removeObjekt(o: TOBjekt);
begin
   if o <> nil then
   begin
     form.dc.removeObject(o);
   end;
end;

procedure TFenster.verschiebe(x, y: Integer);
begin
   if (form.Left + x >= 0) and (form.Left + x <= screen.DesktopWidth-10) then form.Left := form.Left + x;
   if (form.top + y >= 0) and (form.top + y <= screen.DesktopHeight-10) then form.top := form.top + y;
end;

procedure TFenster.zeichne;
begin
   form.pb.Repaint;
end;

{ TEllipse }

procedure TEllipse.attributaenderung(a: TAttribut);
begin
  if a = Radiusx then fradiusx := Radiusx.Wert.i;
  if a = Radiusy then fradiusy := Radiusy.Wert.i;
  if a = Mittex then fMittex := Mittex.Wert.i;
  if a = Mittey then fMittey := Mittey.Wert.i;

  flinks := (fMittex - fradiusx);
  frechts := (fmittex + fradiusx);
  funten := (fmittey - fradiusy);
  foben := (fmittey + fradiusy);
  setzeAttributelinksrechtsobenunten;
end;

procedure TEllipse.copyfrom(o: TObjekt);
begin
  inherited;
  fMittex := TEllipse(o).fMittex;
  fMittey := TEllipse(o).fMittey;
  fRadiusx := TEllipse(o).fRadiusx;
  fRadiusy := TEllipse(o).fRadiusy;
  winkel := TEllipse(o).winkel;
  setzeAttributeVonDouble;
  Attributaenderung(nil);
end;

constructor TEllipse.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
var m: TMethode;
begin
   inherited create(Name,Owner,true);
   ci := 4*11; zeichenbar := true; Klassenname := 'ELLIPSE';

   winkel := 0;
   m := TMethode.create('mittelpunktSetzen',self,31,vtKeiner,0);
   m.addparameter('x',vtInteger,0);
   m.addparameter('y',vtInteger,0);
   AddMethode(m);

   Radiusx := TAttribut.create('radiusx',self,vtInteger,0);
   AddAttribut(Radiusx); Radiusx.wert.i := 10;
   Radiusy := TAttribut.create('radiusy',self,vtInteger,0);
   AddAttribut(Radiusy); Radiusy.wert.i := 10;
   Mittex := TAttribut.create('mittex',self,vtInteger,0);
   AddAttribut(Mittex); Mittex.wert.i := 0;
   Mittey := TAttribut.create('mittey',self,vtInteger,0);
   AddAttribut(Mittey); Mittey.wert.i := 0;
   FRadiusx := 10; FRadiusy := 10; FMittex := 0; FMittey := 0;
   Attributaenderung(nil);

   // Ein paar Attribute verstecken...
   links.versteckt := true; rechts.versteckt := true;
   oben.versteckt := true; unten.versteckt := true;
   breite.versteckt :=true; hoehe.versteckt := true;
   msetzeEcken.versteckt := true; msetzeLinksOben.versteckt := true;
   msetzerechtsunten.versteckt := true;
   mverschiebenach.versteckt := true;

   CreateSetzeMethoden(inheritedFlag);
end;

destructor TEllipse.destroy;
begin
  punkte := nil;
  inherited destroy;
end;

procedure TEllipse.drehe(dx, dy, Winkel: double);
var mix,miy: double;
begin
  inherited;
  mix := fmittex; miy := fMittey;
  DrehePunktUm(mix,miy,dx,dy,Winkel);
  fMittex := mix; fmittey := miy;
  self.winkel := self.winkel + winkel;
  self.winkel := self.winkel - 360*trunc(self.winkel / 360);
  setzeAttributeVonDouble;
  attributaenderung(nil);
end;

procedure TEllipse.Grenzensetzen;
Var i,xmin, xmax,ymin,ymax: integer;

begin
    xmin := 10000; ymin := 10000; xmax := -10000; ymax := -10000;
    for i := 0 to length(Punkte)-1 do
    begin
       if Punkte[i].X - mx < xmin then xmin := Punkte[i].X- mx;
       if Punkte[i].X - mx > xmax then xmax := Punkte[i].X- mx;
       if Punkte[i].y - my < ymin then ymin := Punkte[i].y- my;
       if Punkte[i].y - my > ymax then ymax := Punkte[i].y- my;
    end;
    flinks := xmin + fmittex; frechts := xmax + fmittex;
    foben := ymax + fmittey; funten := ymin + fmittey;
    setzeAttributelinksrechtsobenunten;
end;

function TEllipse.Kopie(Name: string; owner: TObjekt): TObjekt;
Var e: TEllipse;
begin
  e := TEllipse.create(name, owner,false);
  e.copyfrom(self);
  Kopie := e;
end;

procedure TEllipse.methodenaufruf(Nummer: Integer; stack: TStack);
begin
  case Nummer of
  1: verschiebe(stack.popInteger,stack.popInteger);
  31: verschiebenach(stack.popInteger, stack.popInteger);
  45: drehe(fmittex,fmittey,stack.popdouble);
  else inherited methodenaufruf(Nummer,stack);
  end;
end;

procedure TEllipse.paint(c: TDrawCanvas);
var x1,x2,y1,y2: integer;
    w,dw,v1x,v1y,v2x,v2y: double;
    i,anz: integer;
begin
  inherited paint(c);
  if sichtbar.wert.b then
  begin
   if abs(winkel) < 0.00001 then
    begin // Ellipse steht waagrecht
    x1 := c.xWtoScr(flinks); x2 := c.xWtoScr(frechts);
    y1 := c.yWtoScr(foben); y2 := c.yWtoScr(funten);
    c.c.Ellipse(x1,y1,x2,y2);
    end else 
    begin
       if (abs (winkel - pwinkel) > 0.000001) or
          (pmx <> round(fMittex)) or (pmy <> round(Mittey.Wert.i))
          or (prx <> round(fRadiusx)) or (pry <> round(fRadiusy))
          or (mx <> c.xWtoScr(fMittex)) or (my <> c.yWtoScr(fMittey))
       then
       begin // Punkte neu berechnen
          punkte := nil;
          prx := round(fRadiusx);
          pry := round(fRadiusy);
          if prx > 10000 then prx := 10000;
          if pry > 10000 then pry := 10000;
          pmx := round(fMittex);
          pmy := round(fMittey);
          mx := c.xWtoScr(fMittex);
          my := c.yWtoScr(fMittey);
          pwinkel := winkel;
          anz := round(3.14*(prx+pry)/8)*4;
          if anz < 12 then anz := 12;
          if anz > 1000 then anz := 1000;
             w := pwinkel * 0.017453292; // in Rad!
             v1x := prx * cos(w);
             v1y := (-1) * prx * sin(w);  // (-1), da y-Achse nach unten zeigt!
             v2x := pry * cos(w + Pih);
             v2y := (-1)* pry * sin(w + Pih);
          anz := anz div 4;
          w := 0; dw := Pih / anz;
          setlength(punkte,anz*4);
          for i := 0 to anz - 1 do
          begin
             punkte[i].X := round(v1x * cos(w) + v2x*sin(w) + mx);
             punkte[i].y := round(v1y * cos(w) + v2y*sin(w) + my);
             punkte[i+anz].X := round( v1x * cos(w+Pih) + v2x * sin(w+Pih) + mx);
             punkte[i+anz].y := round( v1y * cos(w+Pih) + v2y * sin(w+Pih) + my);
             punkte[i+2*anz].X := round(v1x * cos(w+2*Pih) + v2x * sin(w+2*Pih) + mx);
             punkte[i+2*anz].y := round(v1y * cos(w+2*Pih) + v2y * sin(w+2*Pih) + my);
             punkte[i+3*anz].X := round(v1x * cos(w+3*Pih) + v2x * sin(w+3*Pih) + mx);
             punkte[i+3*anz].y := round(v1y * cos(w+3*Pih) + v2y * sin(w+3*Pih) + my);
             w := w + dw;
          end;
          Grenzensetzen;
       end;
       c.c.Polygon(punkte);
    end;
  end;
end;

procedure TEllipse.setzeAttributeVonDouble;
begin
   if fRadiusx < 100000 then
   Radiusx.Wert.i := round(fRadiusx);
   if fRadiusy < 100000 then
   Radiusy.Wert.i := round(fRadiusy);
   if abs(fmittex) < 100000 then
   Mittex.Wert.i := round(fMittex);
   if abs(fmittey) < 100000 then
   Mittey.Wert.i := round(fMittey);
end;

procedure TEllipse.spieglex(Achse: double);
begin
  inherited;
   fMittex := Achse - (fMittex - Achse);
   winkel := 180 - winkel;
   setzeAttributeVonDouble;
end;

procedure TEllipse.spiegley(Achse: double);
begin
  inherited;
   fMittey := Achse - (fMittey - Achse);
   winkel := 360 - winkel;
   setzeAttributeVonDouble;
end;

procedure TEllipse.strecke(faktor: double; vonKoordinatex, vonKoordinatey: double);
begin
   if abs(vonKoordinatex + ((fMittex - vonKoordinatex)*faktor))  < 100000 then
      fMittex := vonKoordinatex + ((fMittex - vonKoordinatex)*faktor);
   if fRadiusx * faktor < 100000 then
      fRadiusx := ( fRadiusx * faktor);
   if abs(vonKoordinatey + ((fMittey - vonKoordinatey)*faktor)) < 100000 then
      fMittey := vonKoordinatey + ((fMittey - vonKoordinatey)*faktor);
   if fRadiusy*faktor < 100000 then
      fRadiusy := ( fRadiusy * faktor);
   setzeAttributeVonDouble;
   attributaenderung(nil);
end;

procedure TEllipse.verschiebe(dx, dy: integer);
begin
   fmittex := fmittex + dx;
   fmittey := fmittey + dy;
   setzeAttributeVonDouble;
   attributaenderung(nil);
end;

procedure TEllipse.verschiebenach(x, y: integer);
begin
   verschiebe(round(x - fMittex), round(y - fMittey));
end;

{ TKreis }

procedure TKreis.aktualisiereAttribute;
begin
   Radius.wert.i := round(dRadius); Mittex.Wert.i := round(dMittex);
   Mittey.wert.i :=round(dMittey);
end;

procedure TKreis.attributaenderung(a: TAttribut);
begin
  if a = Radius then dRadius := Radius.Wert.i;
  if a = Mittex then dMittex := Mittex.wert.i;
  if a = Mittey then dMittey := Mittey.wert.i;
  flinks := Mittex.Wert.i - radius.Wert.i;
  frechts := mittex.wert.i + radius.wert.i;
  funten := mittey.wert.i - radius.wert.i;
  foben := mittey.wert.i + radius.wert.i;
  setzeAttributelinksrechtsobenunten;
end;

procedure TKreis.copyfrom(o: TObjekt);
begin
  inherited;
  dMittex := TKreis(o).dMittex;
  dMittey := TKreis(o).dMittey;
  dRadius := TKreis(o).dRadius;
  Mittex.Wert.i := TKreis(o).Mittex.wert.i;
  Mittey.wert.i := TKreis(o).Mittey.Wert.i;
  Radius.Wert.i := TKreis(o).Radius.Wert.i;
  attributaenderung(nil);
end;

constructor TKreis.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
Var m: TMethode;
begin
   inherited create(Name,Owner,true);
   ci := 4*13; Klassenname := 'KREIS';zeichenbar := true;

   m := TMethode.create('mittelpunktSetzen',self,31,vtKeiner,0);
   m.addparameter('x',vtInteger,0);
   m.addparameter('y',vtInteger,0);
   AddMethode(m);

   Radius := TAttribut.create('radius',self,vtInteger,0);
   AddAttribut(Radius); Radius.wert.i := 10;

   Mittex := TAttribut.create('mittex',self,vtInteger,0);
   AddAttribut(Mittex); Mittex.wert.i := 0;

   Mittey := TAttribut.create('mittey',self,vtInteger,0);
   AddAttribut(Mittey); Mittey.wert.i := 0;

   Attributaenderung(Mittex); attributaenderung(Mittey); attributaenderung(Radius);

   // Ein paar Attribute verstecken...
   links.versteckt := true; rechts.versteckt := true;
   oben.versteckt := true; unten.versteckt := true;
   breite.versteckt := true; hoehe.versteckt := true;

   msetzeEcken.versteckt := true; msetzeLinksOben.versteckt := true;
   msetzerechtsunten.versteckt := true;
   mverschiebenach.versteckt := true;


   CreateSetzeMethoden(inheritedFlag);
end;

destructor TKreis.destroy;
begin

  inherited;
end;

procedure TKreis.drehe(dx, dy, Winkel: double);
begin
  inherited;
  DrehePunktUm(dMittex,dMittey,dx,dy,Winkel);
  aktualisiereAttribute;
  attributaenderung(nil);
end;

function TKreis.Kopie(Name: string; owner: TObjekt): TObjekt;
Var k: TKreis;
begin
   k := TKreis.create(name,owner,false);
   k.copyfrom(self);
   Kopie := k;
end;

procedure TKreis.methodenaufruf(Nummer: Integer; stack: TStack);
begin
  case Nummer of
  1: verschiebe(stack.popInteger,stack.popInteger);
  31: verschiebenach(stack.popInteger, stack.popInteger);
  else inherited methodenaufruf(Nummer,stack);
  end;
end;

procedure TKreis.paint(c: TDrawCanvas);
var x1,x2,y1,y2: integer;
begin
  inherited paint(c);
  if sichtbar.wert.b then
  begin
  x1 := c.xWtoScr(dMittex - dRadius); x2 := c.xWtoScr(dMittex + dRadius);
  y1 := c.yWtoScr(dMittey  + dRadius); y2 := c.yWtoScr(dMittey - dRadius);
  c.c.Ellipse(x1,y1,x2,y2);
  end;

end;

procedure TKreis.spieglex(Achse: double);
begin
  dMittex := Achse - (dMittex - Achse);
  aktualisiereAttribute;
  attributaenderung(nil);
end;

procedure TKreis.spiegley(Achse: double);
begin
   dMittey := Achse - (dMittey - Achse);
   aktualisiereAttribute;
  attributaenderung(nil);
end;

procedure TKreis.strecke(faktor: double; vonKoordinatex, vonKoordinatey: double);
begin
  if abs(vonKoordinatex + ((dMittex - vonKoordinatex)*faktor)) < 100000 then
    dMittex := vonKoordinatex + ((dMittex - vonKoordinatex)*faktor);
  if abs(vonKoordinatex + ((dMittey - vonKoordinatey)*faktor)) < 100000 then
    dMittey := vonKoordinatey + ((dMittey - vonKoordinatey)*faktor);
  if abs(dRadius * faktor) < 100000 then
    dRadius := ( dRadius * faktor);
  aktualisiereAttribute;
  attributaenderung(nil);
end;

procedure TKreis.verschiebe(dx, dy: integer);
begin
   dmittex := dmittex + dx;
   dmittey := dmittey + dy;
   aktualisiereAttribute;
   attributaenderung(nil);
end;

procedure TKreis.verschiebenach(x, y: integer);
begin
   verschiebe(x - self.Mittex.Wert.i, y - self.Mittey.Wert.i);
end;

{ TStrecke }

procedure TLinie.attributaenderung(a: TAttribut);
begin
  inherited;
  if (a = x1) then fx1 := x1.Wert.i;
  if (a = x2) then fx2 := x2.Wert.i;
  if (a = y1) then fy1 := y1.Wert.i;
  if (a = y2) then fy2 := y2.Wert.i;

  if (a = oben) then foben := oben.Wert.i;
  if (a = unten) then funten := unten.Wert.i;
  if (a = rechts) then frechts := rechts.Wert.i;
  if (a = links) then flinks := links.Wert.i;

  if (a = x1) or (a = x2) or (a = y1) or (a = y2) then
  begin
     if fx1 < fx2 then
     begin
        flinks := fx1; frechts := fx2;
     end else
     begin
        frechts := fx1; flinks := fx2;
     end;
     if fy1 < fy2 then
     begin
        funten := fy1; foben := fy2;
     end else
     begin
        foben := fy1; funten := fy2;
     end;
  end else
  if (a = links) or (a = rechts) or (a= oben) or (a= unten) then
  begin
     if flinks < frechts then
     begin
        fx1 := flinks; fx2 := frechts;
     end else
     begin
        fx1 := frechts; fx2 := flinks;
     end;
     if foben < funten then
     begin
        fy1 := foben; fy2 := funten;
     end else
     begin
        fy1 := funten; fy2 := foben;
     end;
  end;

   x1.Wert.i := round(fx1);
   x2.Wert.i := round(fx2);
   y1.Wert.i := round(fy1);
   y2.Wert.i := round(fy2);

   links.Wert.i := round(flinks);
   rechts.Wert.i := round(frechts);
   oben.Wert.i := round(foben);
   unten.Wert.i := round(funten);

end;

procedure TLinie.copyfrom(o: TObjekt);
begin
  inherited copyfrom(o);
  TFarbe(Farbe.Wert.o).copyfrom(TLinie(o).farbe.wert.o);
  Dicke.wert.i := TLinie(o).Dicke.wert.i;
  fx1 := TLinie(o).fx1;
  fx2 := TLinie(o).fx2;
  fy1 := TLinie(o).fy1;
  fy2 := TLinie(o).fy2;
  setzeAttributex1y1x2y2;
end;

constructor TLinie.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
var m: TMethode;
begin
   inherited create(Name, Owner,true);
   ci := 2*23; zeichenbar := true; Klassenname := 'LINIE';

   // Methoden registrieren
   m := TMethode.create('punkt1Setzen',Self,70,vtKeiner,0);
   m.addparameter('x',vtInteger,0);
   m.addparameter('y',vtInteger,0);
   addmethode(m);

   m := TMethode.create('punkt2Setzen',Self,71,vtKeiner,0);
   m.addparameter('x',vtInteger,0);
   m.addparameter('y',vtInteger,0);
   addmethode(m);

   m := TMethode.create('endpunkteSetzen',Self,72,vtKeiner,0);
   m.addparameter('x1',vtInteger,0);
   m.addparameter('y1',vtInteger,0);
   m.addparameter('x2',vtInteger,0);
   m.addparameter('y2',vtInteger,0);
   addmethode(m);

   // Attribute registrieren
   x1 := TAttribut.create('x1',self,vtInteger,0);
   AddAttribut(x1);

   y1 := TAttribut.create('y1',self,vtInteger,0);
   AddAttribut(y1);

   x2 := TAttribut.create('x2',self,vtInteger,0);
   AddAttribut(x2);

   y2 := TAttribut.create('y2',self,vtInteger,0);
   AddAttribut(y2);

   Farbe := TAttribut.create('farbe',self,vtObjekt,67);
   Farbe.Wert.o := TFarbe.create('farbe',self,false);
   addattribut(Farbe);

   Dicke := TAttribut.create('linienStrke',self,vtInteger,0);
   AddAttribut(Dicke);

   Linienart.Name := 'linienart';

   // Attribute initialisieren
   x1.Wert.i := -10; y1.Wert.i := 10;
   x2.Wert.i := 10; y2.Wert.i := -10;

   fx1 := -10; fy1 := 10;
   fx2 := 10; fy2 := -10;

   attributaenderung(x1);
   // Attribute verstecken
   links.versteckt := true; rechts.versteckt := true;
   oben.versteckt := true; unten.versteckt := true;
   breite.versteckt := true; hoehe.versteckt := true;
   msetzeEcken.versteckt := true; msetzeLinksOben.versteckt := true;
   msetzerechtsunten.versteckt := true;
   Rahmenfarbe.versteckt := true; Rahmenstaerke.versteckt := true;



   CreateSetzeMethoden(inheritedFlag);
end;

destructor TLinie.destroy;
begin

  inherited;
end;

procedure TLinie.drehe(dx, dy, Winkel: double);
Var lx1,lx2,ly1,ly2: double;
begin
   lx1 := fx1; ly1 := fy1;
   lx2 := fx2; ly2 := fy2;
   DrehePunktUm(lx1,ly1,dx,dy,winkel);
   DrehePunktUm(lx2,ly2,dx,dy,winkel);
   fx1 := lx1; fy1 := ly1;
   fx2 := lx2; fy2 := ly2;
   setzeAttributex1y1x2y2;
end;

function TLinie.Kopie(Name: string; owner: TObjekt): TObjekt;
Var s: TLinie;
begin
  s := TLinie.create(name, owner,false);
  s.copyfrom(self);
  Kopie := s;
end;

procedure TLinie.methodenaufruf(Nummer: Integer; stack: TStack);
Var x1,x2,y1,y2: integer;
begin
  case Nummer of
  70: setzePunkt1(stack.popInteger, stack.popInteger);
  71: setzePunkt2(stack.popInteger, stack.popInteger);
  72: begin
         y2 := stack.popInteger; x2 := stack.popInteger;
         y1 := stack.popInteger; x1 := stack.popInteger;
         setzePunkte(x1,y1,x2,y2);
      end;
  end; // case
  inherited methodenaufruf(Nummer,stack);
end;

procedure TLinie.paint(c: TDrawCanvas);
var x1s,y1s,x2s,y2s: integer;
begin
  c.c.Pen.Style := TPenStyle(Linienart.wert.i);
  c.c.Pen.Color := TFarbe(Farbe.wert.o).color;
  c.c.Pen.Width := Dicke.Wert.i;
  c.c.Pen.Mode := pmCopy;
  if sichtbar.Wert.b then
  begin
  c.c.Brush.Style := bsclear;
  x1s := c.xWtoScr(fx1);
  x2s := c.xWtoScr(fx2);
  y1s := c.yWtoScr(fy1);
  y2s := c.yWtoScr(fy2);
  c.c.moveto(x1s,y1s);
  c.c.LineTo(x2s,y2s);
  c.c.Brush.Style := bsSolid;
  end;
end;

procedure TLinie.setzeAttributex1y1x2y2;
begin
   x1.Wert.i := round(fx1);
   x2.Wert.i := round(fx2);
   y1.Wert.i := round(fy1);
   y2.Wert.i := round(fy2);
   attributaenderung(nil);
end;

procedure TLinie.setzePunkt1(x, y: integer);
begin
   fx1 := x; fy1 := y;
   setzeAttributex1y1x2y2;
end;

procedure TLinie.setzePunkt2(x, y: integer);
begin
   fx2 := x; fy2 := y;
   setzeAttributex1y1x2y2;
end;

procedure TLinie.setzePunkte(x1, y1, x2, y2: integer);
begin
   fx1 := x1; fy1 := y1;
   fx2 := x2; fy2 := y2;
   setzeAttributex1y1x2y2;
end;

procedure TLinie.spieglex(Achse: double);
begin
inherited;
   fx1 := Achse - (fx1 - Achse);
   fx2 := Achse - (fx2 - Achse);
   setzeAttributex1y1x2y2;
end;

procedure TLinie.spiegley(Achse: double);
begin
inherited;
   fy1 := Achse - (fy1 - Achse);
   fy2 := Achse - (fy2 - Achse);
   setzeAttributex1y1x2y2;
end;

procedure TLinie.strecke(faktor: double; vonKoordinatex, vonKoordinatey: double);
begin
inherited;
   if abs(vonKoordinatex + ((fx1 - vonKoordinatex)*faktor)) < 100000 then
     fx1 := vonKoordinatex + ((fx1 - vonKoordinatex)*faktor);
   if abs(vonKoordinatex + ((fx2 - vonKoordinatex)*faktor)) < 100000 then
     fx2 := vonKoordinatex + ((fx2 - vonKoordinatex)*faktor);
   if abs(vonKoordinatey + ((fy1 - vonKoordinatex)*faktor)) < 100000 then
     fy1 := vonKoordinatey + ((fy1 - vonKoordinatey)*faktor);
   if abs(vonKoordinatey + ((fy2 - vonKoordinatex)*faktor)) < 100000 then
     fy2 := vonKoordinatey + ((fy2 - vonKoordinatey)*faktor);
   setzeAttributex1y1x2y2;
end;

{ TGruppe }

procedure TGruppe.kopiereObjekt(o: TFigur; schlucken: boolean);
var kopie: TFigur;
begin
   if not schlucken then
   begin
     kopie := TFigur(o.Kopie('',self));
     if kopie.ci = 2*31 then TTurtle(kopie).turtlesichtbar.Wert.b := false;
     kopien.Add(kopie); // In Kopien wird vermerkt, welche Objekte am
                        // Schluss entsorgt werden mssen.
   end
   else
   begin
     kopie := o;
   end;

   figur.Add(Kopie);
   if figur.Count = 1 then
   begin
      flinks := o.flinks;
      frechts := o.frechts;
      foben := o.foben;
      funten := o.funten;
      flinksalt := flinks; frechtsalt := frechts;
      fobenalt := foben; funtenalt := funten;
   end else
   begin
   if (o.flinks < flinks) then flinks := o.flinks;
   if (o.frechts > frechts) then frechts := o.frechts;
   if (o.foben > foben) then foben := o.foben;
   if (o.funten < funten) then funten := o.funten;
   end;
      flinksalt := flinks; frechtsalt := frechts;
      fobenalt := foben; funtenalt := funten;
   setzeAttributelinksrechtsobenunten;
end;

procedure TGruppe.ermittleGrenzen;
Var i: integer;
    f: TFigur;
    links,rechts,oben, unten: double;

begin
   links := 10000;
   rechts := -10000;
   oben := 10000;
   unten := -10000;

   for i := 0 to figur.Count -1 do
     begin
     f := TFigur(figur.Items[i]);

     // ist es auch eine Gruppe? => rekursiv runter!
     if f.ci = ci then
     begin
     TGruppe(f).ermittleGrenzen;
     end;

     if f.flinks < links then links := f.flinks;
     if f.frechts > rechts then rechts := f.frechts;
     if f.foben < oben then oben := f.foben;
     if f.Funten > unten then unten := f.Funten;
     end;

     flinks := links;
     frechts := rechts;
     funten := unten;
     foben := oben;
   setzeAttributelinksrechtsobenunten;
end;



procedure TGruppe.attributaenderung(a: TAttribut);
Var i: integer;
begin
  inherited;

  if a = Fuellfarbe then
  begin
     for i := 0 to figur.Count - 1 do
       if TFigur(figur[i]).ci mod 4 = 0 then
         begin
           TFarbe(TGefuellteFigur(figur[i]).Fuellfarbe.Wert.o).color :=
             TFarbe(Fuellfarbe.Wert.o).color;
           TFigur(figur[i]).attributaenderung(TGefuellteFigur(figur[i]).Fuellfarbe);
         end;
  end;

  if a = Fuellart then
  begin
     for i := 0 to figur.Count - 1 do
       if TFigur(figur[i]).ci mod 4 = 0 then
         begin
         TGefuellteFigur(figur[i]).Fuellart.Wert.i :=
             Fuellart.Wert.i;
         TFigur(figur[i]).attributaenderung(TGefuellteFigur(figur[i]).Fuellart);
         end;
  end;

  if a = Linienart then
  begin
     for i := 0 to figur.Count - 1 do
     begin
         TFigur(figur[i]).Linienart.Wert.i :=
             Linienart.Wert.i;
         TFigur(figur[i]).attributaenderung(TFigur(figur[i]).Linienart);
       if TFigur(figur[i]).ci mod 23 = 0 then // LINIE
       begin
         TLinie(figur[i]).Linienart.Wert.i :=
             Linienart.Wert.i;
         TLinie(figur[i]).attributaenderung(TLinie(figur[i]).Linienart);
       end;
     end;
  end;

  if a = Rahmenfarbe then
  begin
     for i := 0 to figur.Count - 1 do
     begin
         TFarbe(TFigur(figur[i]).Rahmenfarbe.Wert.o).color :=
             TFarbe(Rahmenfarbe.Wert.o).color;
         TFigur(figur[i]).attributaenderung(TFigur(figur[i]).Rahmenfarbe);

         if TFigur(figur[i]).ci mod 23 = 0 then // LINIE
         begin
           TFarbe(TLinie(figur[i]).farbe.Wert.o).color :=
               TFarbe(Rahmenfarbe.Wert.o).color;
           TLinie(figur[i]).attributaenderung(TLinie(figur[i]).Farbe);

         end;
     end;
  end;


  if a = sichtbar then
  begin
     for i := 0 to figur.Count - 1 do
       TFigur(figur[i]).sichtbar.Wert.b := sichtbar.Wert.b;
  end;

  if a = links then
  begin
     verschiebe(round(links.wert.i-flinksalt),0);
  end else
  if a = rechts then
  begin
    verschiebe(round(rechts.wert.i-frechtsalt),0);
  end else
  if a = oben then
  begin
    verschiebe(0,round(oben.wert.i-fobenalt))
  end else
  if a = unten then
  begin
    verschiebe(0,round(unten.wert.i-funtenalt));
  end else
  if a = breite then
  begin
    if breite.wert.i > 0 then
      strecken(breite.wert.i/(frechts-flinks))
    else breite.Wert.i := rechts.wert.i - links.wert.i;
  end else
  if a = hoehe then
  begin
    if hoehe.Wert.i > 0 then
      strecken(hoehe.wert.i/(foben-funten))
      else hoehe.Wert.i := oben.wert.i - unten.wert.i;
  end;
      flinksalt := flinks; frechtsalt := frechts;
      fobenalt := foben; funtenalt := funten;
end;

constructor TGruppe.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
Var m: TMethode;
begin
   inherited create(Name, Owner,true); zeichenbar := true;
   ci := 2*29; zeichenbar := true; Klassenname := 'GRUPPE';

   flinksalt := flinks; frechtsalt := frechts;
   fobenalt := foben; funtenalt := funten;
   // Methoden registrieren

   m := TMethode.create('kopiere',self,2,vtKeiner,0);
   m.addparameter('figur',vtObjekt,2); // 2 bedeutet TFigur!!!
   AddMethode(m);

   m := TMethode.create('schlucke',self,22,vtKeiner,0);
   m.addparameter('figur',vtObjekt,2); // 2 bedeutet TFigur!!!
   AddMethode(m);

   m := TMethode.create('spiegleX',self,20,vtKeiner,0);
   AddMethode(m);

   m := TMethode.create('spiegleY',self,21,vtKeiner,0);
   AddMethode(m);

   figur := Tlist.Create;
   kopien := TList.Create;

   CreateSetzeMethoden(inheritedFlag);
end;

destructor TGruppe.destroy;
Var i: integer;
begin
  for i := 0 to kopien.Count -1 do
     TFigur(kopien.Items[i]).Free;
  figur.Free;
  kopien.Free;
  inherited;
end;

procedure TGruppe.methodenaufruf(Nummer: Integer; stack: TStack);
begin
ermittleGrenzen;
inherited;
   case Nummer of
   // 1: verschiebe(stack.popInteger, stack.popInteger);
   2: kopiereObjekt(TFigur(stack.popObjekt),false);
   20: begin
        spieglex(round((links.wert.i + rechts.wert.i)/2));
        end;
   21: begin
        spiegley(round((oben.wert.i + unten.wert.i)/2));
       end;
   22: kopiereObjekt(TFigur(stack.popObjekt),true);
   end; // case;
end;
procedure TGruppe.paint(c: TDrawCanvas);
Var i : Integer;
begin
  inherited;
  if sichtbar.wert.b then
  for i := 0 to figur.Count -1 do TFigur(figur.Items[i]).paint(c);
end;

procedure TGruppe.verschiebe(dx, dy: Integer);
var i: integer;
begin
   testGrenzen;
   flinks := flinks + dx;
   frechts := frechts + dx;
   funten := funten + dy;
   foben := foben + dy;
   setzeAttributelinksrechtsobenunten;
   for i := 0 to figur.Count -1 do
     TFigur(figur.Items[i]).verschiebe(dx,dy);
end;

procedure TGruppe.copyfrom(o: TObjekt);
var i: integer;
begin
  inherited;
  for i := 0 to TGruppe(o).figur.Count -1 do
     figur.Add(TFigur(TGruppe(o).figur.Items[i]).Kopie('',self));
end;

function TGruppe.Kopie(Name: string; owner: TObjekt): TObjekt;
Var g: TGruppe;
begin
   g := TGruppe.create(name,owner,false);
   g.copyfrom(self);
   Kopie := g;
end;

procedure TGruppe.spieglex(Achse: double);
Var i: integer;
begin
  testGrenzen;
  inherited;
  for i := 0 to Figur.Count -1 do
     TFigur(Figur.Items[i]).spieglex(Achse);
  korrigiereobenuntenlinksrechts;
end;

procedure TGruppe.spiegley(Achse: double);
Var i: integer;
begin
  testGrenzen;
  inherited;
  for i := 0 to Figur.Count -1 do
     TFigur(Figur.Items[i]).spiegley(Achse);
  korrigiereobenuntenlinksrechts;
end;

procedure TGruppe.strecke(faktor: double; vonKoordinatex, vonKoordinatey: double);
Var i: integer;
begin
  testGrenzen;
  inherited;
  for i := 0 to Figur.Count -1 do
     TFigur(Figur.Items[i]).strecke(faktor,vonKoordinatex,vonKoordinatey);
  korrigiereobenuntenlinksrechts;
end;

procedure TGruppe.korrigiereobenuntenlinksrechts;
var z: double;
begin
   if foben < funten then
   begin
      z:= foben; foben := funten; funten := z;
   end;
   if frechts < flinks then
   begin
      z:= frechts; frechts := flinks; flinks := z;
   end;
      flinksalt := flinks; frechtsalt := frechts;
      fobenalt := foben; funtenalt := funten;
end;

procedure TGruppe.testGrenzen;
var i: integer;
    f: TFigur;
    l,r,o,u: double;
begin
   l := 10000; r := -10000; o := -10000; u := 10000;
   for i := 0 to figur.count - 1 do
   begin
     f := TFigur(figur.items[i]);
     if f.flinks < l then l := f.flinks;
     if f.frechts > r then r := f.frechts;
     if f.foben > o then o := f.foben;
     if f.funten < u then u := f.funten;
   end;
   if(abs(links.Wert.d-l) > 1e-6) then
   begin
        links.Wert.d := l;
   end;
   if(abs(rechts.Wert.d-r) > 1e-6) then
   begin
        rechts.Wert.d := r;
   end;
   if(abs(oben.Wert.d-o) > 1e-6) then
   begin
        oben.Wert.d := o;
   end;
   if(abs(unten.Wert.d-u) > 1e-6) then
   begin
        unten.Wert.d := u;
   end;

end;

procedure TGruppe.drehe(dx, dy, Winkel: double);
var i: integer;
    f: TFigur;
begin
   for i := 0 to figur.Count -1 do
   begin
      f := TFigur(figur.Items[i]);
      f.drehe(dx,dy,winkel);
   end;
   testGrenzen;
end;


{ TTextfeld }

procedure TTextfeld.attributaenderung(a: TAttribut);
begin
  if GroesseAutomatischAnpassen.Wert.b then GroesseAnpassen;
  inherited;
end;

procedure TTextfeld.copyfrom(o: TObjekt);
Var t: TTextfeld;
    i: integer;
begin
  inherited;
  t := TTextfeld(o);
  schriftart.Wert.s := t.schriftart.Wert.s;
  ausrichtunghorizontal.Wert.i := t.ausrichtunghorizontal.Wert.i;
  ausrichtungvertikal.Wert.i := t.ausrichtungvertikal.Wert.i;
  schriftgroesse.Wert.i := t.schriftgroesse.Wert.i;
  TFarbe(Schriftfarbe.wert.o).copyfrom(TFarbe(t.schriftfarbe.Wert.o));
  durchsichtig.Wert.b := t.durchsichtig.Wert.b;
  for i := 0 to t.Zeile.Count -1 do
     Zeile.Add(t.Zeile.Strings[i]);
end;

constructor TTextfeld.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
Var m: TMethode;
begin
   inherited create(name,owner,true);
   ci := 16*17; zeichenbar := true; Klassenname := 'TEXTFELD';
//     text, ausrichtunghorizontal, ausrichtungvertikal: TAttribut;
//     schriftart,schriftgroesse: TAttribut

    m := TMethode.create('zeileHinzufgen',Self,10,vtKeiner,0);
    m.addparameter('Text',vtString,0);
    AddMethode(m);

    m := tMethode.create('zeilenLschen',self,11,vtKeiner,0);
    AddMethode(m);

    GroesseAutomatischAnpassen := TAttribut.create('groesseAutomatischAnpassen',self,vtBoolean,0);
    AddAttribut(GroesseAutomatischAnpassen); GroesseAutomatischAnpassen.Wert.b := true;

    ausrichtunghorizontal := TAttribut.create('ausrichtungHorizontal',self,vtInteger,0);
    AddAttribut(ausrichtunghorizontal); ausrichtunghorizontal.Wert.i := 0;

    ausrichtungvertikal := TAttribut.create('ausrichtungVertikal',self,vtInteger,0);
    AddAttribut(ausrichtungvertikal); ausrichtungvertikal.Wert.i := 0;

    schriftart := TAttribut.create('schriftart',self,vtString,0);
    AddAttribut(schriftart); schriftart.Wert.s := 'Arial';

    schriftgroesse := TAttribut.create('schriftgre',self,vtInteger,0);
    AddAttribut(schriftgroesse); schriftgroesse.Wert.i := 12;

    schriftfarbe := TAttribut.create('schriftfarbe',self,vtObjekt,67);
    schriftfarbe.Wert.o := TFarbe.create('',self,false);
    AddAttribut(Schriftfarbe); TFarbe(Schriftfarbe.Wert.o).setzergb(0,0,0);

    durchsichtig := TAttribut.create('durchsichtig',self,vtBoolean,0);
    AddAttribut(durchsichtig); durchsichtig.Wert.b := false;

    Zeile := TStringList.Create;

   CreateSetzeMethoden(inheritedFlag);
end;

destructor TTextfeld.destroy;
begin
  Zeile.Free;
  inherited;
end;

procedure TTextfeld.drehe(dx, dy, Winkel: double);
begin
  inherited;

end;

procedure TTextfeld.GroesseAnpassen;
var h,hges,b, Zeilenabstand,i: integer;
    c : TCanvas;
begin
    c := Application.MainForm.Canvas;
    hges := 0; b := 0; Zeilenabstand := 0;
    if Zeile.Count >= 1 then
    begin
      c.Font.Name := schriftart.Wert.s;
      c.Font.Size := schriftgroesse.Wert.i;
      if Zeile.Count > 1 then
          h := c.TextHeight('HDF|g')
          else h := c.TextHeight(Zeile.Strings[0]);
      Zeilenabstand := round(h/4);
      hges := Zeile.Count * h + (Zeile.count -1)*Zeilenabstand;
      b := 0;
      for i := 0 to Zeile.count -1 do
         if c.textwidth(Zeile.strings[i]) > b then b := c.textwidth(zeile.strings[i]);
    end;
    rechts.wert.i := links.Wert.i + b + 2*zeilenabstand;
    unten.wert.i := oben.Wert.i - hges - 2*Zeilenabstand;
end;

function TTextfeld.Kopie(Name: string; owner: TObjekt): TObjekt;
Var t: TTextfeld;
begin
  t := TTextfeld.create(name, owner,false);
  t.copyfrom(self);
  Kopie := t;
end;

procedure TTextfeld.Loeschen;
begin
   Zeile.Clear;
end;

procedure TTextfeld.methodenaufruf(Nummer: Integer; stack: TStack);
begin
  inherited;
  case Nummer of
  10: ZeileHinzufuegen(stack.popString);
  11: Loeschen;
  end;
end;

procedure TTextfeld.paint(c: TDrawCanvas);
var b,h,hges,xo,yo, Zeilenabstand,i: integer;
begin
  if (not durchsichtig.Wert.b) and sichtbar.wert.b then inherited;
  if sichtbar.Wert.b and (Zeile.Count >= 1) then
  begin
    c.c.Font.Name := schriftart.Wert.s;
    c.c.Font.Size := schriftgroesse.Wert.i;
    c.c.Font.Color := TFarbe(Schriftfarbe.Wert.o).color;
    c.c.brush.Style := bsClear;
    if Zeile.Count > 1 then
        h := c.c.TextHeight('HDF|g')
        else h := c.c.TextHeight(Zeile.Strings[0]);
    Zeilenabstand := round(h/4);
    hges := Zeile.Count * h + (Zeile.count -1)*Zeilenabstand;

    case ausrichtungvertikal.Wert.i of
    0: yo := oben.wert.i - round((oben.wert.i - unten.wert.i - hges)/2);
    1: yo := oben.wert.i - Zeilenabstand;
    2: yo := unten.wert.i + hges + Zeilenabstand;
    else yo := oben.wert.i;
    end; // case
    for i := 0 to zeile.Count-1 do
    begin
      b := c.c.TextWidth(zeile.Strings[i]);
      case ausrichtunghorizontal.Wert.i of
      0: xo := links.Wert.i + round((rechts.Wert.i - links.Wert.i - b)/2);
      1: xo := links.wert.i + Zeilenabstand;
      2: xo := rechts.wert.i - b - Zeilenabstand;
      else xo := links.wert.i;
      end; //case
      c.c.TextOut(c.xWtoScr(xo),c.yWtoScr(yo),Zeile.Strings[i]);
      yo := yo - h - Zeilenabstand;
    end;
    c.c.Brush.Style := bsSolid;
  end;
end;

procedure TTextfeld.strecke(faktor: double; vonKoordinatex, vonKoordinatey: double);
begin
  inherited;
  if GroesseAutomatischAnpassen.Wert.b then GroesseAnpassen;
end;

procedure TTextfeld.ZeileHinzufuegen(text: string);
begin
   Zeile.Add(text);
   if GroesseAutomatischAnpassen.Wert.b then GroesseAnpassen;
end;

{ TTurtle }

procedure TTurtle.attributaenderung(a: TAttribut);
begin
  if a = turtleX then
  begin
     xneu := TurtleX.Wert.d;
     createSegment;
  end;
  if a = turtleY then
  begin
     yneu := TurtleY.Wert.d;
     createSegment;
  end;
  if a = kurs then Richtung := kurs.Wert.d;
  inherited;
end;


procedure TTurtle.clearall;
begin
   setlength(segmente,10);
   SegmentCount := 0;
   SegmentSpace := 10;
end;

procedure TTurtle.copyfrom(o: TObjekt);
var t: TTurtle;
    i: integer;
begin
  inherited;
  t := TTurtle(o);
  Linienart.Wert.i := t.Linienart.Wert.i;
  TFarbe(Farbe.Wert.o).copyfrom(t.Farbe.wert.o);
  penstate := t.penstate;
  turtlesichtbar.wert.b := t.turtlesichtbar.wert.b;
  x := t.x; y := t.y; Richtung := t.Richtung;

  SegmentCount := t.SegmentCount;
  SegmentSpace := t.SegmentSpace;
  setlength(Segmente,SegmentSpace);
  for i := 0 to SegmentCount -1 do
  Segmente[i] := t.segmente[i];

end;

constructor TTurtle.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
var m: TMethode;
begin
   inherited create(Name, Owner,true);

   ci := 2*31; zeichenbar := true; Klassenname := 'TURTLE';
   // Speicher fr die Strecken reservieren
   SegmentCount := 0; // noch nichts gezeichnet
   SegmentSpace := 10;
   setlength(Segmente,SegmentSpace); // Platz von 0 .. SegmentSpace - 1

   x := 0; y := 0; penstate := true; Richtung := 0;
   Aufpunkt := false; Vorpunkt := false;

   // Methoden registrieren
   m := TMethode.create('vor',self,50,vtKeiner,0);
   m.addparameter('Streckenlnge',vtdouble,0);
   AddMethode(m);

   m := TMethode.create('zurck',self,51,vtKeiner,0);
   m.addparameter('Streckenlnge',vtdouble,0);
   AddMethode(m);

   m := TMethode.create('linksdrehen',self,52,vtKeiner,0);
   m.addparameter('Winkel',vtdouble,0);
   AddMethode(m);

   m := TMethode.create('rechtsdrehen',self,53,vtKeiner,0);
   m.addparameter('Winkel',vtdouble,0);
   AddMethode(m);

   m := TMethode.create('setzeXY',self,59,vtKeiner,0);
   m.addparameter('x',vtdouble,0);
   m.addparameter('y',vtdouble,0);
   AddMethode(m);

   m := TMethode.create('stiftAuf',self,54,vtKeiner,0);
   AddMethode(m);
   m := TMethode.create('stiftAb',self,55,vtKeiner,0);
   AddMethode(m);
   m := TMethode.create('allesLschen',self,56,vtKeiner,0);
   AddMethode(m);
   m := TMethode.create('aufPunkt',self,57,vtBoolean,0);
   AddMethode(m);
   m := TMethode.create('vorPunkt',self,58,vtBoolean,0);
   AddMethode(m);

   // Attribute registrieren
   farbe := TAttribut.create('farbe',self,vtObjekt,67);
   farbe.Wert.o := TFarbe.create('',self,false);
   AddAttribut(Farbe);

   Linienstaerke := TAttribut.create('linienstrke',self,vtInteger,0);
   AddAttribut(Linienstaerke);

   turtlesichtbar := TAttribut.create('turtleSichtbar',self,vtBoolean,0);
   AddAttribut(turtlesichtbar);

   turtleX := TAttribut.create('x',self,vtDouble,0);
   AddAttribut(turtleX);

   turtleY := TAttribut.create('y',self,vtDouble,0);
   AddAttribut(turtleY);

   kurs := TAttribut.create('kurs',self,vtDouble,0);
   AddAttribut(kurs);

   // Attribute initialisieren
   Linienstaerke.Wert.i := 3; turtlesichtbar.Wert.b := true;

   // Attribute verstecken
   links.versteckt := true; rechts.versteckt := true;
   oben.versteckt := true; unten.versteckt := true;
   breite.versteckt := true; hoehe.versteckt := true;
   msetzeEcken.versteckt := true; msetzeLinksOben.versteckt := true;
   msetzerechtsunten.versteckt := true; mverschiebenach.versteckt := true;
   //mdrehe.versteckt := true; mdrehenUm.versteckt := true;
   Rahmenfarbe.versteckt := true; Rahmenstaerke.versteckt := true;

   CreateSetzeMethoden(inheritedFlag);
end;

procedure TTurtle.createSegment;
var s: TLineSegment;
begin
    s.x1 := x; s.y1 := y; s.x2 := xneu; s.y2 := yneu;
    x := xneu; y := yneu;
    if penstate then
    begin
      if s.x1 < flinks then
         begin
            flinks := s.x1;
            links.Wert.i := round(flinks);
         end;
      if s.x2 < flinks then
         begin
            flinks := s.x2;
            links.wert.i := round(flinks);
         end;
      if s.x1 > frechts then
      begin
        frechts := s.x1;
        rechts.wert.i := round(frechts);
      end;
      if s.x2 > frechts then
      begin
        frechts := s.x2;
        rechts.wert.i := round(frechts);
      end;

      if s.y1 < funten then
      begin
         funten := s.y1;
         unten.Wert.i := round(funten);
      end;
      if s.y2 < funten then
      begin
         funten := s.y2;
         unten.wert.i := round(funten);
      end;
      if s.y1 > foben then
      begin
        foben := s.y1;
        oben.wert.i := round(foben);
      end;
      if s.y2 > foben then
      begin
         foben := s.y2;
         oben.wert.i := round(foben);
      end;

      s.Farbe := TFarbe(farbe.Wert.o).color;
      s.Linienart := linienart.Wert.i;
      s.Linienstaerke := linienstaerke.Wert.i;
      if SegmentCount >= SegmentSpace then
         begin
            Segmentspace := SegmentSpace + 30;
            setlength(segmente,segmentspace);
         end;
      segmente[segmentcount] := s;
      inc(segmentcount);
    end;
end;

destructor TTurtle.destroy;
begin
  Segmente := nil;
  inherited;
end;

procedure TTurtle.drehe(dx, dy, Winkel: double);
Var i: integer;
begin
   for i := 0 to SegmentCount -1 do
   begin
      DrehePunktUm(segmente[i].x1,segmente[i].y1,dx,dy,Winkel);
      DrehePunktUm(segmente[i].x2,segmente[i].y2,dx,dy,Winkel);
   end;
   GrenzenSetzen;
end;

procedure TTurtle.GrenzenSetzen;
Var i: integer;
begin
   if Segmentcount > 0 then begin
      flinks := 100000;
      frechts := -100000;
      foben := -100000;
      funten := 100000;
   end;
   for i := 0 to SegmentCount - 1 do
   begin
      if segmente[i].x1 < flinks then flinks := segmente[i].x1;
      if segmente[i].x2 < flinks then flinks := segmente[i].x2;
      if segmente[i].x1 > frechts then frechts := segmente[i].x1;
      if segmente[i].x2 > frechts then frechts := segmente[i].x2;

      if segmente[i].y1 < funten then funten := segmente[i].y1;
      if segmente[i].y2 < funten then funten := segmente[i].y2;
      if segmente[i].y1 > foben then foben := segmente[i].y1;
      if segmente[i].y2 > foben then foben := segmente[i].y2;
   end;
end;

function TTurtle.Kopie(Name: string; owner: TObjekt): TObjekt;
var t: TTurtle;
begin
   t := TTurtle.create(Name,owner,false);
   t.copyfrom(self);
   Kopie := t;
end;

procedure TTurtle.left(n: double);
begin
   Richtung := Richtung + n;
   Richtungnormalisieren;
end;

procedure TTurtle.methodenaufruf(Nummer: Integer; stack: TStack);
begin
  inherited;
  case Nummer of
  50: pforward(stack.popdouble);
  51: pback(stack.popdouble);
  52: left(stack.popdouble);
  53: right(stack.popdouble);
  54: penup;
  55: pendown;
  56: clearall;
  57: stack.pushBoolean(Aufpunkt);
  58: stack.pushBoolean(VorPunkt);
  59: setXY(stack.popdouble,stack.popdouble);
  end; // case
  TurtleX.Wert.d := x;
  TurtleY.Wert.d := y;
end;

procedure TTurtle.paint(c: TDrawCanvas);
var i: integer;
    s: TLineSegment;
    tr: double; //Turtleumkreisradius
begin
  inherited;

  if sichtbar.Wert.b then
  begin
    for i := 0 to SegmentCount -1 do
      begin
         s := Segmente[i];
         c.c.Pen.Color := s.Farbe;
         c.c.Pen.Style := TPenStyle(s.Linienart);
         c.c.Pen.Width := s.Linienstaerke;
         c.c.MoveTo(c.xWtoScr(s.x1),c.yWtoScr(s.y1));
         c.c.LineTo(c.xWtoScr(s.x2),c.yWtoScr(s.y2));
      end;

    if turtlesichtbar.Wert.b then
    begin
      // Turtle zeichnen
      tr := 20;
      c.c.Pen.Color := clred;
      c.c.Pen.Style := psSolid;
      c.c.Pen.Width := 2;
      c.c.MoveTo(c.xWtoScr(x + tr*cos(Richtung * ZPId360)),c.yWtoScr(y + tr*sin(Richtung * ZPId360)));
      c.c.LineTo(c.xWtoScr(x + 0.5*tr*cos((Richtung+120) * ZPId360)),c.yWtoScr(y + 0.5*tr*sin((Richtung+120) * ZPId360)));
      c.c.LineTo(c.xWtoScr(x + 0.5*tr*cos((Richtung+240) * ZPId360)),c.yWtoScr(y + 0.5*tr*sin((Richtung+240) * ZPId360)));
      c.c.LineTo(c.xWtoScr(x + tr*cos(Richtung * ZPId360)),c.yWtoScr(y + tr*sin(Richtung * ZPId360)));
      c.c.Pixels[c.xWtoScr(x),c.yWtoScr(y)] := clred;
    end;

  end;
end;

procedure TTurtle.pback(n: double);
begin
  xneu := x - cos(Richtung * ZPId360) * n;
  yneu := y - sin(Richtung * ZPId360) * n;
  createSegment;
end;

procedure TTurtle.pendown;
begin
   penstate := true;
end;

procedure TTurtle.penup;
begin
   penstate := false;
end;

procedure TTurtle.pforward(n: double);
begin
  xneu := x + cos(Richtung * ZPId360) * n;
  yneu := y + sin(Richtung * ZPId360) * n;
  createSegment;
end;

procedure TTurtle.Richtungnormalisieren;
begin
    if (Richtung > 360) or (Richtung < 0) then
        Richtung := Richtung - (trunc(Richtung) div 360)*360;
end;

procedure TTurtle.right(n: double);
begin
   richtung := Richtung - n;
   Richtungnormalisieren;
end;

procedure TTurtle.setXY(y, x: double);
begin
  xneu := x; yneu := y;
  createSegment;
end;

procedure TTurtle.spieglex(Achse: double);
Var i: integer;
begin
inherited;
   for i := 0 to SegmentCount -1 do
      begin
         segmente[i].x1 := Achse - (segmente[i].x1 - Achse);
         segmente[i].x2 := Achse - (segmente[i].x2 - Achse);
      end;
   x := Achse - (x - Achse);
   Richtung := Richtung * (-1); Richtungnormalisieren;
end;

procedure TTurtle.spiegley(Achse: double);
Var i: integer;
begin
inherited;
   for i := 0 to SegmentCount -1 do
      begin
         segmente[i].y1 := Achse - (segmente[i].y1 - Achse);
         segmente[i].y2 := Achse - (segmente[i].y2 - Achse);
      end;
   y := Achse - (y - Achse);
   Richtung := 180 - Richtung; Richtungnormalisieren;
end;

procedure TTurtle.strecke(faktor: double; vonKoordinatex, vonKoordinatey: double);
Var i: integer;
begin
inherited;
   for i := 0 to SegmentCount -1 do
      begin
         if abs(vonKoordinatex + faktor * (segmente[i].x1 - vonKoordinatex)) < 100000 then
           segmente[i].x1 := (vonKoordinatex + faktor * (segmente[i].x1 - vonKoordinatex));
         if abs(vonKoordinatex + faktor * (segmente[i].x2 - vonKoordinatex)) < 100000 then
           segmente[i].x2 := (vonKoordinatex + faktor * (segmente[i].x2 - vonKoordinatex));
         if abs(vonKoordinatex + faktor * (segmente[i].y1 - vonKoordinatey)) < 100000 then
           segmente[i].y1 := (vonKoordinatey + faktor * (segmente[i].y1 - vonKoordinatey));
         if abs(vonKoordinatex + faktor * (segmente[i].y2 - vonKoordinatey)) < 100000 then
           segmente[i].y2 := (vonKoordinatey + faktor * (segmente[i].y2 - vonKoordinatey));
      end;
      x := vonKoordinatex + faktor * (x - vonKoordinatex);
      y := vonKoordinatey + faktor * (y - vonKoordinatey);
end;

procedure TTurtle.TestAufVorPunkt(c:TDrawCanvas);
Var Color: TColor;
    xvor,yvor: double;
begin
  color := c.c.Pixels[c.xWtoScr(x),c.yWtoScr(y)];
  if (color = c.chinter1 {  TColor($808081)}) or (color = c.chinter2 { TColor($C0C0C1)}) then
     Aufpunkt := false else AufPunkt := true;
  xvor := x + 1 * cos(richtung * ZPId360);
  yvor := y + 1 * sin(richtung * ZPId360);
  color := c.c.Pixels[c.xWtoScr(xvor),c.yWtoScr(yvor)];
  if (color = c.chinter1 {  TColor($808081)}) or (color = c.chinter2 { TColor($C0C0C1)}) then
     Vorpunkt := false else VorPunkt := true;
end;

procedure TTurtle.verschiebe(dx, dy: integer);
Var i: integer;
begin
inherited;
   for i := 0 to SegmentCount -1 do
      begin
         segmente[i].x1 := segmente[i].x1 + dx;
         segmente[i].x2 := segmente[i].x2 + dx;
         segmente[i].y1 := segmente[i].y1 + dy;
         segmente[i].y2 := segmente[i].y2 + dy;
      end;
   x := x + dx;
   y := y + dy;
end;


{ TDreieck }

procedure TDreieck.attributaenderung(a: TAttribut);
begin
  inherited;

end;

procedure TDreieck.copyfrom(o: TObjekt);
var i: integer;
begin
  inherited;
  for i := 1 to 3 do
  begin
     punkte[i].X := TDreieck(o).punkte[i].x;
     punkte[i].y := TDreieck(o).punkte[i].y;
  end;
end;

constructor TDreieck.create(Name: String; Owner: TObjekt; inheritedFlag: Boolean);
var m: TMethode;
begin
   inherited create(Name,Owner,true);
   ci := 4*91; Klassenname := 'DREIECK';zeichenbar := true;

   // Ein paar Attribute verstecken...
   links.versteckt := true; rechts.versteckt := true;
   oben.versteckt := true; unten.versteckt := true;
   breite.versteckt := true; hoehe.versteckt := true;
   msetzeEcken.versteckt := true; msetzeLinksOben.versteckt := true;
   msetzerechtsunten.versteckt := true;

   punkte[1].X := -10; punkte[1].Y := 0;
   punkte[2].X := 0; punkte[2].y := 10;
   punkte[3].x := 10; punkte[3].y := 0;
   grenzenueberpruefen;

   m := TMethode.create('eckenSetzen',self,101,vtKeiner,0);
   m.addparameter('x1',vtInteger,0);
   m.addparameter('y1',vtInteger,0);
   m.addparameter('x2',vtInteger,0);
   m.addparameter('y2',vtInteger,0);
   m.addparameter('x3',vtInteger,0);
   m.addparameter('y3',vtInteger,0);
   AddMethode(m);

   m := TMethode.create('spiegleX',self,20,vtKeiner,0);
   AddMethode(m);

   m := TMethode.create('spiegleY',self,21,vtKeiner,0);
   AddMethode(m);

   CreateSetzeMethoden(inheritedFlag);
end;

destructor TDreieck.destroy;
begin

  inherited;
end;


procedure TDreieck.drehen(Winkel: double);
var xs,ys: double;
    i: integer;
begin
  // Wir drehen um den Schwerpunkt des Dreiecks:
  xs := 0; ys := 0;
  for i := 1 to 3 do
  begin
  xs := xs + punkte[i].x;
  ys := ys + punkte[i].y;
  end;
  xs := xs / 3;
  ys := ys / 3;

  drehe(xs,ys,Winkel);

end;

procedure TDreieck.drehe(dx, dy, Winkel: double);
var i: integer;
begin
   for i := 1 to 3 do
      DrehePunktUm(punkte[i].x,punkte[i].y,dx,dy,Winkel);
grenzenueberpruefen;
end;

procedure TDreieck.grenzenueberpruefen;
var i: integer;
    xmin,xmax,ymin,ymax: double;
begin
     xmin := 10000; xmax := -10000; ymin := 10000; ymax := -10000;
     for i := 1 to 3 do
     begin
        if punkte[i].X < xmin then xmin := punkte[i].x;
        if punkte[i].x > xmax then xmax := punkte[i].x;
        if punkte[i].y < ymin then ymin := punkte[i].y;
        if punkte[i].y > ymax then ymax := punkte[i].y;
     end;
     flinks := xmin; frechts := xmax;
     foben := ymin; funten := ymax;
     setzeAttributelinksrechtsobenunten;
end;

function TDreieck.Kopie(Name: string; owner: TObjekt): TObjekt;
var d: TDreieck;
begin
   d := TDreieck.create(Name,owner,false);
   d.copyfrom(self);
   Kopie := d;
end;

procedure TDreieck.methodenaufruf(Nummer: Integer; stack: TStack);
var x1,x2,y1,y2,x3,y3: integer;
begin
if Nummer <> 45 then
inherited;

  case Nummer of
   20: spieglex(((flinks + frechts)/2));
   21: spiegley(((foben + funten)/2));
   45: begin
   drehen(stack.popdouble);
        end;
  101: begin
         y3 := stack.popInteger; x3 := stack.popInteger;
         y2 := stack.popInteger; x2 := stack.popInteger;
         y1 := stack.popInteger; x1 := stack.popInteger;

         setzePunkte(x1,y1,x2,y2,x3,y3);
       end;
  end; // case
end;

procedure TDreieck.paint(c: TDrawCanvas);
var i: integer;
begin
  inherited;
  if sichtbar.wert.b then
  begin
    for i := 1 to 3 do
    begin
       ZeichenPunkte[i].X := c.xWtoScr(Punkte[i].x);
       ZeichenPunkte[i].y := c.yWtoScr(Punkte[i].y);
    end;
    c.c.Polygon(ZeichenPunkte);
  end;
end;

procedure TDreieck.setzePunkte(x1, y1, x2, y2, x3, y3: integer);
begin
   punkte[1].X := x1; punkte[1].Y := y1;
   punkte[2].X := x2; punkte[2].Y := y2;
   punkte[3].X := x3; punkte[3].Y := y3;
   grenzenueberpruefen;
end;

procedure TDreieck.spieglex(Achse: double);
var i: integer;
begin
  for i := 1 to 3 do
  begin
     punkte[i].x := Achse - (punkte[i].x - Achse);
  end;
  grenzenueberpruefen;
end;

procedure TDreieck.spiegley(Achse: double);
var i: integer;
begin
  for i := 1 to 3 do
  begin
     punkte[i].y := Achse - (punkte[i].y - Achse);
  end;
  grenzenueberpruefen;
end;

procedure TDreieck.strecke(faktor: double; vonKoordinatex, vonKoordinatey: double);
var i: integer;
begin
  inherited;
  for i := 1 to 3 do
  begin
    if abs(( faktor*(punkte[i].X - vonKoordinatex)) + vonKoordinatex) < 100000 then
      punkte[i].X := ( faktor*(punkte[i].X - vonKoordinatex)) + vonKoordinatex;
    if abs(( faktor*(punkte[i].y - vonKoordinatey)) + vonKoordinatey) < 100000 then
      punkte[i].y := ( faktor*(punkte[i].y - vonKoordinatey)) + vonKoordinatey;
  end; // case
  grenzenueberpruefen;
end;

procedure TDreieck.verschiebe(dx, dy: integer);
var i: integer;
begin
  inherited;
  for i := 1 to 3 do
  begin
     punkte[i].x := punkte[i].x + dx;
     punkte[i].Y := punkte[i].y + dy;
  end;
  grenzenueberpruefen;
end;

procedure TLinie.verschiebe(dx, dy: integer);
begin
   fx1 := fx1 + dx;
   fx2 := fx2 + dx;
   fy1 := fy1 + dy;
   fy2 := fy2 + dy;
   setzeAttributex1y1x2y2;
end;

end.                                          
