unit ULetztesZeichenfenster;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TFLetztesZeichenfenster = class(TForm)
    pb: TPaintBox;
    procedure pbPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure pbMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormDestroy(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    bm: TBitmap;
    xmin, ymin: Integer;
    procedure Groesseanpassen;
  end;

var
  FLetztesZeichenfenster: TFLetztesZeichenfenster;

implementation

{$R *.dfm}

procedure TFLetztesZeichenfenster.pbPaint(Sender: TObject);
begin
   if bm <> nil then
      pb.Canvas.CopyRect(Rect(0,0,bm.Width,bm.height),bm.Canvas,Rect(0,0,bm.Width,bm.Height));
end;

procedure TFLetztesZeichenfenster.FormCreate(Sender: TObject);
begin
   bm := TBitmap.Create;
   bm.Height := 50;
   bm.Width := 300;
   Groesseanpassen;
   bm.Canvas.TextOut(10,10,'Es gibt noch kein altes Zeichenfenster.');
end;

procedure TFLetztesZeichenfenster.Groesseanpassen;
begin
   if bm.Width > 30 then width := bm.width
      else width := 30;
   if bm.height > 30 then height := bm.height
      else height := 30;
end;

procedure TFLetztesZeichenfenster.pbMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
Var s: string;
begin
   s := 'Letztes Zeichenfenster';
     s := s + ' x:' + inttostr(x-xmin) +
              ' y:' + inttostr(ymin-y);
   caption := s;
end;

procedure TFLetztesZeichenfenster.FormDestroy(Sender: TObject);
begin
  bm.free;
end;

end.
