unit USHControl;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, UCriticalSections, Printers, UUndo,
  Menus;

type
TZeichenStil = (ZKeyword, ZString, ZNormal, ZComment, ZZahl);

TZeilenInformation = class
public
   Hintergrundfarbe: TColor;
   FormatString: String;
   GeschweifteKlammeroffen: Boolean;
   Einruecken: Integer; // wie weit muss die nchste eingerueckt werden?
   DieseEinruecken: Integer; // wie weit ist diese eingerckt?
   Stop: Boolean;
end;

TFormatProzedur = function(var s: String; GeschweifteKlammerdavoroffen: Boolean;Einruecken: integer; zinfo: TZeilenInformation): integer of object;
TOnStopPosAenderung = procedure of object;

TSHControl = class(TCustomControl)
private
   RandLinks, RandRechts, Randoben, Randunten: Integer;
   RandRechtsSB, RandUntenSB: Integer; // Unter Bercksichtigung der Scrollbars
   zHoehe, zBreite: Integer; // Zeichenhoehe, Breite
   Zeilenabstand, Spaltenabstand: Integer;
   Zeilenanz, Spaltenanz: Integer;
   ZeileLinksOben, SpalteLinksOben : Integer;
   timer: TTimer;
   SBHor, SBVert: TScrollBar;
   ScrollBarbreite: Integer;

   CursorFlag: Boolean;  // BlinkStatus, true = sichtbar
   CursorErlaubt: Boolean;  // wird auf False gesetzt, wenna auch bei
                            // Focus kein Cursor erscheinen soll (z.B. beim Programmlauf)
   MarkierungvonZ, MarkierungbisZ, MarkierungvonS, MarkierungbisS: Integer;
   MaximaleStringLaenge: Integer;

   FBearbeitenerlaubt: Boolean;  // = false wenn Programm luft
   Hintergrundfarbe: TColor;     // Abhngig von FBearbeitenerlaubt

   WarGradeDoppelklick: Boolean; // Problem: Bei Doppelklick wird OnMousedown, OnDblKlick und nochmals OnMouseDown
                                 // Ausgelst. Letzteres zerstrt die Markierung.

   LetzterStil: TZeichenStil;

   CF_RTF: word;

   Undo: TUndo; // Hier werden die Undoschritte gespeichert

   // Die Eingabe von Zeichen des Alphabets und von Zahlen soll als
   // ein Undo-Schritt aufgefasst werden. Daher wird nur dann ein neuer
   // Undo-Schritt begonnen, wenn die folgende Variable true ist:
   NurZeichenEingabe: Boolean;
    FCharacterSize: integer;

   procedure EnableCursor(enabled: boolean);
   procedure paintLine(lScreen: Integer);
   procedure setStil(stil: TZeichenStil);
   procedure setPrintStil(stil: TZeichenStil);
   function setStilRtf(stil: TZeichenStil): string;
   function ConvertToRTF(s,fs: String):string;
   procedure OnTimer(Sender: TObject);
   procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
   procedure TastaturMarkierung; // Wenn Cursor bewegt wurde und Shift gedrckt
   function loescheMarkierung:Boolean;
   procedure testmaximaleStringlaenge(z: integer);
   procedure testmaximaleStringLaengeKomplett;
   procedure ScrollbarsEinrichten(vert,hor: boolean);
   procedure Scrollbartest(resize: Boolean);
   procedure PasteFromClipBoard;
   function DummyFP(var s: String; GeschweifteKlammerdavoroffen: Boolean;einruecken: integer; zinfo: TZeilenInformation): integer;
   procedure SetBearbeitenerlaubt(const Value: Boolean);
   procedure CodeCompleteTesten;
    procedure SetCharacterSize(const Value: integer);

public
   str: String;   // Fr die Zwischenablage
   Zeile: TStrings;
   cZeile, cSpalte: Integer; // Cursorposition
   cTextZeile, cTextSpalte: Integer;
   cTextZeileAlt, cTextSpalteAlt: Integer;
   FormatProzedur: TFormatProzedur;

   SyntaxCheck: TObject;

   CodeCompleteIsOpen: Boolean;
   CodeCompleteSpalte: Integer;

   modified: Boolean; // Wurde seit dem letzten Speichern etwas am Text verndert?

   SyntaxCheckNoetig: Boolean;
   SyntaxCheckCounter: integer;

   OnStopPosAenderung:TOnStopPosAenderung;

   Property PopupMenu;      // Ist in der Basisklasse TControl deklariert und
                            // wird hiermit sichtbar gemacht!

   property Bearbeitenerlaubt: Boolean read FBearbeitenerlaubt write SetBearbeitenerlaubt;

   property CharacterSize: integer read FCharacterSize write SetCharacterSize;

   procedure DoReturn;
   procedure Paint; override;
   procedure paintabzeile(Z: Integer);
   constructor create(AOwner: TComponent); override;
   destructor destroy; override;
   procedure SetCursorText(Z, S: Integer);
   procedure mOnKeypress(Sender: TObject; var Key: Char);
   procedure mOnKeyDown(Sender: TObject; var Key: Word;
                   Shift: TShiftState);
   procedure mOnKeyUp(Sender: TObject; var Key: Word;
                   Shift: TShiftState);
   procedure mMouseDown(Sender: TObject; Button: TMouseButton;
            Shift: TShiftState; X, Y: Integer);
   procedure mDBlClick(Sender: TObject);
   procedure mMouseMove(Sender: TObject; Shift: TShiftState; X,
     Y: Integer);
   procedure mMouseUp(Sender: TObject; Button: TMouseButton;
     Shift: TShiftState; X, Y: Integer);
   procedure mEnter(Sender: TObject);
   procedure mExit(Sender: TObject);
    procedure mResize(Sender: TObject);
   procedure mChange(Sender: TObject);
   procedure mMouseWheelprocedure(Sender: TObject; Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
   procedure mScrollbarEnter(sender: TObject);
   procedure GetZeileSpalte(x,y: Integer; var z,s: Integer);
   procedure FormatZeile(n: integer);
   procedure FormatAbZeile(n: integer);
   procedure FormatIntelligentZeilen(zvon,zbis: integer);
   procedure ClipboardCopy;
   procedure ClipboardPaste;
   procedure ClipboardCut;
   procedure print(NurMarkierung, Zeilennummern: Boolean);
   function getZeile(pos: Integer):Integer;
   function getSpalte(pos: Integer):Integer;
   procedure clear;
   procedure clearColor;
   procedure PositionSichtbar(z,s: integer);
   function openfile(name: string):string; // gibt die erste Zeile zurck
   procedure savefile(name, ersteZeile: string);
   procedure checkSyntax;
   procedure CodeCompleteOpen;
   procedure CodeCompleteClose;
   procedure CodeCompleteAktualisieren;
   procedure StringInsert(st: String);
   function getEinruecken(z: Integer): Integer;
   function Markierungein: Boolean;
   procedure Rueckgaengig;
   procedure Redo;
   function UndoAnzahl:Integer;
   function RedoAnzahl:Integer;
end;



implementation
uses ClipBrd, USyntaxcheck, UConstants, UCodeComplete, UMain,ImgList,
  UFehler;

{ TSHControl }


procedure TSHControl.ClipboardCopy;
Var mzv, mzb, msv, msb,i: integer;
    markierungein: boolean;
    slinks, srechts,fslinks,fsrechts, str,fstr,str1,fstr1: STring;
    rtfstring: string;
    cp : TClipboard;
    MemHandle: THandle;
begin
  mzv := MarkierungvonZ; mzb := MarkierungbisZ;
  msv := Markierungvons; msb := Markierungbiss;
  if (mzv <> mzb) or (msv <> msb) then markierungein := true
      else markierungein := false;
  if Markierungein then
  begin
    if MarkierungvonZ > MarkierungbisZ then
    begin
       mzv := MarkierungbisZ; mzb := MarkierungvonZ;
       msv := MarkierungbisS; msb := MarkierungvonS;
    end else
    if (MarkierungvonZ = MarkierungbisZ) and (MarkierungvonS > MarkierungbisS) then
    begin
       msv := MarkierungbisS; msb := MarkierungvonS;
    end;
   cp := Clipboard;
   if mzv = mzb then
   begin
      str := copy(zeile.Strings[mzv],msv+1,msb-msv);
      fstr := copy(TZeilenInformation(Zeile.Objects[mzv]).FormatString,
                    msv+1,msb-msv);
   end
   else
   begin
    srechts := copy(zeile.Strings[mzv],msv+1,length(zeile.strings[mzv])-msv);
    fsrechts := copy(TZeilenInformation(Zeile.Objects[mzv]).FormatString,
                    msv+1,length(zeile.strings[mzv])-msv);
    slinks := copy(zeile.Strings[mzb],1,msb);
    fslinks := copy(TZeilenInformation(Zeile.Objects[mzb]).FormatString,
                    1,msb);
    str := srechts;
    fstr := fsrechts;
    for i := mzv + 1 to mzb - 1 do
       begin
       str1 :=  chr(13)+ chr(10) + zeile.strings[i];
       fstr1 :=  chr(13) + chr(10) + TZeilenInformation(Zeile.Objects[i]).FormatString;
       if length(fstr1) > length(str1) then fstr1 := copy(fstr1,1,length(str1));
       str := str + str1;
       fstr := fstr + fstr1;
       end;
    str := str + chr(13)+ chr(10)  + slinks;
    fstr := fstr + chr(13)+ chr(10)  + fslinks;
   end;
   rtfString := ConvertToRTF(str,fstr);
   rtfString := rtfString + chr(0);

    MemHandle := GlobalAlloc(GHND or GMEM_SHARE, length(rtfString) + 1);
    if MemHandle <> 0 then
    begin
      StrCopy(GlobalLock(MemHandle),PChar(rtfstring));
      GlobalUnlock(MemHandle);
      cp.Open;
      try
        cp.AsText := str;
        cp.SetAsHandle(CF_RTF, MemHandle);
      finally
       cp.Close;
      end;
    end;
  end;
end;

constructor TSHControl.create(AOwner: TComponent);
begin
   inherited create(AOwner);

   Undo := TUndo.Create(100);
   NurZeichenEingabe := false;

   WarGradeDoppelklick := false;

   CF_RTF := RegisterClipboardFormat('Rich Text Format');

   ControlStyle := ControlStyle + [csOpaque];

   zHoehe := 0;
   timer := TTimer.Create(self);
   timer.Interval := 400;
   timer.Enabled := false;
   Cursorflag := false;
   Cursorerlaubt := true;
   timer.OnTimer := OnTimer;

   Bearbeitenerlaubt := true;

   FormatProzedur := DummyFP;
   OnStopPosAenderung := nil;

   ScrollBarbreite := 16;
   SBHor := TScrollBar.Create(self);
   SBHor.Parent := self;
   SBHor.Kind := sbhorizontal;
   SBHor.OnChange := mChange;
   SBHor.OnEnter := mScrollbarEnter;

   SBVert := TScrollBar.Create(self);
   SBVert.Kind := sbvertical;
   SBVert.Parent := self;
   SBVert.OnChange := mChange;
   SBVert.OnEnter := mScrollBarEnter;

   OnKeyDown := mOnKeyDown;
   OnKeyUp := mOnKeyUp;
   OnKeyPress := mOnKeypress;
   OnMouseDown := mMouseDown;
   Cursor := crIBeam;
   OnEnter := mEnter;
   OnMouseMove := mMouseMove;
   OnMouseUp := mMouseUp;
   OnExit := mExit;
   OnResize := mResize;
   OnMouseWheel := mMouseWheelprocedure;
   OnDblClick := mDBlClick;

   Zeile := TStringList.Create;
   ZeileLinksOben := 0; SpalteLinksOben := 0;
   cZeile := 0; cSpalte := 0;
   cTextZeile := 0; cTextSpalte := 0;
   RandLinks := 34; RandRechts := 2; Randoben := 3; Randunten := 2;
   testmaximaleStringLaengeKomplett;

   SyntaxCheck := TSyntaxcheck.Create(self);
   CodeCompleteIsOpen := false;

   modified := false;

   SyntaxCheckNoetig := false;
   SyntaxCheckCounter := 0;

   FCharacterSize := 10;

end;

procedure TSHControl.ClipboardCut;
begin
  if FBearbeitenerlaubt then
  begin
    try
    EntercriticalSection(CriticalSectionProgrammZeilen);
     ClipboardCopy;
     loescheMarkierung;
     Paint;
    finally
    LeaveCriticalSection(CriticalSectionProgrammZeilen);
    end;
  end;
end;

destructor TSHControl.destroy;
var i: integer;
begin
  Undo.Free;
  TSyntaxCheck(Syntaxcheck).Free;
  for i := 0 to Zeile.Count -1 do
     if Zeile.Objects[i] <> nil then
       TZeilenInformation(Zeile.Objects[i]).Free;
  Zeile.Free; timer.Free;
  inherited;
end;

procedure TSHControl.DoReturn;
Var stringlinks, stringrechts,s: string;
    zi : TZeilenInformation;
    i: integer;
begin
   if CodeCompleteIsOpen then
   begin
      s := FCodeComplete.getSelected;
      try
      enterCriticalSection(CriticalSectionProgrammZeilen);
        undo.neuerSchritt(zeile,cTextZeile,1,1,UErsetzen,cTextZeile,cTextSpalte);
        stringrechts := copy(zeile.Strings[cTextZeile],cTextSpalte+1,length(zeile.Strings[cTextZeile])-cTextSpalte);
        i := 1;
        while (i <= length(stringrechts)) and (stringrechts[i] in ['a'..'z','A'..'Z','0'..'9','_','','','','','','',''])  do
          inc(i);
        if i <= length(stringrechts) then
           stringrechts := copy(stringrechts,i,length(stringrechts) - i + 1)
           else stringrechts := '';

        stringlinks := copy(zeile.strings[cTextZeile],1,CodeCompleteSpalte-1);
        Zeile.Strings[cTextZeile] := stringlinks + s + StringRechts;
      finally
      LeaveCriticalSection(CriticalSectionProgrammZeilen);
      end;
        FormatZeile(cTextZeile);
        SetCursorText(cTextZeile,CodeCompleteSpalte + length(s) - 1);
      CodeCompleteClose;
      paintabzeile(cTextZeile-ZeileLinksOben);
      testmaximaleStringLaengeKomplett;
      checkSyntax;
   end else
   begin   // Bricht die Zeile um. Der Teil links vom Cursor wird beibehalten, dann wird nach der
           // aktuellen Zeile eine neue eingefgt, in die der rechte Teil der ursprnglichen Zeile
           // geschrieben wird ( Zeile.Insert(cTextZeile+1,stringrechts); )
      try
      enterCriticalSection(CriticalSectionProgrammZeilen);
        undo.neuerSchritt(zeile,cTextZeile,0,0,UZeilenUmbruch,cTextZeile,cTextSpalte);
        stringrechts := copy(zeile.Strings[cTextZeile],cTextSpalte+1,length(zeile.Strings[cTextZeile])-cTextSpalte);
        stringlinks := copy(zeile.strings[cTextZeile],1,cTextSpalte);
        Zeile.Strings[cTextZeile] := stringlinks;
        Zeile.Insert(cTextZeile+1,stringrechts);
      finally
      LeaveCriticalSection(CriticalSectionProgrammZeilen);
      end;
        FormatIntelligentZeilen(cTextZeile, cTextZeile + 1);
        zi := TZeileninformation(Zeile.Objects[cTextzeile + 1]);
        setcursortext(cTextZeile+1,zi.DieseEinruecken);
        paintabzeile(cTextZeile-1-ZeileLinksOben);
        testmaximaleStringLaengeKomplett;
        checkSyntax;
   end;
end;

function TSHControl.DummyFP(var s: String;
  GeschweifteKlammerdavoroffen: Boolean;Einruecken: integer; zinfo: TZeilenInformation): integer;
Var i: integer;
begin
   zinfo.FormatString :='';
   for i := 1 to length(s) do
     zinfo.FormatString := zinfo.FormatString + chr(Byte(ZNormal));
   zinfo.GeschweifteKlammeroffen := false;
   DummyFP := 0;
end;

procedure TSHControl.EnableCursor(enabled: boolean);
begin
   if enabled and Cursorerlaubt then
   begin
     if (timer.Enabled = false) and Focused then
     begin // Einschalten
       CursorFlag := false;
       OnTimer(self);
       timer.Enabled := true;
     end
   end
   else begin
      timer.Enabled := false;
      if CursorFlag then OnTimer(self);
   end;
end;




procedure TSHControl.FormatAbZeile(n: integer);
Var i: integer;
begin
  try
  EntercriticalSection(CriticalSectionProgrammZeilen);
   for i := n to Zeile.Count -1 do
     FormatZeile(i);
  finally
  LeaveCriticalSection(CriticalSectionProgrammZeilen);
  end;
end;

procedure TSHControl.FormatZeile(n: integer);
Var GKlammer: boolean;
    einruecken, zuseingerueckt: integer;
    s: string;
begin
   if zeile.Objects[n] = nil then
   begin
     zeile.Objects[n] := TZeilenInformation.Create;
     TZeilenInformation(zeile.Objects[n]).Hintergrundfarbe := clwhite;
     TZeilenInformation(zeile.Objects[n]).Einruecken := 0;
     TZeilenInformation(zeile.Objects[n]).Stop := false;
   end;
   if n = 0 then GKlammer := false
     else if zeile.Objects[n-1] <> nil then GKlammer := TZeilenInformation(zeile.Objects[n-1]).GeschweifteKlammeroffen
       else
       begin
         FormatZeile(n-1);
         GKlammer := TZeilenInformation(zeile.Objects[n-1]).GeschweifteKlammeroffen;
       end;
   if n = 0 then einruecken := 0
     else if zeile.Objects[n-1] <> nil then Einruecken := TZeilenInformation(zeile.Objects[n-1]).Einruecken
       else
       begin
         FormatZeile(n-1);
         Einruecken := TZeilenInformation(zeile.Objects[n-1]).Einruecken;
       end;
   s := zeile.Strings[n];
   zuseingerueckt := FormatProzedur(s,GKlammer,Einruecken,TZeilenInformation(zeile.Objects[n]));
   if zuseingerueckt <> 0 then
        zeile.Strings[n] := s;
   if n = cTextZeile then SetCursorText(cTextZeile,cTextSpalte + zuseingerueckt);
end;

procedure TSHControl.GetZeileSpalte(x, y: Integer; var z, s: Integer);
Var Sscreen,zscreen: integer;
begin
   SScreen := trunc( (x-RandLinks)/(ZBreite+spaltenAbstand));
   zScreen := trunc((y-Randoben)/(ZHoehe + zeilenabstand));
   s := sScreen + SpalteLinksOben; z := zScreen + ZeileLinksOben;
     if z > zeile.Count -1 then
        z := zeile.Count -1;
     if z < 0 then z := 0;
     if s < 0 then s := 0;
     if zeile.Count > 0 then
     begin
       if s > length(zeile.Strings[z]) then
          s := length(zeile.Strings[z]);
     end else s := 0;
end;

function TSHControl.loescheMarkierung: Boolean;
Var mzv, mzb, msv, msb,i: integer;
    markierungein: boolean;
    slinks, srechts: STring;
    AnzahlLoeschenBeimUndo: Integer;
begin
  mzv := MarkierungvonZ; mzb := MarkierungbisZ;
  msv := Markierungvons; msb := Markierungbiss;
  if (mzv <> mzb) or (msv <> msb) then markierungein := true
      else markierungein := false;
  if Markierungein then
  begin
    modified := true;
    if MarkierungvonZ > MarkierungbisZ then
    begin
       mzv := MarkierungbisZ; mzb := MarkierungvonZ;
       msv := MarkierungbisS; msb := MarkierungvonS;
    end else
    if (MarkierungvonZ = MarkierungbisZ) and (MarkierungvonS > MarkierungbisS) then
    begin
       msv := MarkierungbisS; msb := MarkierungvonS;
    end;
  try
  EntercriticalSection(CriticalSectionProgrammZeilen);
         if (msv > 0) or (msb < length(zeile.Strings[mzb])) then
             AnzahlLoeschenBeimUndo := 1 else AnzahlLoeschenBeimUndo := 0;
         undo.neuerSchritt(zeile,mzv,AnzahlLoeschenBeimUndo,mzb-mzv+1,UErsetzen,cTextZeile,cTextSpalte);
         undo.EsKommenZweiSchritte;
    slinks := copy(zeile.Strings[mzv],1,msv);
    srechts := copy(zeile.Strings[mzb],msb+1,length(zeile.Strings[mzb])-msb);
    zeile.Strings[mzv] := slinks + srechts;
    if mzv <> mzb then
       begin
          for i := mzv +1 to mzb do
          begin
             TZeileninformation(Zeile.Objects[mzv+1]).free;
             Zeile.Objects[mzv+1] := nil;
             zeile.Delete(mzv+1);
          end;
          // Immer derselbe Index, denn die hinteren rcken nach!
       end;
  finally
  LeaveCriticalSection(CriticalSectionProgrammZeilen);
  end;
  SetCursorText(mzv,msv);
  markierungvonZ := mzv; markierungbisZ := mzv;
  markierungvons := msv; markierungbisS := msv;
  end;
  if markierungein then
  begin
     FormatIntelligentZeilen(mzv,mzv + 1);
     paintabzeile(mzv - ZeileLinksOben);
  end;
  testmaximaleStringLaengeKomplett;
  loescheMarkierung := markierungein;
end;

procedure TSHControl.mChange(Sender: TObject);
begin
   if Sender = SBHor then
   begin
      if Spaltelinksoben <> SBHor.Position then
         begin
           Spaltelinksoben := SBHor.Position;
           paintabzeile(0);
         end;
   end else
      if Zeilelinksoben <> SBVert.Position then
         begin
            Zeilelinksoben := SBVert.position;
            paintabzeile(0);
         end;
   begin
   end;
   EnableCursor(false);
   cZeile := cTextZeile - ZeileLinksOben; cSpalte := cTextSpalte - SpalteLinksOben;
   EnableCursor(true);
end;

procedure TSHControl.mEnter(Sender: TObject);
begin
  if cursorErlaubt then EnableCursor(true);
end;

procedure TSHControl.mExit(Sender: TObject);
begin
  EnableCursor(false);
  if CodeCompleteIsOpen then CodeCompleteclose;
end;

procedure TSHControl.mMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
Var S, Z: Integer;
    zi: TZeilenInformation;
    einruecken: integer;
begin
   if (not WarGradeDoppelklick) and (Button = mbLeft) then
   begin
     CodeCompleteClose;
     SetFocus;
     if x > RandLinks then
     begin
       NurZeichenEingabe := false;
       GetZeileSpalte(x,y,z,s); // Schreibt in z,s die TextZeile, TextSpalte
                                // (realistische Werte!)
       einruecken := getEinruecken(z);
       if s < Einruecken then s := Einruecken;
       SetCursorText(z,s);

       if ssShift in Shift then
       begin
          MarkierungbisZ := z; MarkierungbisS := s;
          paintabzeile(0);
       end else
       begin
          MarkierungvonZ := z; MarkierungvonS := s;
          MarkierungbisZ := z; MarkierungbisS := s;
          paintabzeile(0);
       end;
     end else
     begin
        z := trunc( (y - Randoben - Zeilenabstand)/(Zeilenabstand + zHoehe) + ZeileLinksoben);
        if (z >= 0) and (z <= Zeile.Count -1) then
        begin
          try
          EntercriticalSection(CriticalSectionProgrammZeilen);
            zi := TZeileninformation(Zeile.objects[z]);
            if zi = nil then
            begin
               FormatZeile(z);
               zi := TZeileninformation(Zeile.objects[z]);
            end;
            zi.Stop := not zi.Stop;
            paintline(z-Zeilelinksoben);
          finally
          LeaveCriticalSection(CriticalSectionProgrammZeilen);
          end;
        OnStopPosAenderung;
        end;
     end;
   end else WarGradeDoppelklick := false;
end;

procedure TSHControl.mMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
Var S, Z: Integer;
begin
   if x <= RandLinks then
   begin
     Cursor := crDefault;
   end else
   begin
     Cursor := crIBeam;
     // die 17000 sind ein workaround fr den Bug beim Laden...
     if (ssLeft in Shift)and
     not((markierungvonZ = 17000) and (markierungbisz = 17000)) then
     begin
        GetZeileSpalte(x,y,z,s);
        if (MarkierungbisZ <> z) or (MarkierungbisS <> s) then
        begin
          MarkierungbisZ := z; MarkierungbisS := s;
          paintabZeile(0);
          SetCursorText(z,s);
        end;
     end;
   end;
end;

procedure TSHControl.mMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
//Var S, Z, einruecken: Integer;
begin
{   if x > RandLinks then
   begin
      GetZeileSpalte(x,y,z,s);
      einruecken := getEinruecken(z);
      if s < einruecken then
         setcursorText(z,einruecken);
   end; }
end;

procedure TSHControl.mMouseWheelprocedure(Sender: TObject;
  Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
Var z, zmax: integer;
begin
   zmax := zeile.count {-1} - Zeilenanz;
   if zmax < 0 then zmax := 0;
   z := zeileLinksoben - trunc(WheelDelta/120);
   if z < 0 then z := 0
   else if z > zmax then z := zmax;
   zeileLinksOben := z;
   EnableCursor(false);
   cZeile := cTextZeile - ZeileLinksOben; cSpalte := cTextSpalte - SpalteLinksOben;
   EnableCursor(true);
   SBVert.Position := z;
   paint;
   Handled := true;
end;

procedure TSHControl.mOnKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
Var z,s: integer;
    st: string;
    markierungwarda: boolean;
    markierungnichtloeschen: boolean;
    einruecken: integer;
begin
   if FBearbeitenerlaubt then
   begin
      markierungnichtloeschen := false;
      if Key <> 16 then
      begin
        z := cTextZeile; s := cTextSpalte;
        case Key of
          9: begin                 // TAB
                  CodeCompleteTesten;
                  Key := 0;
                  NurZeichenEingabe := false;
              end;
          27: CodeCompleteClose;   // ESC
          38: begin // Pfeil nach oben
                  NurZeichenEingabe := false;
                if CodeCompleteIsOpen then FCodeComplete.up
                 else begin
                   if z > 0 then
                   begin
                    dec(z);
                    einruecken := getEinruecken(z);
                    if s < Einruecken then s := Einruecken;
                    SetCursorText(z,s);
                   end;
                 end;
              end;
          40: begin // Pfeil nach unten
                 NurZeichenEingabe := false;
                If CodeCompleteIsOpen then FCodeComplete.down
                else
                begin
                  if z < Zeile.Count - 1 then
                   begin
                    inc(z);
                    einruecken := getEinruecken(z);
                       if s < Einruecken then s := Einruecken;
                    SetCursorText(z,s);
                   end;
                end;
              end;
          39: begin // Pfeil nach rechts
                 NurZeichenEingabe := false;
                if s < length(Zeile.strings[z]) then
                begin
                   inc(s);
                end
                else
                begin
                   CodeCompleteClose;
                   if z < Zeile.Count -1 then
                   begin
                      inc(z);
                      s := getEinruecken(z);
                   end;
                end;
                SetCursorText(z,s);
                CodeCompleteAktualisieren;
              end;
          37: begin // Pfeil nach links
                 NurZeichenEingabe := false;
                 if s > getEinruecken(z) then
                 begin
                   dec(s);
                 end
                 else
                 begin
                    CodeCompleteClose;
                    if z > 0 then
                    begin
                       dec(z);
                       s := length(Zeile.Strings[z]);
                    end;
                 end;
                 SetCursorText(z,s);
                 CodecompleteAktualisieren;
              end;
          45: begin // Einfg
                 NurZeichenEingabe := false;
                modified := true;
                if ssShift in Shift then
                begin
                   CodeCompleteClose;
                   loescheMarkierung;
                   PasteFromClipBoard;
                   paint; // Einfgen
                end else
                if ssCtrl in Shift then
                begin
                  CodeCompleteClose;
                  ClipboardCopy;
                  markierungnichtloeschen := true;
                end;
                checkSyntax;
              end;
          46:   begin     // Entf
                 NurZeichenEingabe := false;
                  modified := true;
                  if ssShift in Shift then
                  begin
                     ClipboardCopy;
                  end;
                  if not loeschemarkierung then
                  begin // Entf
                    z := cTextzeile;
                    s := cTextSpalte;
                    try
                    EntercriticalSection(CriticalSectionProgrammZeilen);
                      if s < length(Zeile.Strings[z]) then
                      begin  // Aus der aktuellen Zeile kann man noch was rauslschen
                         undo.neuerSchritt(zeile,z,1,1,UErsetzen,z,s);
                         st := copy(Zeile.Strings[z],1,s);
                         st := st + copy(Zeile.Strings[z],s+2,length(Zeile.Strings[z]));
                         Zeile.Strings[z] := st;
                      end else
                      begin
                           if z < Zeile.Count - 1 then
                           begin
                              undo.neuerSchritt(zeile,z,1,2,UErsetzen,z,s);
                              zeile.Strings[z] := zeile.Strings[z] +
                                     zeile.Strings[z+1];
                              TZeileninformation(zeile.Objects[z+1]).free;
                              zeile.Objects[z+1] := nil;
                              zeile.Delete(z+1);
                           end;
                      end;
                    finally
                    LeaveCriticalSection(CriticalSectionProgrammZeilen);
                    end;
                    FormatIntelligentZeilen(z,z);
                    testmaximaleStringlaenge(z);
                    CodeCompleteTesten;
                  end else
                   begin
                   CodeCompleteClose;
                   // FormatabZeile(z); macht loeschemarkierung schon
                  end;
                  paintabZeile(z-ZeileLinksOben);
                  checkSyntax;
                end;
          36: begin // Pos1
                 NurZeichenEingabe := false;
                 CodeCompleteClose;
                 SetCursorText(z,0);
              end;
          35: begin // Ende
                 NurZeichenEingabe := false;
                 CodeCompleteClose;
                 SetCursorText(z, length(Zeile.Strings[z]));
              end;
          33: begin // Bild auf
                 NurZeichenEingabe := false;
                 CodeCompleteClose;
                 if z >= Zeilenanz then SetCursorText(z-Zeilenanz,s)
                   else SetCursorText(0,s);
              end;
          34: begin // Bild ab
                 NurZeichenEingabe := false;
                 CodeCompleteClose;
                 if z + Zeilenanz <= Zeile.Count -1 then
                    SetCursorText(z+Zeilenanz,s)
                    else SetCursorText(Zeile.Count -1,s);
              end;
        end;// case
         if (ssShift in Shift) then
         begin
            if key in [37,38,39,40,34,35,36] then
            TastaturMarkierung;
         end else
         begin
           if (key in [33..46]) and not markierungnichtloeschen then
           begin
             if (markierungvonZ <> markierungbisZ) or (markierungvonS <> markierungbisS) then
                markierungwarda := true else markierungwarda := false;
             markierungvonZ := cTextZeile; markierungbisZ := cTextZeile;
             markierungvons := cTextSpalte; markierungbisS := cTextSpalte;
             if markierungwarda then paintabzeile(0);
           end;
         end;
         ScrollBarTest(false);
      end;
   end; // if FBearbeitenerlaubt
end;

procedure TSHControl.mOnKeypress(Sender: TObject; var Key: Char);
Var z,s,i: Integer;
    st: string;
    markierungnichtloeschen: boolean;
    NurSpacedavor: boolean;
begin
  if FBearbeitenerlaubt then
  begin
     markierungnichtloeschen := false;
     z := cTextzeile;
     s := cTextSpalte;
     if ord(key) >= 32 then  //Zeichen ausgeben
     begin
        modified := true;
        loescheMarkierung;
        z := cTextzeile;
        s := cTextSpalte;
        try
          EntercriticalSection(CriticalSectionProgrammZeilen);
          // Nur dann Undo-zwischenspeichern, wenn seit dem letzten Speichern etwas
          // anderes geschah als bloe Zeicheneingabe
          if not NurZeichenEingabe then
             undo.neuerSchritt(zeile,z,1,1,UErsetzen,cTextZeile,cTextSpalte);
          NurZeichenEingabe := true;
          st := copy(zeile.Strings[z],1,s) + Key + copy(zeile.Strings[z],s+1,length(zeile.strings[z])-s);
          zeile.Strings[z] := st;
        finally
          LeaveCriticalSection(CriticalSectionProgrammZeilen);
        end;
        SetCursorText(cTextZeile, cTextspalte + 1);
        formatIntelligentZeilen(z,z);
        testmaximaleStringlaenge(z);
        paintabZeile(z-Zeilelinksoben);
        checkSyntax;
        CodeCompleteTesten;
     end
     else
     begin
        case ord(key) of
          3: begin   //ctrl+c  ,kopieren
                CodeCompleteClose;
                markierungnichtloeschen := true;
                ClipboardCopy;
             end;
          22: begin  // ctrl+v , Einfgen
                 modified := true;
                 CodeCompleteClose;
                 loescheMarkierung;
                 PasteFromClipBoard;
                 paint; checkSyntax;
                 NurZeichenEingabe := false;
              end;
          24: begin  // ctrl+x
                 modified := true;
                 CodeCompleteClose;
                 ClipboardCopy;
                 loescheMarkierung;
                    undo.WarDochNurEiner;
                    // Ntig, da loescheMarkierung Undo andeutet, dass ein zweiter Schritt dazukommt
                 checkSyntax;
                 NurZeichenEingabe := false;
              end;
          13: begin // Return
                modified := true;
                DoReturn; checkSyntax;
                NurZeichenEingabe := false;
              end;
          8:  begin // backspace
                 modified := true;
                 NurZeichenEingabe := false;
                 if not loeschemarkierung then
                 begin // BackSpace
                   z := cTextzeile;
                   s := cTextSpalte;
                   try
                   EntercriticalSection(CriticalSectionProgrammZeilen);
                     i := s ; NurSpacedavor := (i > 0);
                     while (i > 0) and (nurSpacedavor) do
                        begin
                           if zeile.Strings[z][i] <> ' ' then NurSpacedavor := false;
                           dec(i);
                        end;
                   finally
                   LeaveCriticalSection(CriticalSectionProgrammZeilen);
                   end;
                   if (s > 0) and not (NurSpacedavor) then
                   begin // Es ist noch was zum Lschen da
                     try
                     EntercriticalSection(CriticalSectionProgrammZeilen);
                         undo.neuerSchritt(zeile,z,1,1,UErsetzen,z,s);
                         zeile.Strings[z] := copy(zeile.Strings[z],1,s-1) +
                         copy(zeile.Strings[z],s+1,length(zeile.Strings[z])-s);
                     finally
                     LeaveCriticalSection(CriticalSectionProgrammZeilen);
                     end;
                       SetCursorText(z, s - 1);
                       EnableCursor(false); EnableCursor(true);
                     CodeCompleteAktualisieren;
                     FormatIntelligentZeilen(z,z);
                   end else
                   begin
                      CodeCompleteClose;
                      if z > 0 then
                      begin
                         try
                         EntercriticalSection(CriticalSectionProgrammZeilen);
                           undo.neuerSchritt(zeile,z-1,1,2,UErsetzen,z,s);
                           i := length(zeile.Strings[z-1]);
                           zeile.Strings[z-1] := zeile.Strings[z-1] + copy(zeile.Strings[z],s + 1,length(zeile.strings[z]) - s );
                           TZeileninformation(zeile.Objects[z]).Free;
                           zeile.Objects[z] := nil;
                           zeile.Delete(z);
                         finally
                         LeaveCriticalSection(CriticalSectionProgrammZeilen);
                         end;
                         setCursorText(z-1,i);
                         testmaximaleStringlaenge(z-1);
                         z := z - 1;
                         formatintelligentzeilen(z,z+1);
                      end;
                   end;
                   CodeCompleteTesten;
                 end;// else formatabzeile(z);   macht loeschemarkierung schon
                 paintabzeile(z-ZeileLinksOben);
                 checkSyntax;
              end;
        end; // case
     end;
           // TODO
    if not markierungnichtloeschen then
    begin
     MarkierungvonZ := z; markierungbisz := z;
     markierungvons := s; markierungbiss := s;
    end;
     ScrollBarTest(false);
  end;
end;

procedure TSHControl.mOnKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

end;

procedure TSHControl.mResize(Sender: TObject);
begin
 if (width > 30) and (height > 30) then
 begin
    Paint;
    Scrollbartest(true);
    Paint;
 end;
end;

procedure TSHControl.OnTimer(Sender: TObject);
Var x,y: Integer;
    color: TColor;
    ps: TPenStyle;
    pm: TPenMode;
begin
  if (cZeile >= 0) and (CZeile <= Zeilenanz -1) and
     (cSpalte >= 0) and (CSpalte <= Spaltenanz ) then
  begin
    CursorFlag := not CursorFlag;
    x := cSpalte *(zBreite + Spaltenabstand) + RandLinks - 1;
    y := cZeile * (zHoehe + Zeilenabstand) + RandOben + 2;
    color := canvas.Pen.Color; ps := canvas.Pen.Style; pm := canvas.Pen.Mode;
    canvas.Pen.Style := psSolid;
    canvas.Pen.Mode := pmNot; canvas.pen.color := clblack;
    canvas.MoveTo(x,y); canvas.LineTo(x,y+zHoehe+Zeilenabstand-1);
    canvas.MoveTo(x+1,y); canvas.LineTo(x+1,y+zHoehe+Zeilenabstand-1);
    canvas.Pen.Style := ps; canvas.Pen.Color := color; canvas.pen.Mode := pm;
  end;
end;

procedure TSHControl.Paint;
begin
   if (width > 30) and (height > 30) then
   begin
     SBHor.Repaint; SBVert.Repaint;

     canvas.Brush.Style := bsSolid;
     canvas.Pen.Style := psSolid;
     canvas.pen.mode := pmCopy;

     canvas.Pen.Color := clGray;
     canvas.MoveTo(0,height -1);
     canvas.LineTo(0,0); canvas.LineTo(width -1,0);

     canvas.Pen.Color := clwhite;
     canvas.MoveTo(width-1,0);canvas.LineTo(width-1,height-1);
     canvas.LineTo(-1,height-1);

     canvas.Pen.Color := clBlack;
     canvas.MoveTo(1,height -3); canvas.LineTo(1,1);
     canvas.LineTo(width -2,1);

     canvas.Pen.Color := cl3DLight;
     canvas.MoveTo(width - 2,1);canvas.LineTo(width-2,height-2);
     canvas.LineTo(0,height -2);

     // Konstanten
     canvas.Font.Name := 'Courier New';
     canvas.Font.Size := FCharacterSize;
     //if zHoehe = 0 then zHoehe := canvas.TextHeight('HMg|"');
     zhoehe := FCharacterSize + 6;
     zBreite:= canvas.TextWidth('W');
     Zeilenabstand := ((zhoehe - 16) div 4) + 1; Spaltenabstand := 0;
     try
       Spaltenanz := trunc( (Width - (RandLinks + RandRechtsSB+4))/(zBreite + SpaltenAbstand)) ;
       Zeilenanz := trunc ( (height - (Randoben + RandUntenSB))/(zHoehe + Zeilenabstand) ) ;
     except
        Spaltenanz := 10;
        Zeilenanz := 10;
     end;
     paintabzeile(0);
     inherited paint;
   end;
end;

procedure TSHControl.paintabzeile(Z: Integer);
Var i: Integer;
begin
  EnableCursor(false);
  try
  EntercriticalSection(CriticalSectionProgrammZeilen);
   for i := z to Zeilenanz -1 do
       paintLine(i);
  finally
  LeaveCriticalSection(CriticalSectionProgrammZeilen);
  end;
  //if z = 0 then
   EnableCursor(true);
end;

procedure TSHControl.paintLine(lScreen: Integer);
Var z,x,y,i,fehlerx: Integer;
    maxSpalte: Integer;
    mzv, mzb, msv, msb: integer;
    color: TColor;
    markierungein: boolean;
    zi : TZeilenInformation;
    fehler: TFehler;
begin
      color := Hintergrundfarbe;
      mzv := MarkierungvonZ; mzb := MarkierungbisZ;
      msv := Markierungvons; msb := Markierungbiss;
    if (mzv <> mzb) or (msv <> msb) then markierungein := true
       else markierungein := false;
    if Markierungein then
    begin
      if MarkierungvonZ > MarkierungbisZ then
      begin
         mzv := MarkierungbisZ; mzb := MarkierungvonZ;
         msv := MarkierungbisS; msb := MarkierungvonS;
      end else
      if (MarkierungvonZ = MarkierungbisZ) and (MarkierungvonS > MarkierungbisS) then
      begin
         msv := MarkierungbisS; msb := MarkierungvonS;
      end;
    end;
    z := ZeileLinksoben + lScreen; // Zeile im Quelltext
    y := Randoben + lScreen*(zHoehe + Zeilenabstand)+ Zeilenabstand;
    x := Randlinks + Spaltenabstand;

      canvas.Brush.Color := clBtnFace;
      canvas.Pen.Color := clBtnFace;
      canvas.Rectangle(2,y-2,34,y+zHoehe+2);

      canvas.pen.Color := clblack;
      canvas.Pen.Style := psSolid;
      canvas.Pen.Width := 1;
      canvas.MoveTo(RandLinks - 3,y-2);
      canvas.LineTo(Randlinks -3, y + zHoehe + 2);

      canvas.Pen.Color := HintergrundFarbe;
      canvas.Pen.Style := psClear;
    if zeile.Count - 1 >= z then
    begin
      if zeile.Objects[z] = nil then
         begin
           formatZeile(z);
         end;
      zi := TZeilenInformation(zeile.Objects[z]);
      color := zi.Hintergrundfarbe;
      if color = clwhite then color := Hintergrundfarbe;

      if length(zeile.Strings[z]) - 1 >= SpalteLinksOben then
      begin
         if SpalteLinksoben + Spaltenanz - 1 < length(zeile.Strings[z]) -1 then
            maxSpalte := SpalteLinksOben + Spaltenanz -1
            else maxSpalte := length(zeile.Strings[z]) - 1;

         for i := SpalteLinksoben to maxSpalte do
         begin
            setStil(TZeichenStil(ord(zi.FormatString[i+1])));
            if markierungein then
            begin
               if (mzv < mzb) and
               (
               ((z > mzv) and (z < mzb)) or
               ((z = mzv) and (i >= msv)) or
               ((z = mzb) and (i < msb))
               ) or
               ( (z = mzv) and (i >= msv) and (i < msb) ) then
               begin
               canvas.Brush.Color := $700000; canvas.font.color := clwhite;
               end
               else canvas.Brush.Color := color;
            end else canvas.Brush.color := color;
            if i = spaltelinksoben then
              canvas.Rectangle(x-1,y-1,x+zBreite+1,y+zHoehe+Zeilenabstand)
              else
              begin
                 canvas.Rectangle(x,y-1,x+zBreite+1,y+zHoehe+Zeilenabstand);
              end;
            canvas.TextOut(x,y,(zeile.Strings[z])[i+1]);
            x := x + Zbreite + Spaltenabstand;
         end;
      // Rest einer Zeile wei machen
      if (mzv < mzb) and (z >= mzv) and (z < mzb) then
         canvas.Brush.Color := $700000
         else canvas.Brush.Color := color;
      if Spaltelinksoben = maxSpalte then
         canvas.Rectangle(x-1,y-1,width - RandRechtsSB,y+zHoehe+Zeilenabstand)
         else canvas.Rectangle(x,y-1,width - RandRechtsSB,y+zHoehe+Zeilenabstand);

      end
      else
      begin // Leere Zeile (String = '')
         if (mzv < mzb) and (z >= mzv) and (z < mzb) then
            canvas.Brush.Color := $700000
            else canvas.Brush.Color := color;
        canvas.Rectangle(x-1,y-1,width - RandRechtsSB,y+zHoehe+Zeilenabstand+1);
      end;

        if zi.Stop then
        FMain.ImageList1.Draw(canvas,17,y,5,dsTransparent,itImage,true);
        if Fehlerverwaltung <> nil then
        for i := 0 to FehlerVerwaltung.Fehler.Count -1 do
        begin
          fehler := TFehler(FehlerVerwaltung.Fehler.Items[i]);
          if fehler.Zeile = z then
          begin
             FMain.ImageList1.Draw(canvas,3,y,3,dsTransparent,itImage,true);
             if Fehler.Spalte <= Spaltenanz then
             begin
             Fehlerx := Randlinks + Spaltenabstand + (fehler.Spalte-1) * (zBreite + Spaltenabstand);
             FMain.ImageList1.Draw(canvas,Fehlerx,y-1,4,dsTransparent,itImage,true);
             end;
          end;
        end;

    end   // if Zeile.count -1 >= z
      else   // Zeile gibt's im Text noch nicht
      begin
         if (mzv < mzb) and (z >= mzv) and (z < mzb) then
            canvas.Brush.Color := $700000
            else canvas.Brush.Color := color;
        canvas.Rectangle(x-1,y-2,width - RandRechtsSB,y+zHoehe+2);
      end;
    if lScreen = Zeilenanz -1 then
    begin
       canvas.Brush.Color := Hintergrundfarbe;
       canvas.Rectangle(Randlinks + Spaltenabstand-1,y+ZHoehe-2,
           width - RandRechtsSB,height - RandUntenSB);
      canvas.Brush.Color := clBtnFace;
      canvas.Pen.Color := clBtnFace;
      canvas.Rectangle(2,y+ZHoehe-2,33,height - RandUntenSB);

      canvas.pen.Color := clblack;
      canvas.Pen.Style := psSolid;
      canvas.Pen.Width := 1;
      canvas.MoveTo(RandLinks - 3,y+ZHoehe-2);
      canvas.LineTo(Randlinks -3, height - RandUntenSB);

    end;
end;

procedure TSHControl.ClipboardPaste;
begin
 if FBearbeitenerlaubt then
 begin
   loescheMarkierung;
   PasteFromClipBoard;
   Scrollbartest(false);
   paint; // Einfgen
 end;
end;

procedure TSHControl.PasteFromClipBoard;
Var cp: TClipboard;
    st,stanfang, stende: String;
    z,s,pos: Integer;
    c: char;
    ZeilenAnzahl: Integer;
begin
   modified := true;
   cp := Clipboard;
   if cp.HasFormat(CF_TEXT) then
   begin
     try
       EntercriticalSection(CriticalSectionProgrammZeilen);
       st := cp.AsText;
       z := cTextZeile; s := cTextSpalte;
       if z > Zeile.Count -1 then
       begin
          Zeile.Insert(z,'');
          z := Zeile.count -1;
       end;
       ZeilenAnzahl := 1;
       for pos := 1 to length(st) do
          if st[pos] = chr(13) then inc(ZeilenAnzahl);
       undo.neuerSchritt(zeile,z,ZeilenAnzahl,1,UErsetzen,z,s);

       stanfang := copy(zeile.Strings[z],1,s);
       stende := copy(zeile.Strings[z],s+1,length(zeile.Strings[z])-s);
       zeile.Strings[z] := stanfang;
       for pos := 1 to length(st) do
       begin
          c := st[pos];
          case ord(c) of
          13 : begin
                  z := z + 1;
                  zeile.Insert(z,'');
               end;
          10: begin end;
          12: zeile.Strings[z] := zeile.Strings[z] + '   '; // tab
          else zeile.Strings[z] := zeile.Strings[z] + c;
          end; // case
       end;
       s := length(zeile.Strings[z]);
       zeile.Strings[z] := zeile.Strings[z] + stende;
     finally
       LeaveCriticalSection(CriticalSectionProgrammZeilen);
     end;
     FormatintelligentZeilen(cTextZeile,z);
     SetCursorText(z,s);
     PositionSichtbar(z,s);
   end;
   testmaximaleStringLaengeKomplett;
end;

procedure TSHControl.ScrollbarsEinrichten(vert, hor: boolean);
Var neuzeichnen: Boolean;
begin
   if vert then
     SBHor.SetBounds(3,height - Randunten - Scrollbarbreite,
     width - Randrechts - Scrollbarbreite - 3-1,ScrollBarBreite)
     else
     SBHor.SetBounds(3,height - Randunten - Scrollbarbreite,
     width - Randrechts - 3,ScrollBarBreite);

   if (hor <> SBHor.Visible) or (vert <>SBVert.Visible) then
   neuzeichnen := true
      else neuzeichnen := false;
   if hor then
   begin
      SBHor.Show;
      RandUntenSB := RandUnten + ScrollBarBreite;
   end else
   begin
      SBHor.Hide;
      RandUntenSB := RandUnten;
   end;

   if Hor then
     SBVert.SetBounds(width - Scrollbarbreite - RandRechts,
     Randoben,ScrollBarbreite,
     height- Randunten - Scrollbarbreite-RandOben-1)
     else
     SBVert.SetBounds(width - Scrollbarbreite - RandRechts-1,
     Randoben,ScrollBarbreite,
     height- Randunten -RandOben);

   if vert then
   begin
      SBvert.Show;
      RandRechtsSB := RandRechts + ScrollbarBreite +1{-1};
   end else
   begin
      SBvert.Hide;
      RandRechtsSB := RandRechts;
   end;
   if neuzeichnen then paint;
end;

procedure TSHControl.Scrollbartest(resize: Boolean);
Var horein, Vertein: Boolean;
begin
   if (MaximaleStringLaenge-1 > Spaltenanz -1) then
   begin
        horein := true;
      if not SBHor.visible then
      begin
        SBHor.Position := 0;
        SBHor.min := 0; SBHor.Max := MaximaleStringLaenge-1;
        SBHor.PageSize := Spaltenanz;
        SBHor.LargeChange := SpaltenAnz-1;
        SBHor.Position := SpalteLinksOben;
      end;
   end else
   begin
    horein := false;
    if SBHor.Visible then
      begin
       SBHor.Position := 0;
       SBHor.PageSize := 1;
      end;
   end;
   if (Zeile.Count-1 > Zeilenanz -1) then
   begin
        vertein :=true;
      if not SBVert.visible then
      begin
        SBVert.Position := 0;
        SBVert.Min := 0; SBVert.Max := Zeile.Count-1;
        SBVert.PageSize := Zeilenanz-1;
        SBVert.LargeChange := Zeilenanz-1;
        SBVert.Position := ZeileLinksOben;
      end
      else
      begin
         SBVert.PageSize := Zeilenanz;
         SBVert.Max := zeile.Count - 1;
      end;
   end else
   begin
      vertein := false;
      if SBVert.Visible then
      begin
         SBVert.Position := 0;
         SBVert.PageSize := 1;
      end;
   end;
   if (horein <> sBHor.Visible) or (vertein <> SBVert.Visible) or resize then
      begin
          ScrollbarsEinrichten(vertein,horein);
          SetCursorText(cTextZeile, cTextSpalte);
      end;
end;

procedure TSHControl.SetCursorText(Z, S: Integer);
Var cz,cs: Integer;
    ZLiObAlt, SpLiObAlt: Integer;
    zcount: integer;
begin
 if FBearbeitenerlaubt then
 begin
   if s < 0 then s := 0;
   cTextZeileAlt := cTextZeile; cTextSpalteAlt := cTextSpalte;
   ZLiObAlt := ZeileLinksOben; SpLiObAlt := SpalteLinksOben;
   try
     EnterCriticalSection(CriticalSectionProgrammZeilen);
     zcount := zeile.Count;
   finally
     LeaveCriticalSection(CriticalSectionProgrammZeilen);
   end;
   if z <= zCount -1 then
   begin
   try
     EnterCriticalSection(CriticalSectionProgrammZeilen);
     if s > length(zeile.Strings[z])  then s := length(zeile.Strings[z]);
   finally
     LeaveCriticalSection(CriticalSectionProgrammZeilen);
   end;
     cz := z - Zeilelinksoben; cs := s - spaltelinksoben;
     EnableCursor(false);
     if cz > Zeilenanz - 1 then
     begin
        Zeilelinksoben := zeilelinksoben + (cz - (Zeilenanz-1));
        cZeile := Zeilenanz - 1;
     end else
     if cz < 0 then
     begin
        Zeilelinksoben := zeilelinksoben + cz; // cz < 0!
        cZeile := 0;
     end else cZeile := cz;
     if cs > Spaltenanz then
     begin
        Spaltelinksoben := Spaltelinksoben + (cs - (Spaltenanz));
        cSpalte := Spaltenanz;
     end else
     if cs < 0 then
     begin
        Spaltelinksoben := SpalteLinksOben + cs; // cs < 0!
        csPalte := 0;
     end else cSpalte := cs;
     cTextZeile := z; cTextSpalte := s;
     if (ZLiObAlt <> ZeileLinksOben) or (SpLiObAlt <> SpalteLinksOben) then
        begin
          if SBHor.Visible then SBHor.Position := SpalteLinksOben;
          if SBVert.Visible then SBVert.Position := ZeileLinksOben;
          paint;
        end;
     enablecursor(true);
   end else
   begin
   try
     EnterCriticalSection(CriticalSectionProgrammZeilen);
     zcount := zeile.Count;
   finally
     LeaveCriticalSection(CriticalSectionProgrammZeilen);
   end;
     if ZCount = 0 then
     begin
     try
       EnterCriticalSection(CriticalSectionProgrammZeilen);
        Zeile.Add('');
        FormatZeile(0);
     finally
       LeaveCriticalSection(CriticalSectionProgrammZeilen);
     end;
        cTextZeile := 0; cTextSpalte := 0;
        ZeileLinksOben := 0; spalteLinksOben := 0;
        Paint;
     end;
   end;
  // Zeile.Strings[1] := 'Down'+inttostr(key);
 end; // if FBearbeitenerlaubt
end;

procedure TSHControl.setStil(stil: TZeichenStil);
begin
   case Stil of
   ZNormal: begin
              canvas.Font.Style := [];
              canvas.Font.Color := clBlack;
            end;
   ZString: begin
              canvas.Font.Style := [];
              canvas.Font.Color := $FF0000;
            end;
   ZKeyword: begin
              canvas.Font.Style := [fsBold];
              canvas.Font.Color := clBlack;
             end;
   ZComment: begin
               canvas.Font.Style := [fsItalic];
               canvas.Font.Color := $00C000;
             end;
   ZZahl:    begin
                canvas.font.Style := [];
                canvas.Font.Color := $FF0000;
             end;
   end; // case
end;


procedure TSHControl.TastaturMarkierung;
begin
      MarkierungbisZ := cTextZeile; MarkierungbisS := cTextSpalte;
      paintabzeile(0);
end;

procedure TSHControl.testmaximaleStringlaenge(z: integer);
begin
      SBHor.Position := SpalteLinksOben;
   if length(zeile.Strings[z]) > MaximaleStringLaenge then
     begin
      MaximaleStringLaenge := length(zeile.strings[z]);
      if MaximaleStringLaenge > Spaltenanz then
      SBHor.Max := MaximaleStringLaenge - 1;
     end;
end;

procedure TSHControl.testmaximaleStringLaengeKomplett;
Var i, m: integer;
begin
  SBHor.Position := SpalteLinksOben;
  m := 0;
  try
    EntercriticalSection(CriticalSectionProgrammZeilen);
    for i := 0 to zeile.Count -1 do
       if length(zeile.Strings[i]) > m then
         begin
          m := length(zeile.strings[i]);
         end;
    if m <> MaximaleStringLaenge then
    begin
       MaximaleStringLaenge := m;
       if m > Spaltenanz then
       SBHor.Max := m - 1;
    end;
  finally
    LeaveCriticalSection(CriticalSectionProgrammZeilen);
  end;
end;

procedure TSHControl.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  Inherited;
  Message.Result := Message.Result or DLGC_WANTARROWS;
  Message.Result := Message.Result or DLGC_WANTTAB;
end;

function TSHControl.getZeile(pos: Integer): Integer;
Var i,n: integer;
begin
  n := 0; i := 0;
  while ( i <= zeile.Count -1) and (pos > n) do
  begin
     n := n + length(zeile.Strings[i]) + 1;
     i := i + 1;
  end;
  getzeile := i-1;
end;

procedure TSHControl.clear;
var i: integer;
begin
  if FBearbeitenerlaubt then
  begin
    try
      EntercriticalSection(CriticalSectionProgrammZeilen);

        // Formatierungsinformationen entsorgen!
        for i := 0 to Zeile.Count -1 do
           if Zeile.Objects[i] <> nil then
             begin
             TZeilenInformation(Zeile.Objects[i]).Free;
             Zeile.Objects[i] := nil;
             end;

     Zeile.Clear;
     ZeileLinksOben := 0; SpalteLinksOben := 0;
     cTextZeile := 0; cTextSpalte := 0;
    finally
      LeaveCriticalSection(CriticalSectionProgrammZeilen);
    end;
     Scrollbartest(false);
     paint;
  end;
end;

function TSHControl.getSpalte(pos: Integer): Integer;
Var i: integer;
begin
  i := 0;
  while ( i <= zeile.Count-1) and (pos > length(zeile.strings[i])+1) do
      begin
      pos := pos - length(zeile.Strings[i])-1;
      inc(i);
      end;
  getSpalte := pos;
end;

procedure TSHControl.clearColor;
Var i: integer;
    zi: TZeilenInformation;
begin
  try
    EntercriticalSection(CriticalSectionProgrammZeilen);
    for i := 0 to zeile.Count -1 do
    begin
       zi := TZeilenInformation(zeile.Objects[i]);
       if zi <> nil then
       zi.Hintergrundfarbe := clwhite;
    end;
  finally
    LeaveCriticalSection(CriticalSectionProgrammZeilen);
  end;
    FormatAbZeile(0);
end;

procedure TSHControl.PositionSichtbar(z, s: integer);
Var cz,cs: Integer;
    ZLiObAlt, SpLiObAlt: Integer;
begin
   cTextZeileAlt := cTextZeile; cTextSpalteAlt := cTextSpalte;
   ZLiObAlt := ZeileLinksOben; SpLiObAlt := SpalteLinksOben;
   if z <= zeile.Count -1 then
   begin
     if s > length(zeile.Strings[z])  then s := length(zeile.Strings[z]);
     cz := z - Zeilelinksoben; cs := s - spaltelinksoben;
     EnableCursor(false);
     if cz > Zeilenanz - 1 - 3 then
     begin
        Zeilelinksoben := zeilelinksoben + (cz - (Zeilenanz-1)) + 3;
        if Zeilelinksoben > zeile.Count -1 -Zeilenanz +1 then
           Zeilelinksoben := zeile.count -1 - Zeilenanz+1;
        if Zeilelinksoben < 0 then Zeilelinksoben := 0;
     end else
     if cz < 3 then
     begin
        Zeilelinksoben := zeilelinksoben + cz - 3; // cz < 0!
        if Zeilelinksoben < 0 then Zeilelinksoben := 0;
     end;
     if cs > Spaltenanz then
     begin
        Spaltelinksoben := Spaltelinksoben + (cs - (Spaltenanz));
     end else
     if cs < 0 then
     begin
        Spaltelinksoben := SpalteLinksOben + cs; // cs < 0!
     end;
     if (ZLiObAlt <> ZeileLinksOben) or (SpLiObAlt <> SpalteLinksOben) then
        begin
          if SBHor.Visible then SBHor.Position := SpalteLinksOben;
          if SBVert.Visible then SBVert.Position := ZeileLinksOben;
          paint;
        end;
     enablecursor(true);
   end else
   if Zeile.Count = 0 then
   begin
      Zeile.Add(''); FormatZeile(0);
      cTextZeile := 0; cTextSpalte := 0;
      ZeileLinksOben := 0; spalteLinksOben := 0;
      Paint;
   end;
end;

procedure TSHControl.mScrollbarEnter(sender: TObject);
begin
   setFocus;
end;

function TSHControl.openfile(name: string): string;
var ueberschreibenok: boolean;
    ersteZeile: string;
begin
 ersteZeile := '';
 if FBearbeitenerlaubt then
 begin
   ueberschreibenok := false;
   if modified then
   begin
      if MessageDlg('Soll das aktuelle Programm verworfen werden?',mtWarning,mbOKCancel,0)
            = mrOK then ueberschreibenok := true;
   end else ueberschreibenok := true;
   if ueberschreibenok then
   begin
      clear;
      try
        EntercriticalSection(CriticalSectionProgrammZeilen);
        zeile.LoadFromFile(name);
       finally
        LeaveCriticalSection(CriticalSectionProgrammZeilen);
       end;
       modified := false;
       undo.reset;
       if zeile.Count >= 1 then
       begin
          ersteZeile := zeile.strings[0];
          zeile.Delete(0);
       end
          else ersteZeile := '';
       SetCursorText(0,0);
       MarkierungvonZ := 17000; MarkierungbisZ := 17000;
       MarkierungvonS := 0; MarkierungbisS := 0;
       clearColor;
       testmaximaleStringLaengeKomplett;
       Scrollbartest(false);
       paint;
       checkSyntax;
   end;
 end;
 openfile := ersteZeile;
end;

procedure TSHControl.savefile(name, ersteZeile: string);
begin
   Zeile.Insert(0,ersteZeile);
   Zeile.SaveToFile(name);
   Zeile.Delete(0);
   modified := false;
end;

procedure TSHControl.SetBearbeitenerlaubt(const Value: Boolean);
begin
  EnableCursor(Value);
  Cursorerlaubt := Value;
  FBearbeitenerlaubt := Value;
  if Value then
     Hintergrundfarbe := clWhite
  else
     Hintergrundfarbe := $ffe8e8;
end;

procedure TSHControl.checkSyntax;
begin
  TSyntaxcheck(SyntaxCheck).CheckIstNoetig;
end;

procedure TSHControl.CodeCompleteClose;
begin
   FCodeComplete.Hide;
   CodeCompleteIsOpen := false;
end;

procedure TSHControl.CodeCompleteOpen;
Var x,y: integer;
    p: TPoint;
begin
   if FCodeComplete.ListBox.Count > 0 then
   begin
     x := CodeCompleteSpalte *(zBreite + Spaltenabstand) + RandLinks + 1;
     y := (cZeile+1) * (zHoehe + Zeilenabstand) + RandOben + 1;
     p.x := x; p.y := y;
     p := ClientToScreen(p);
     FCodeComplete.Left := p.x; FCodeComplete.Top := p.y;
     FCodeComplete.Show;
     CodeCompleteIsOpen := true;
     SetFocus;
   end else CodeCompleteIsOpen := false;
end;

procedure TSHControl.StringInsert(st: String);
Var stanfang, stende: String;
    z,s,pos: Integer;
    c: char;
begin
  try
  EntercriticalSection(CriticalSectionProgrammZeilen);
     z := cTextZeile; s := cTextSpalte;
     if z > Zeile.Count -1 then Zeile.Insert(z,'');
     stanfang := copy(zeile.Strings[z],1,s);
     stende := copy(zeile.Strings[z],s+1,length(zeile.Strings[z])-s);
     zeile.Strings[z] := stanfang;
     for pos := 1 to length(st) do
     begin
        c := st[pos];
        case ord(c) of
        13 : begin
                z := z + 1;
                zeile.Insert(z,'');
             end;
        10: begin end;
        12: zeile.Strings[z] := zeile.Strings[z] + '   '; // tab
        else zeile.Strings[z] := zeile.Strings[z] + c;
        end; // case
     end;
     s := length(zeile.Strings[z]);
     zeile.Strings[z] := zeile.Strings[z] + stende;
  finally
  LeaveCriticalSection(CriticalSectionProgrammZeilen);
  end;
     FormatintelligentZeilen(cTextZeile, z);
     SetCursorText(z,s);
     testmaximaleStringLaengeKomplett;
end;

procedure TSHControl.CodeCompleteAktualisieren;
Var st: String;
    alterTeilstring: string;
begin
  if CodeCompleteIsOpen then
  begin
    alterTeilstring := FCodeComplete.TeilString;
    if CodecompleteSpalte - 1 > cTextSpalte then CodeCompleteClose
    else begin
      try
        EntercriticalSection(CriticalSectionProgrammZeilen);
        st := copy(zeile.Strings[cTextZeile],CodeCompleteSpalte,cTextSpalte - CodeCompleteSpalte+1);
      finally
        LeaveCriticalSection(CriticalSectionProgrammZeilen);
      end;
      if (length(st) >= 1) and (st[length(st)] = ' ') then CodeCompleteClose
      else
       begin
         if alterTeilstring <> st then
         begin
            FCodeComplete.TeilString := st;
            if not FCodeComplete.ListBoxFuellen then CodecompleteClose;
         end;
       end;
    end;
  end;
end;

procedure TSHControl.FormatIntelligentZeilen(zvon, zbis: integer);
Var i: integer;
    AlteEinruecktiefe: integer;
    AlterKommentarStatus: boolean;
    zi: TZeilenInformation;
    formatwarnoetig: boolean;
begin
   try
   EntercriticalSection(CriticalSectionProgrammZeilen);
   i := zvon; formatwarnoetig := false;
   if zbis > Zeile.Count -1 then zbis := Zeile.Count -1;
   while (i <= zbis) or (formatwarnoetig and (i <= Zeile.count -1) ) do
   begin
     formatwarnoetig := false;
     zi := TZeilenInformation(Zeile.Objects[i]);
     if zi <> nil then
     begin
        AlteEinruecktiefe := zi.Einruecken;
        AlterKommentarStatus := zi.GeschweifteKlammeroffen;
        formatzeile(i);
        zi := TZeilenInformation(Zeile.Objects[i]);
        if (AlteEinruecktiefe <> zi.Einruecken) or (AlterKommentarStatus <> zi.GeschweifteKlammeroffen) then
         begin
            formatwarnoetig := true;
         end;
     end else
     begin
        FormatZeile(i);
        formatwarnoetig := true;
     end;
     inc(i);
   end;
   finally
   LeaveCriticalSection(CriticalSectionProgrammZeilen);
   end;
end;


function TSHControl.getEinruecken(z: Integer): Integer;
Var zi: TZeilenInformation;
    einruecken:integer;
begin
  try
    EntercriticalSection(CriticalSectionProgrammZeilen);
    if (z < 0) or (z > zeile.Count - 1) then einruecken := 0
    else
    begin
      if Zeile.Objects[z] = nil then FormatIntelligentZeilen(z,z);
      zi := TZeilenInformation(Zeile.Objects[z]);
      einruecken := zi.DieseEinruecken;
    end;
  finally
    LeaveCriticalSection(CriticalSectionProgrammZeilen);
  end;
   getEinruecken := einruecken;
end;

function TSHControl.ConvertToRTF(s, fs: String): string;
var rtf: string;
    i: integer;
    c: char;
    zs: TZeichenStil;
begin
   LetzterStil := ZNormal;
   rtf := '{\rtf1\ansi\ansicpg1252\deff0\deflang1031{\fonttbl{\f0\fmodern\fprq1\fcharset0 Courier New;}{\f1\fnil\fcharset0 Times New Roman;}}';
   rtf := rtf + '{\colortbl ;\red0\green0\blue255;\red0\green196\blue0;}';
   rtf := rtf + '\viewkind4\uc1\pard\f0\fs20 ';

   for i := 1 to length(s) do
   begin
      c := s[i]; zs := TZeichenStil(ord(fs[i]));
      if c = chr(13) then
      begin
         rtf := rtf + '\par'#10#13;
      end else
      if c <> chr(10) then
      begin
         rtf := rtf + setStilrtf(zs);
         case c of
         '': rtf := rtf + '\''e4';
         '': rtf := rtf + '\''f6';
         '': rtf := rtf + '\''fc';
         '': rtf := rtf + '\''df';
         '': rtf := rtf + '\''c4';
         '': rtf := rtf + '\''d6';
         '': rtf := rtf + '\''dc';
         '': rtf := rtf + '\''80';
         else rtf := rtf + c;
         end; // case
      end;
   end;
   rtf := rtf + '}';
   ConvertToRtf := rtf;
end;

function TSHControl.setStilRtf(stil: TZeichenStil):string;
var rtfstring: string;
begin
   rtfstring := '';
   if LetzterStil <> stil then
   begin
     case LetzterStil of
     ZNormal: begin
              end;
     ZString: begin
                rtfstring := rtfstring + '\cf0'; // blau aus
//                canvas.Font.Style := [];
//                canvas.Font.Color := $FF0000;
              end;
     ZKeyword: begin
                rtfstring := rtfstring + '\b0'; // Fett aus
//                canvas.Font.Style := [fsBold];
//                canvas.Font.Color := clBlack;
               end;
     ZComment: begin
                rtfstring := rtfstring + '\i0\cf0'; // italic aus, lime aus
//                 canvas.Font.Style := [fsItalic];
//                 canvas.Font.Color := clLime;
               end;
     ZZahl:    begin
                rtfstring := rtfstring + '\cf0'; // blau aus
//                  canvas.font.Style := [];
//                  canvas.Font.Color := $FF0000;
               end;
     end; // case

     case Stil of
     ZNormal: begin
              end;
     ZString: begin
                rtfstring := rtfstring + '\cf1'; // blau ein
//                canvas.Font.Style := [];
//                canvas.Font.Color := $FF0000;
              end;
     ZKeyword: begin
                rtfstring := rtfstring + '\b'; // Fett ein
//                canvas.Font.Style := [fsBold];
//                canvas.Font.Color := clBlack;
               end;
     ZComment: begin
                rtfstring := rtfstring + '\i\cf2'; // italic ein, lime ein
//                 canvas.Font.Style := [fsItalic];
//                 canvas.Font.Color := clLime;
               end;
     ZZahl:    begin
                rtfstring := rtfstring + '\cf1'; // blau ein
//                  canvas.font.Style := [];
//                  canvas.Font.Color := $FF0000;
               end;
     end; // case
   rtfString := rtfString + ' ';
   letzterStil := Stil;
   end; // if letzterStil <> Stil
   setStilRtf := rtfString;
end;

procedure TSHControl.print(NurMarkierung, Zeilennummern: Boolean);
Var ZeichenProZeile, ZeilenProBlatt, Zeilenabstand, Zeichenhoehe, Zeichenbreite: integer;
    Randoben, Randunten, Randlinks, Randrechts: integer;
    Nummerierungsbreite: integer;
    i,j: integer;
    ZNdigits: integer; // Hchste Anzahl von Digits der Zeilennummer
    BlattZeile, TeilZeilen: integer;
    x,y: integer;
    zstr,fstr: string;
    mzv,mzb,msv,msb: integer;
    markierungein: boolean;

   procedure lineout(Nummersetzen: Boolean; line, fline: string; nr: integer);
   var znr: string;
       iu: integer;
   begin
      y := BlattZeile * Zeichenhoehe + RandOben;
      x := RandLinks;
      if Nummersetzen and Zeilennummern then
      begin
         printer.Canvas.Font.Color := clblack;
         printer.Canvas.Font.Style := [];
         znr := inttostr(nr);
         for iu := length(znr) to ZNdigits -1 do znr := ' ' + znr;
         znr := znr + ':';
         printer.Canvas.TextOut(x,y,znr);
      end;
      x := RandLinks + Nummerierungsbreite;
      for iu := 1 to length(line) do
      begin
         setPrintStil(TZeichenStil(ord(fline[iu])));
         printer.Canvas.TextOut(x,y,line[iu]);
         x := x + Zeichenbreite;
      end;
   end;

begin
  try
  EntercriticalSection(CriticalSectionProgrammZeilen);

  if NurMarkierung then
  begin
    mzv := MarkierungvonZ; mzb := MarkierungbisZ;
    msv := Markierungvons; msb := Markierungbiss;
    if (mzv <> mzb) or (msv <> msb) then markierungein := true
        else markierungein := false;
  end else
  begin
     mzv := 0; mzb := zeile.Count - 1;
     msv := 1; msb := length(zeile.Strings[zeile.count -1]);
     markierungein := false;
  end;

  if Markierungein then
  begin
    msv := msv + 1;
    if msv > length(Zeile.Strings[mzv]) then msv := length(Zeile.Strings[mzv]);
    if MarkierungvonZ > MarkierungbisZ then
    begin
       mzv := MarkierungbisZ; mzb := MarkierungvonZ;
       msv := MarkierungbisS; msb := MarkierungvonS;
    end else
    if (MarkierungvonZ = MarkierungbisZ) and (MarkierungvonS > MarkierungbisS) then
    begin
       msv := MarkierungbisS; msb := MarkierungvonS;
    end;
  end;


  if not (nurmarkierung and (not markierungein)) then
  begin
      Randoben := 50; Randunten := 50; Randlinks := 50; Randrechts := 50;

      printer.canvas.font.Name := 'Courier New';
      printer.canvas.font.Size := 10;
      ZeichenHoehe := printer.Canvas.TextHeight('H|gj');
      ZeichenBreite := printer.Canvas.TextWidth('M');
      Zeilenabstand := 0;
      if Zeile.Count < 10 then ZNdigits := 1
        else if Zeile.Count < 100 then ZNdigits := 2
          else if Zeile.Count < 1000 then ZNdigits := 3
            else ZNdigits := 4;
      Nummerierungsbreite := (ZNdigits+2) * zeichenBreite;
      if not Zeilennummern then Nummerierungsbreite := 0;
      ZeilenProBlatt := trunc((printer.PageHeight - Randunten - Randoben)/(Zeichenhoehe + Zeilenabstand));
      ZeichenProZeile := trunc((printer.PageWidth - Randlinks - RandRechts - Nummerierungsbreite)/Zeichenbreite );

      BlattZeile := 0;
      printer.BeginDoc;
      for i := mzv to mzb do
      begin
         zstr := zeile.Strings[i]; fstr := TZeilenInformation(Zeile.Objects[i]).FormatString;
         if i = mzv then
         begin
            zstr := copy(zstr,msv,length(zstr) - msv + 1);
            fstr := copy(fstr,msv,length(fstr) - msv + 1);
         end else
         if i = mzb then
         begin
            zstr := copy(zstr,1,msb);
            fstr := copy(fstr,1,msb);
         end;

         TeilZeilen := length(zstr) div ZeichenproZeile + 1;
         for j := 1 to TeilZeilen do
         begin
            lineout((j=1) or (Blattzeile = 0),copy(zstr,(j-1)*ZeichenproZeile +1,ZeichenproZeile),
                        copy(fstr,(j-1)*ZeichenproZeile + 1,Zeichenprozeile),i+1 );
            inc(BlattZeile);
            if BlattZeile > ZeilenProBlatt - 1 then
            begin
               BlattZeile := 0;
               printer.NewPage;
            end;
         end;
      end;
  printer.EndDoc;

  end; // Nurmarkierung aber keine Markierung da

  finally LeavecriticalSection(CriticalSectionProgrammZeilen);
  end; // try .. finally

end;

procedure TSHControl.setPrintStil(stil: TZeichenStil);
begin
   case Stil of
   ZNormal: begin
              printer.canvas.Font.Style := [];
              printer.canvas.Font.Color := clBlack;
            end;
   ZString: begin
              printer.canvas.Font.Style := [];
              printer.canvas.Font.Color := $FF0000;
            end;
   ZKeyword: begin
              printer.canvas.Font.Style := [fsBold];
              printer.canvas.Font.Color := clBlack;
             end;
   ZComment: begin
               printer.canvas.Font.Style := [fsItalic];
               printer.canvas.Font.Color := clLime;
             end;
   ZZahl:    begin
                printer.canvas.font.Style := [];
                printer.canvas.Font.Color := $FF0000;
             end;
   end; // case
end;

function TSHControl.Markierungein: Boolean;
var m: boolean;
begin
    if (MarkierungvonZ <> MarkierungbisZ) or (MarkierungvonS <> MarkierungbisS) then m := true
        else m := false;
   Markierungein := m;
end;

procedure TSHControl.CodeCompleteTesten;
var st: string;
begin
    try
      EntercriticalSection(CriticalSectionProgrammZeilen);
      // Zur Sicherheit zunchst die Abfrage
      if (cTextZeile <= zeile.Count - 1) and (cTextZeile >= 0) then
         st := zeile.Strings[cTextZeile] else st := '';
    finally
      LeaveCriticalSection(CriticalSectionProgrammZeilen);
    end;
  // Wenn man rechts vom Punkt ist und dann den Cursor nach links
  // ber den Punkt hinwegbewegt, muss das Codecompletefenster geschlossen werden.
  if (cTextSpalte > 0 ) and (cTextSpalte <= length(st)) then
     if st[cTextSpalte] = '.' then CodeCompleteClose;
  if CodeCompleteIsOpen then CodeCompleteAktualisieren
    else
    begin
      FCodeComplete.init(TSyntaxCheck(Syntaxcheck),self);
      CodeCompleteSpalte := FCodeComplete.AnalyzeZeile(st,cTextSpalte);
      if CodeCompleteSpalte >= 0 then
         CodeCompleteOpen;
    end;
end;


procedure TSHControl.Rueckgaengig;
begin
    if Bearbeitenerlaubt then
    try
       EnterCriticalSection(CriticalSectionProgrammZeilen);
       if undo.Rueckgaengig(zeile,cTextZeile,cTextSpalte) then
       begin
         CodeCompleteClose;
         NurZeichenEingabe := false;
         SetCursorText(undo.GetZeile,undo.GetSpalte);
         FormatAbZeile(0);
         checkSyntax;
       end;
    finally
       LeaveCriticalSection(CriticalSectionProgrammZeilen);
    end;
    paint;
end;

procedure TSHControl.mDBlClick(Sender: TObject);
Var z,i,von,bis: Integer;
    chBezeichner: Set of Char;
    s: String;
begin
   z := cTextZeile;
   i := cTextSpalte + 1;
   try
     EnterCriticalSection(CriticalSectionProgrammZeilen);
     s := zeile.Strings[z];
   finally
     LeaveCriticalSection(CriticalSectionProgrammZeilen);
   end;
   chBezeichner := ['a'..'z','A'..'Z','','','','','','','','0'..'9'];
   if (i >= 1) and (i <= length(s)) and (s[i] in chBezeichner) then
   begin
      von := i;
      while (von >= 1) and (von <= length(s)) and (s[von] in chBezeichner) do
         dec(von);
      inc(von);
      bis := i;
      while (bis >= 1) and (bis <= length(s)) and (s[bis] in chBezeichner) do
         inc(bis);
      dec(bis);
      MarkierungvonZ := z;
      MarkierungbisZ := z;
      MarkierungvonS := von - 1;
      MarkierungbisS := bis;
      paintabzeile(0);
      WarGradeDoppelklick := true;
   end;
end;

function TSHControl.UndoAnzahl: Integer;
begin
   UndoAnzahl := Undo.UndoAnzahl;
end;

procedure TSHControl.Redo;
begin
    if Bearbeitenerlaubt then
    try
       EnterCriticalSection(CriticalSectionProgrammZeilen);
       if undo.Redo(zeile,cTextZeile,cTextSpalte) then
       begin
         CodeCompleteClose;
         NurZeichenEingabe := false;
         SetCursorText(undo.GetZeile,undo.GetSpalte);
         FormatAbZeile(0);
         checkSyntax;
       end;
    finally
       LeaveCriticalSection(CriticalSectionProgrammZeilen);
    end;
    paint;
end;

function TSHControl.RedoAnzahl: Integer;
begin
   RedoAnzahl := Undo.RedoAnzahl;
end;

procedure TSHControl.SetCharacterSize(const Value: integer);
begin
  if value >= 10 then
  FCharacterSize := Value;
  mResize(self);
end;

end.
