unit USyntaxcheck;

interface
uses  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, UScanner, UFehler, UVariablen,
  UKlassen, UDaten, UConstants, USHControl;

const VARDEKLMAX = 100;

type
TVariablenTyp = record
          vt: TVarType;
          ci: Integer;
          end;
TVarDeklArray = array[0..VARDEKLMAX] of integer;

TSyntaxcheckThread = class;

TSyntaxcheck = class(TObject)
  private
    SyntaxCheckThread: TSyntaxCheckThread;
    shc: TSHControl;
  public
    vs, vsneu: TVarSpace;
    FensterAutomatisch: Boolean;
    //1 vdarray: array[0..1] of TVardeklArray;
    //1 vdcleanNummer: integer;

    Klassenfabrik: TKlassenFabrik;
    Noetig: Boolean;
    ThreadAnzahl: Integer;

    procedure CheckIstNoetig;
    procedure vsTauschen;
    procedure AnalysiereObFensterAutomatisch;

    constructor Create(shc: TSHcontrol);
    destructor Destroy; override;
end;

TSyntaxcheckThread = class(TThread)
  private
  sc: TScanner;
  vs: TVarSpace;
  VarTypBoolean: TVariablenTyp;
  VarTypInteger: TVariablenTyp;
//  Fehlererledigt: Boolean;
  ArrayDeklCounter: integer;

  public
  SyntaxCheck: TSyntaxCheck;

  Fehler: Boolean;
  Fehlercode: TFehler;
  Verschachtelungstiefe: integer;
  FuerObjekt: TObjekt;


  SicherKeineVariablendeklaration: boolean;

  procedure Execute; override;
  constructor Create(CreateSuspended: Boolean;
              SyntaxCheck: TSyntaxCheck);
  destructor destroy; override;
    // Parser
    //
   procedure error(s: String);
   procedure Fehlerveroeffentlichen;
   procedure FehlerAnzeigeAktualisieren; // wird synchronized aufgerufen

   procedure findeMethoden;
   procedure Methodenparameter(m: TMethode); // Liest die Parameter ein

   procedure Block; // Parst einen Block
   procedure Wiederhole;
   procedure Solange;
   procedure wenn;
   procedure variablendeklaration;
   procedure vdeklAttributMethode(pos:integer);
   function methodenaufruf(m: TMethode): TVariablenTyp;
   procedure zuweisung(vtyp: TVariablentyp);
   // AttributMethode Untersucht ganze Variablen, z.B. r1.Pinsel.farbe
   // Wenn es sich um ein Attribut handelt, wird das entsprechende TAttribut-
   // Objekt zurckgegeben. Handelt es sich um eine Methode, so wird sie aufgerufen.
   // Handelt es sich um eine Methode mit Rckgabewert, so wird sie aufgerufen und der Rckgabewert
   // auf den Stack gelegt.
   function AttributMethode(linkswertErwartet: Boolean; Var VariableistAttribut: Boolean): TVariablentyp;
   procedure Fuer;

   // Die folgenden Prozeduren hinterlassen auf dem Stack das
   // Ergebnis.
   procedure Term(vtGewuenscht: TVariablenTyp);

   procedure Methode;

   function AndOr: TVariablenTyp;
   function Vergleich: TVariablenTyp;
   function PlusMinus: TVariablenTyp;
   function MalGeteilt:TVariablenTyp;
   function Atom: TVariablenTyp;
   function NotMinus: TVariablenTyp;
end;

implementation

uses UCriticalSections, UEinstellungen;

{ TSyntaxcheck }


procedure TSyntaxcheck.AnalysiereObFensterAutomatisch;
Var i: integer;
    v: TVariable;
    fensterdeklariert, figuristda: Boolean;
begin
   fensterdeklariert := false;
   figuristda := false;
   // Ein Fenster wird dann automatisch generiert, falls kein
   // Fenster deklariert wird und mindestens ein Nachkomme von
   // FIGUR da ist.
   for i := 0 to vs.Varlist.Count -1 do
   begin
      v := TVariable(vs.Varlist.Items[i]);
      if v.Wert.Typ = vtObjekt then
      begin
         if TObjekt(v.Wert.o).ci = 41 then fensterdeklariert := true;
         if TObjekt(v.Wert.o).ci mod 2 = 0 then figuristda := true;
      end;
   end;
   FensterAutomatisch := ( not fensterdeklariert) and figuristda;
end;

procedure TSyntaxcheck.CheckIstNoetig;
begin
   try
     EnterCriticalSection(CriticalSectionSyntaxCheck);
     Noetig := true;
     if ThreadAnzahl < 1 then
     begin
        inc(ThreadAnzahl);
        SyntaxCheckThread := TSyntaxcheckThread.Create(true,self);
        SyntaxCheckThread.Priority := tpNormal;
        SyntaxCheckThread.FreeOnTerminate := true;
        SyntaxCheckThread.Resume;
     end;
   finally
     LeaveCriticalSection(CriticalSectionSyntaxCheck);
   end;
end;

constructor TSyntaxcheck.Create(shc: TSHControl);
begin
  inherited create;
  noetig := false; 
  ThreadAnzahl := 0;
  Klassenfabrik := TKlassenFabrik.create;
  vs := nil;
  self.shc := shc;
  //1 vdcleanNummer := 0;
  //1 vdarray[0][0] := -1; vdarray[1][0] := -1; // Damit SHControl klar ist,
  // dass keine Variablenposition zu finden ist!
end;

destructor TSyntaxcheck.Destroy;
Var a: Integer;
begin
  repeat
     try
       EnterCriticalSection(CriticalSectionSyntaxCheck);
       a := ThreadAnzahl;
     finally
       LeaveCriticalSection(CriticalSectionSyntaxCheck);
     end;
  until a <= 0;
  DeleteCriticalSection(CriticalSectionSyntaxCheck);
  DeleteCriticalSection(CriticalSectionFehlerveroeffentlichen);
  if vs <> nil then
  begin
     vs.Free;
  end;
  if vsneu <> nil then
  begin
     vsneu.Free;
  end;
  Klassenfabrik.Free;

  inherited;
end;

procedure TSyntaxcheck.vsTauschen;
begin
   try
     EnterCriticalSection(CriticalSectionSyntaxVarSpace);
     if vs <> nil then
     begin
     vs.Free;
     end;
     vs := vsneu;
     vsneu := nil;

     AnalysiereObFensterAutomatisch;

     // Arrays fr die Variablendeklaration tauschen
     //1 vdCleannummer := 1-vdCleannummer;    // springt zwischen 0 und 1

   finally
     LeaveCriticalSection(CriticalSectionSyntaxVarSpace);
   end;
end;

{ TSyntaxcheckThread }

function TSyntaxcheckThread.AndOr: TVariablenTyp;
Var t: EToken;
    vtyp2, vtypErg : TVariablentyp;
begin
   if not Fehler then
   begin
     vtyperg := Vergleich; // Erstes Argument
     t := sc.TRead;
     while not Fehler and (t in [OAnd, OOr]) do
     begin
        if vtyperg.vt <> vtBoolean then error('Vor And/Or wird ein boolescher Wert erwartet.')
        else begin
          vtyp2 := Vergleich; // Zweites Argument
          if vtyp2.vt <> vtBoolean then error('Nach And/Or wird ein boolescher Wert erwartet.')
            else vtypErg.vt := vtBoolean;
        end; // (1. Operand)
     t := sc.TRead;
     end;  // while t in [OAnd, OOr]
     sc.Back;
   end;
   AndOr := vtypErg;
end;   // AndOr

function TSyntaxcheckThread.Atom: TVariablenTyp;
Var t: EToken;
    vtypErg: TVariablenTyp;
    s: String;
    dummy: Boolean;
begin
   if not Fehler then
   begin
     t := sc.TRead;
     case t of
     Otrue, Ofalse: vtypERg.vt := vtBoolean;
     OIntegerconst: vtypErg.vt := vtInteger;
     ORealconst: vtypErg.vt := vtDouble;
     OStringConst: vtypErg.vt := vtString;
     OKlammAuf: begin
                   vtypErg := AndOr;
                   t := sc.TRead;
                   if t <> OKlammZu then error (' ) erwartet.');
                end;
     OIdentifier: begin
                     sc.Back;
                     vtypErg := AttributMethode(false,dummy); // kein Linkswert erwartet!
                  end;
     OZahlenfehler: error (sc.Stringgelesen + ' ist keine zulssige Zahl.');
     else
     begin
        s := 'Bezeichner oder Funktionsaufruf erwartet.';
        if (sc.Stringgelesen <> '') and (sc.Stringgelesen <> ' ') then
           s := s + sc.Stringgelesen + ' macht hier keinen Sinn.';
        error(s);
     end;
     end; // case
   end;
   Atom :=vtypErg;
end;

function TSyntaxcheckThread.AttributMethode(
  linkswertErwartet: Boolean; Var VariableistAttribut: Boolean): TVariablentyp;
var v: TVariant;
    a: TAttribut;
    m: TMethode;
    t: EToken;
    name: String;
    vTyp: TVariablenTyp;
    o: TObjekt;
begin
   VariableistAttribut := false;
   vTyp.vt := vtKeiner; vtyp.ci := 0; m := nil; a := nil; o := nil;
   if not Fehler then
   begin
     t := sc.TRead; // Voraussetzung: Das ist ein OIdentifier!!!
     if t <> OIdentifier then error('Bezeichner erwartet.');

     // Zuerst nach Attributen/Methoden im Fuer-Objekt suchen
     if FuerObjekt <> nil then
     begin
        a := FuerObjekt.GetAttribut(sc.Text);
        if a <> nil then
        begin
          VariableistAttribut := true;
          vtyp.vt := a.Wert.Typ;
          if vtyp.vt = vtObjekt then
          begin
             vtyp.ci := a.Wert.o.ci;
             o := a.Wert.o;
          end;
        end else
        begin   // Suche nach Methode
           m := FuerObjekt.GetMethode(sc.Text);
           if m <> nil then
           begin
             vtyp := methodenaufruf(m);
             if vtyp.vt = vtObjekt then
             begin
                o := Syntaxcheck.Klassenfabrik.getKlasse(vtyp.ci);
             end;
           end;
        end;
     end;

     if (FuerObjekt = nil) or ( (m = nil) and (a=nil)) then
       begin
          // Gibt es eine Variable mit diesem Namen?
          v := vs.get(sc.Text);
          if v <> nil then
          begin
            if v.Typ = vtMethode then
            begin
               m := v.m;
               vtyp := methodenaufruf(m);
               if vtyp.vt = vtObjekt then
               begin
                  o := Syntaxcheck.Klassenfabrik.getKlasse(vtyp.ci);
               end;
            end
            else
            begin
              vtyp.vt := v.Typ;
              if v.Typ = vtObjekt then
                begin
                  vtyp.ci := v.o.ci;
                  o := v.o;
                end;
            end;
          end;
       end;

     if (vtyp.vt = vtKeiner) and (m = nil) then error ('Den Bezeichner '+sc.Text+' gibt es nicht.');

     if not Fehler then
     begin
       SicherKeineVariablendeklaration := true; // Den Bezeichner gibt's ja!
       name := sc.Text;

       if vTyp.vt = vtObjekt then
       begin
// Schleife
         t := sc.TRead;
         while (t = OPunkt) and (not Fehler) do
         begin
            m := nil;
            t := sc.TRead;
            if (vTyp.vt = vtObjekt) then
            begin
               if t <> OIdentifier then error('Nach dem Punkt wird der Name einer Eigenschaft/Methode erwartet.')
               else
               begin
                   a := o.GetAttribut(sc.Text);
                   if a = nil then
                   begin
                      m := o.GetMethode(sc.Text);
                      if m = nil then error(sc.text+ ' ist nicht der Name eines Attributs/einer Methode von ' + name)
                      else
                      begin
                         vtyp := methodenaufruf(m);
                         if vtyp.vt = vtObjekt then
                         begin
                            o := Syntaxcheck.Klassenfabrik.getKlasse(vtyp.ci);
                         end;
                      end;
                   end
                   else
                   begin // Attribut gefunden!
                      VariableistAttribut := true;
                      vtyp.vt := a.Wert.Typ;
                      if vtyp.vt = vtObjekt then
                      begin
                         vtyp.ci := a.Wert.o.ci;
                         o := a.Wert.o;
                      end;
                   end;
               end;
            end else error(name + ' hat keine Eigenschaften/Methoden');
         t := sc.TRead;
         end; // while (t =OPunkt) and (not Fehler)
       sc.Back;
// Schleifenende
       end; // if v.typ = vtobjekt
       if not Fehler then
       begin
          if not linkswertErwartet then
          begin  // Kein Linkswert erwartet => "Term"wert auf den Stack
             if (m <> nil) and (m.Rueckgabeparameter = nil) then error('Die Methode ' + m.Name + ' gibt nichts zurck.');
          end;
       end; // if not Fehler
     end; // Bezeichner bekannt
   end;
   AttributMethode := vtyp;
end;

procedure TSyntaxcheckThread.Block;
Var t: EToken;
    pos, Zeile, Spalte: integer;
begin
   sc.SkipSpace;
   pos := sc.getPos;
   t := sc.TRead;
   while (not Fehler) and (not Sc.EndOfText) and
      (t in [OIdentifier,OWiederhole,OSolange,OWenn, OFuer, OMethode]) do
   begin
     case t of
     OIdentifier: begin
                    vdeklAttributMethode(pos);
                  end;
     OWiederhole: wiederhole;
     OSolange: Solange;
     OWenn: Wenn;
     OFuer: Fuer;
     OMethode: Methode;
     else begin
            sc.Back;  // *wenn, *wiederhole usw. werden von den Methoden wenn, wiederhole, ... erledigt.
          end;
     end;  // case
     sc.SkipSpace;
     pos := sc.getPos; t := sc.TRead;
   end; // while
   if not Fehler then
   if ((verschachtelungstiefe = 0) and not (t in [OEOF,OEnde])) or
      (
         (Verschachtelungstiefe > 0)   and
          (not (t in [OSternwiederhole,OSternsolange,OSternwenn,OSonst, OSternFuer]))
       )then
      begin
        if t = OIdentifier then
        begin
           error('Der Bezeichner '+ sc.text + ' ist unbekannt.');
          // der Benutzer knnte eine Variablendeklaration begonnen haben!
           sc.getZeileSpalte(Zeile,Spalte);
           //1 SyntaxCheck.vdarray[1-Syntaxcheck.vdcleanNummer][ArrayDeklCounter] := Zeile;
           if ArrayDeklcounter < VARDEKLMAX then inc(ArrayDeklCounter);
        end
        else
          if t = OEOF then error('*wiederhole, *solange, *wenn oder *fr erwartet.')
            else error(sc.Text + ' ist hier nicht zulssig.');
      end;
   sc.Back;
end;

constructor TSyntaxcheckThread.Create(CreateSuspended: Boolean;
  SyntaxCheck: TSyntaxCheck);
begin
   inherited create(CreateSuspended);
//   sc := TScanner.Create; // wird jetzt von execute erledigt
   self.SyntaxCheck := SyntaxCheck;
   VarTypBoolean.vt := vtBoolean;
   VarTypInteger.vt := vtInteger;
end;

destructor TSyntaxcheckThread.destroy;
begin

  inherited;
end;

procedure TSyntaxcheckThread.error(s: String);
begin
   if (s <> '') and not Fehler then
   begin
      sc.back;
      if Fehlercode <> nil then Fehlercode.Free;
      synchronize(sc.hgetZeileSpalte);
      Fehlercode := TFehler.Create(sc.yZeile, sc.ySpalte,2,0,s);
      Fehler := true;
   end;
   if s = '' then
   begin
      Fehlercode.Free; Fehlercode := nil;
      Fehler := false;
   end;
end;

procedure TSyntaxcheckThread.Execute;
Var Noetig: Boolean;

begin
  inherited;
  try
    begin

      sc := TScanner.Create;

      repeat     // Wiederholen, solange SyntaxCheck.Noetig = true
        try
          EnterCriticalSection(CriticalSectionSyntaxCheck);
          SyntaxCheck.Noetig := false;
        finally
          LeaveCriticalSection(CriticalSectionSyntaxCheck);
        end;

        try
          EntercriticalSection(CriticalSectionProgrammZeilen);
          sc.init(SyntaxCheck.Shc);
        finally
          LeaveCriticalSection(CriticalSectionProgrammZeilen);
        end;

        vs := TVarSpace.create;

        // Ab hier wird die Syntax geprft!
        error(''); // Fehler zurcksetzen, evtl. alten TFehler lschen
        Verschachtelungstiefe := 0;
        FuerObjekt :=  nil;
        ArrayDeklCounter := 1; // erste Position in vdArrayAufbauen

        findemethoden;
        Block;
        //1 SyntaxCheck.vdarray[1-Syntaxcheck.vdcleanNummer][0] := ArrayDeklCounter;
        // Jetzt steht in vdarrayaufbauen[1] die erste nichtgenutzte Position drin
        SyntaxCheck.vsneu := vs;

        SyntaxCheck.vsTauschen;
        vs := nil;

          try
            EnterCriticalSection(CriticalSectionSyntaxCheck);
            Noetig := SyntaxCheck.Noetig;
          finally
            LeaveCriticalSection(CriticalSectionSyntaxCheck);
          end;
      until (not Noetig) or Terminated;

        if not Terminated then Fehlerveroeffentlichen;
    end;

  finally
    sc.free;
    try
      EnterCriticalSection(CriticalSectionSyntaxCheck);
      dec(SyntaxCheck.ThreadAnzahl);
    finally
      LeaveCriticalSection(CriticalSectionSyntaxCheck);
      Terminate;
    end;
  end;
end;

procedure TSyntaxcheckThread.FehlerAnzeigeAktualisieren;
begin
   FehlerVerwaltung.ListBoxAktualisieren;
end;

procedure TSyntaxcheckThread.Fehlerveroeffentlichen;
begin
   try
     EnterCriticalSection(CriticalSectionFehlerveroeffentlichen);
     FehlerVerwaltung.loescheFehler(2);
     if Fehler then FehlerVerwaltung.add(Fehlercode);

     Fehlercode := nil;  // Damit error einen gefahrlosen Lschversuch starten kann...
   finally
     LeaveCriticalSection(CriticalSectionFehlerveroeffentlichen);
   end;

   // Fehlererledigt := true;
   Synchronize(FehlerAnzeigeAktualisieren);
end;

procedure TSyntaxcheckThread.findeMethoden;
Var t: EToken;
    v: TVariant;
    pos: integer;
    m: TMethode;
    name: string;
begin
   m := nil;
   repeat
      t := sc.TRead;
      if t = OMethode then
      begin
         if sc.TRead = OIdentifier then
         begin
           pos := sc.getPos;
           name := sc.text;
           m := TMethode.create(pos);
           m.Name := name;
           v := TVariant.create(m);
           vs.add(name,v,false,false);
         end else error('Nach Methode wird der Name der Methode erwartet.');

         if not Fehler then
         begin
            t := sc.TRead;
            if t = OKlammAuf then // Parameter einlesen
            begin
               t := sc.tread;
               if t <> OKlammZu then // Folgt gleich eine ) ?
               begin       // Nein, also
                 sc.Back;  // Letztes Token zurckstellen, damit es nochmals eingelesen wird
                 repeat
                 Methodenparameter(m);
                 t := sc.TRead;
                 until t <> OStrichpunkt;
               end;
               if t <> OKlammzu then error(' ) erwartet');
               m.Einsprungadresse := sc.getPos;
            end;


         end;
         if not Fehler then
         begin
            repeat
               t := sc.TRead;
            until (t = OEnde) or (t = OEOF);
            if t = OEOF then error('Die Methode ' + name + ' muss mit Ende abgechlossen werden.');
         end;
      end;
   until (t = OEOF) or Fehler;
   sc.SetPos(1);
end;

procedure TSyntaxcheckThread.Fuer;
var vtyp: TVariablentyp;
    dummy: Boolean;
begin
   if FuerObjekt <> nil then error('Fr - Blcke knnen nicht geschachtelt werden!');
   if not Fehler then
   begin
      vtyp := AttributMethode(true, Dummy);
      if vtyp.vt <> vtObjekt then error('Nach fr wird ein Objekt erwartet.')
      else
      begin
        FuerObjekt := Syntaxcheck.Klassenfabrik.getKlasse(vtyp.ci);
        inc(Verschachtelungstiefe);
        Block;
        dec(Verschachtelungstiefe);
        if sc.TRead <> OSternFuer then error('*Fr erwartet');
        FuerObjekt := nil;
      end; // Bezeichner bekannt
   end; // if not Fehler
end;

function TSyntaxcheckThread.MalGeteilt: TVariablenTyp;
Var t: EToken;
    vtyp2, vtypErg : TVariablentyp;
begin
   if not Fehler then
   begin
     vTyperg := NotMinus; // Erstes Argument
     t := sc.TRead;
     while (not Fehler) and (t in [OMal, OGeteilt]) do
     begin
        if not (vtyperg.vt in [vtInteger, vtDouble]) then error('Vor *,/ wird ein Integer- oder Double-Wert erwartet.')
        else begin
          vtyp2 := Notminus; // Zweites Argument
          if not (vtyp2.vt in [vtInteger, vtDouble, vtString]) then error('Nach *,/ wird ein Integer- oder Double-Wert erwartet.')
             else begin
                if (vtypErg.vt = vtDouble) or (vtyp2.vt = vtDouble) then
                   vtypErg.vt := vtDouble else vtypErg.vt := vtInteger;
             end;
        end; // if Typ des 1. Operanden passt
     t := sc.TRead;
     end;  // if t in [OMal, ...]
     sc.Back;
   end;
   MalGeteilt := vTypErg;
end;   // MalGeteilt

procedure TSyntaxcheckThread.Methode;
Var m: TMethode;
    v: TVariant;
    i: integer;
    p: TParameter;
begin
   vs.NeuerKontext;
     sc.TRead;
     v := vs.get(sc.Text);
     if (v <> nil) then
     begin
        if v.Typ = vtMethode then
        begin
        m := v.m; sc.SetPos(m.Einsprungadresse);
        for i := 0 to m.parameter.Count -1 do
        begin
           p := TParameter(m.parameter.Items[i]);
           v := TVariant.Create;
           v.Typ := p.typ;
           if v.typ = vtObjekt then v.o := SyntaxCheck.Klassenfabrik.getKlasse(p.ci);
           vs.add(p.Name,v,false,true);
        end;
        if m.Rueckgabeparameter <> nil then
        begin
          v := TVariant.create;
          v.Typ := m.Rueckgabeparameter.typ;
          vs.add(m.Name,v,false,true);
        end;
        Block;
        end;
     end;
   vs.ClearKontext;
   if sc.TRead <> OEnde then error('Eine Methode wurde nicht mit Ende abgeschlossen');
end;

function TSyntaxcheckThread.methodenaufruf(m: TMethode): TVariablenTyp;
Var i: integer;
    vTyp,vTyp1 :TVariablenTyp;
    p:TParameter;
    dummy: Boolean;
begin
  if not Fehler then
  begin
    if sc.TRead <> OKlammauf then error ('( erwartet.') else
    if m.parameter.Count > 0 then
    begin
       begin
         i := 0;
         while ( i <= m.parameter.Count - 1) and not Fehler do
         begin
            p := TParameter(m.parameter.Items[i]);
            vtyp.vt := p.typ;
            vtyp.ci := p.ci;
            if (m.Typ = mtselbstgeschrieben) and p.Variablenparameter then
            begin
               vtyp1 := AttributMethode(true,dummy);
               if (vtyp1.vt <> vtyp.vt) or (vtyp1.ci <> vtyp.ci) then error('Der Typ des Parameters ' + p.Name + ' der Methode ' + m.Name + ' stimmt nicht.');
            end
            else
               begin
                 term(vtyp);
                 if Fehler and (Fehlercode.Text = 'Bezeichner oder Funktionsaufruf erwartet.') then
                   Fehlercode.Text := 'Parameter erwartet (' + p.Name + ').';
               end;
            if (i < m.parameter.Count -1 ) then
            begin
              if (sc.TRead <> OKomma) then error (', erwartet.');
            end;
         inc(i);
         end; // for i := 0 to m.parameter.count - 1
       end; // KLammerauf war da
    end;  // Parameter besorgen und ( erledigen !
    if (sc.TRead <> OKlammzu) then error(') erwartet');
    // Endlich: Methode aufrufen!
    if not Fehler then
    begin
      if m.Rueckgabeparameter <> nil then
      begin
         vtyp.vt := m.Rueckgabeparameter.typ;
         vtyp.ci := m.Rueckgabeparameter.ci;
      end else vtyp.vt := vtKeiner;
    end;
  end;
  methodenaufruf := vtyp;
end;

procedure TSyntaxcheckThread.Methodenparameter(m: TMethode);
Var t: EToken;
    sl: TStrings;
    VariablenParameter: Boolean;
    ci,i: integer;
    typ :TVarType;
begin
   begin
     sl := TStringList.Create;
     t := sc.TRead;
     if t = OVar then
     begin
        Variablenparameter := true; t := sc.TRead;
     end else Variablenparameter := false;
     if t = OIdentifier then
     begin
        while (t <> ODoppelpunkt) and  not Fehler do
        begin
           if  m.getparameter(sc.text) <> nil then error('Einen Parameter mit dem Namen ' + sc.text + ' gibt es schon.');
           for i := 0 to sl.Count -1 do
              if Myuppercase(sl.Strings[i]) = Myuppercase(sc.text) then error('Einen Parameter mit dem Namen ' + sc.text+ ' gibt es schon.');
           if not fehler then
           begin
             sl.Add(sc.Text);
             t := sc.TRead;
             if not (t in [OKomma, ODoppelpunkt]) then
                error('Komma oder Doppelpunkt erwartet.')
                else if t = OKomma then
                begin
                  t := sc.TRead;
                  if t <> OIdentifier then Error('Bezeichner erwartet');
                end;
           end;
        end; // While Bezeichner einlesen
        if not Fehler then
        begin
           t := sc.TRead;
           if not (t in [OIdentifier, OInteger, OReal, OChar, OBoolean, OString]) then
              error ('Parametertyp erwartet')
              else
              begin
                 if t = OIdentifier then
                 begin
                    if not VariablenParameter then error('Objekte sind nur als Variablenparameter, nicht als Werteparameter zulssig.')
                    else
                    if not Syntaxcheck.Klassenfabrik.gibtes(sc.Text) then error('Den Variablentyp/die Klasse '+sc.text+' gibt es nicht.')
                    else begin
                       for i := 0 to sl.Count -1 do
                       begin
                          ci := Syntaxcheck.klassenfabrik.getci(sc.Text);
                          m.addvarparameter(sl.Strings[i],vtObjekt,ci,Variablenparameter);
                       end;
                    end;
                 end // t = OIdentifier
                 else begin // t in [OInteger, ODouble, OChar, OBoolean]
                    typ := vtkeiner;
                    for i := 0 to sl.Count -1 do
                    begin
                       case t of
                       OInteger: Typ := vtInteger;
                       OReal: Typ := vtDouble;
                       OChar: Typ := vtchar;
                       OBoolean: Typ := vtBoolean;
                       OSTring: Typ := vtString;
                       end; // case
                       m.addvarparameter(sl.Strings[i],typ,0,VariablenParameter);
                    end;
                 end;  //Variablentyp zuweisen
              end;  // Variablentyp einlesen
        end; // Kein Fehler beim Einlesen der Bezeichner
     end else Error('Bezeichner erwartet.');
     sl.Free;
   end;
end;

function TSyntaxcheckThread.NotMinus: TVariablenTyp;
Var t: EToken;
    vtypErg: TVariablenTyp;
begin
   if not Fehler then
   begin
     t := sc.TRead;
     case t of
     OMinus:
       begin
          vtypErg := Atom;
          if not (vtypERg.vt in [vtInteger, vtDouble]) then
            error('Nach "-" wird ein Integer- oder Double-Termwert erwartet.');
       end;
     ONot:
       begin
          vtypErg := Atom;
          if vtypErg.vt <> vtBoolean then error('Nach not wird ein boolescher Wert erwartet.');
       end;
     else
        begin
           sc.Back;
           vtypErg := Atom;
        end;
     end; // case
   end;
NotMinus := vtypErg;
end;

function TSyntaxcheckThread.PlusMinus: TVariablenTyp;
Var t: EToken;
    vtyp2, vtypErg : TVariablentyp;
begin
   if not Fehler then
   begin
     vTyperg := MalGeteilt; // Erstes Argument
     t := sc.TRead;
     while not Fehler and (t in [OPlus, OMinus]) do
     begin
        if t = OPlus then
        begin
          if not (vtyperg.vt in [vtInteger, vtDouble, vtString]) then error('Vor + wird ein Integer-, Double- oder String- Wert erwartet.')
          else begin
            vtyp2 := MalGeteilt; // Zweites Argument
            if not (vtyp2.vt in [vtInteger, vtDouble, vtString]) then error('Nach + wird ein Integer-, Double- oder String- Wert erwartet.')
               else begin
                  if (vtypErg.vt = vtString) or (vtyp2.vt = vtString) then
                      vtypErg.vt := vtString else
                        if (vtypErg.vt = vtDouble) or (vtyp2.vt = vtDouble) then
                           vtypErg.vt := vtDouble else vtypErg.vt := vtInteger;
               end;
          end; // if Typ des 1. Operanden passt
        end else
        begin // t= OMinus
          if not (vtyperg.vt in [vtInteger, vtDouble]) then error('Vor + wird ein Integer-, Double-Wert erwartet.')
          else begin
            vtyp2 := MalGeteilt; // Zweites Argument
            if not (vtyp2.vt in [vtInteger, vtDouble, vtString]) then error('Nach + wird ein Integer-, Double-Wert erwartet.')
               else begin
                  if (vtypErg.vt = vtDouble) or (vtyp2.vt = vtDouble) then
                     vtypErg.vt := vtDouble else vtypErg.vt := vtInteger;
               end;
          end; // if Typ des 1. Operanden passt
        end;
        t := sc.TRead;
     end;  // if t in [OPlus, ...]
     sc.Back;
   end;
   PlusMinus := vtypErg;
end;   // PlusMinus

procedure TSyntaxcheckThread.Solange;
Var vt: TVariablentyp;
begin
  inc(Verschachtelungstiefe);
  vt.vt := vtBoolean;
  if not Fehler then
  begin
    Term(vt);
    if not Fehler then
    begin
       if sc.TRead <> OTue then error('tue erwartet.')
       else begin
          Block; dec(Verschachtelungstiefe);
          if not Fehler then
             if sc.TRead <> OSternSolange then error('*solange erwartet.');
       end;
    end;
  end;
end;


procedure TSyntaxcheckThread.Term(vtGewuenscht: TVariablenTyp);
Var TermTyp: TVariablenTyp;
begin
   if not Fehler then
   begin
     TermTyp := AndOr; // Term auswerten
     case vtGewuenscht.vt of
     vtString: if not (TermTyp.vt in [vtInteger, vtDouble, vtBoolean, vtString]) then
                error('Typ String erwartet.');
     vtDouble: if not (TermTyp.vt in [vtInteger, vtDouble] )then
                error('Typ Double erwartet');
     vtInteger: if TermTyp.vt <> vtinteger then error('Typ Integer erwartet');
     vtChar: if TermTyp.vt <> vtChar then error('Typ Char erwartet');
     vtObjekt: if (Termtyp.vt <> vtObjekt) or (TermTyp.ci mod vtGewuenscht.ci <> 0) then
               error('Klasse vom Index '+ inttostr(vtGewuenscht.ci) +' erwartet.');
     end; // case vtGewuenscht of
   end;
end;

procedure TSyntaxcheckThread.variablendeklaration;
Var t: EToken;
    sl: TStrings;
    o: TObjekt;
    i,Zeile,Spalte: Integer;
    v: TVariant;
begin
   if Verschachtelungstiefe > 0 then error('Variablendeklaration ist innerhalb von Wiederholungen (wiederhole/solange) nicht zulssig.')
   else
   begin
     sl := TStringList.Create;
     t := sc.TRead;
     sc.getZeileSpalte(Zeile,Spalte);
     //1 SyntaxCheck.vdarray[1-Syntaxcheck.vdcleanNummer][ArrayDeklCounter] := Zeile;
     if ArrayDeklcounter < VARDEKLMAX then inc(ArrayDeklCounter);
     if t = OIdentifier then
     begin
        while (t <> ODoppelpunkt) and  not Fehler do
        begin
           if vs.get(sc.text) <> nil then error('Eine Variable/ein Objekt mit dem Namen ' + sc.Text + ' gibt es schon.')
           else
           begin
             sl.Add(sc.Text);
             t := sc.TRead;
             if not (t in [OKomma, ODoppelpunkt]) then
                error('Komma oder Doppelpunkt erwartet.')
                else if t = OKomma then
                begin
                  t := sc.TRead;
                  if t <> OIdentifier then Error('Bezeichner erwartet');
                end;
           end;
        end; // While Bezeichner einlesen
        if not Fehler then
        begin
           t := sc.TRead;
           if not (t in [OIdentifier, OInteger, OReal, OChar, OBoolean,OString]) then
              error ('Variablentyp erwartet')
              else
              begin
                 if t = OIdentifier then
                 begin
                    if not SyntaxCheck.Klassenfabrik.gibtes(sc.Text) then error('Den Variablentyp/die Klasse '+sc.text+' gibt es nicht.')
                    else begin
                       for i := 0 to sl.Count -1 do
                       begin
                          o := SyntaxCheck.Klassenfabrik.getKlassebyName(sc.Text);
                          v := TVariant.Create;
                          v.o := o;
                          vs.add(sl.Strings[i],v,false,true);
                       end;
                    end;
                 end // t = OIdentifier
                 else begin // t in [OInteger, ODouble, OChar, OBoolean]
                    for i := 0 to sl.Count -1 do
                    begin
                       v := TVariant.Create;
                       case t of
                       OInteger: v.Typ := vtInteger;
                       OReal: v.Typ := vtDouble;
                       OChar: v.Typ := vtchar;
                       OBoolean: v.Typ := vtBoolean;
                       OSTring: v.Typ := vtString;
                       end; // case
                       vs.add(sl.Strings[i],v,false,false);
                    end;
                 end;  //Variablentyp zuweisen
              end;  // Variablentyp einlesen
        end; // Kein Fehler beim Einlesen der Bezeichner
     end else Error('Bezeichner erwartet.');
     sl.Free;
   end;
end;

procedure TSyntaxcheckThread.vdeklAttributMethode(pos: integer);
var t: EToken;
    vtyp: TVariablentyp;
    Zeile,Spalte: integer;
    VariableIstAttribut: Boolean;
begin
   t := sc.TRead;
   sc.SetPos(pos); // auf Position vor dem Bezeichner setzen!!
   if t in [OKomma,ODoppelpunkt] then variablendeklaration
      else begin
             SicherKeineVariablendeklaration := false;
             vtyp := AttributMethode(true,VariableIstAttribut);
             if (not Fehler) then
             begin  // ein Linkswert ist da => Zuweisung!
               if vtyp.vt <> vtKeiner then
               begin
                if VariableIstAttribut and FEinstellungen.KeineZuweisungZuAttributen then
                   error('Einem Attribut darf kein Wert zugewiesen werden!')
                else
                   zuweisung(vtyp);
               end;
             end
             else
             if not sicherkeineVariablendeklaration then
             begin
                 // Der Benutzer knnte eine Variablendeklaration begonnen haben!
                 sc.getZeileSpalte(Zeile,Spalte);
                 //1 SyntaxCheck.vdarray[1-Syntaxcheck.vdcleanNummer][ArrayDeklCounter] := Zeile;
                 if ArrayDeklcounter < VARDEKLMAX then inc(ArrayDeklCounter);
             end;
           end;
end;

function TSyntaxcheckThread.Vergleich: TVariablenTyp;
Var t: EToken;
    vtyp2, vtypErg : TVariablentyp;
begin
   if not Fehler then
   begin
     vTyperg := PlusMinus; // Erstes Argument
     t := sc.TRead;
     if t in [Okleiner, Ogroesser, OGleich,
                 OKleinerGleich, OGroessergleich, OUngleich] then
     begin
        if not (vtyperg.vt in [vtInteger, vtDouble]) then error('Vor <,>,<=,>=,<>,= wird ein Integer- oder Double-Wert erwartet.')
        else begin
          vtyp2 := PlusMinus; // Zweites Argument
          if not (vtyp2.vt in [vtInteger, vtDouble]) then error('Nach <,>,<=,>=,<>,= wird ein Integer- oder Double-Wert erwartet.')
             else vtypErg.vt := vtBoolean;
        end; // if Typ des 1. Operanden passt
     end  // if t in [OKleiner, ...]
     else sc.Back;
   end;
   Vergleich := vtypErg;
end;   // Vergleich

procedure TSyntaxcheckThread.wenn;
var t: EToken;
begin
   Term(VarTypBoolean);
   if not Fehler then
   begin
      if sc.TRead <> ODann then error('dann erwartet.')
      else begin
        inc(Verschachtelungstiefe);
        Block;
        dec(Verschachtelungstiefe);
        if not Fehler then
        begin
           t := sc.TRead;
           if t = OSonst then
           begin
              inc(Verschachtelungstiefe);
              Block; t := sc.TRead;
              dec(Verschachtelungstiefe);
           end;
           if t <> OSternWenn then error('*wenn erwartet.');
        end;
      end; // else
   end;
end;

procedure TSyntaxcheckThread.Wiederhole;
Var t: EToken;
begin
  if not Fehler then
   begin
     t := sc.TRead; inc(Verschachtelungstiefe);
     case t of
       OImmer: begin
                  Block;
                  dec(Verschachtelungstiefe);
                  if not Fehler then
                    if sc.TRead <> OSternwiederhole then
                     error('*wiederhole erwartet.');
               end;
       Osolange: begin
                  Term(VarTypBoolean);
                  Block;dec(Verschachtelungstiefe);
                  if not Fehler then
                     if sc.TRead <> OSternwiederhole then
                     error('*wiederhole erwartet.');
                 end;
       OIntegerConst: begin
                      if sc.TRead <> OMalWort then
                         error('mal erwartet.');
                      Block; dec(Verschachtelungstiefe);
                      if not Fehler then
                        if sc.TRead <> OSternwiederhole then
                         error('*wiederhole erwartet.');
                      end;
       OKlammAuf: begin
                      Term(VarTypInteger);
                      if not Fehler then
                        if sc.TRead <> OKlammzu then
                         error(') erwartet.');
                      if not Fehler then
                          if sc.TRead <> OMalWort then
                                 error('mal erwartet.');
                      if not Fehler then Block;
                      if not Fehler then
                        if sc.TRead <> OSternwiederhole then
                         error('*wiederhole erwartet.');
                      dec(Verschachtelungstiefe);
                  end;
       else begin
               sc.Back;
               Block;
               dec(Verschachtelungstiefe);
               if not Fehler then
               begin
                 if sc.TRead <> OSternwiederhole then
                        error('*wiederhole erwartet.');
                 if not (sc.TRead in [OBis, OSolange]) then
                        error('bis oder solange erwartet.')
                    else Term(VarTypBoolean);
               end;
            end;
     end; // case
   end; // if not Fehler
end;

procedure TSyntaxcheckThread.zuweisung(vtyp: TVariablentyp);
begin
   if not Fehler then
   begin
     if sc.TRead <> ODoppelpunktGleich then error (':= erwartet.')
     else begin
       Term(vTyp);
     end; // := war da
   end;
end;

end.
