package data;

/**
 * This class represents one job to change one date-attribute in one entitiy,
 * i.e. change date of birth (GEBURTSDATUM) in entity SVP_SCHUELER_STAMM
 * 
 * @author Martin Pabst, 2009
 * 
 */

public class DateChangeJob {

	/**
	 * SQL Indentifier of database entity
	 */
	private String entity;

	/**
	 * SQL Identifier of attribute to change
	 */
	private String attribute;

	/**
	 * Number of years to be added to date-attribute given as String, i.e. "1",
	 * "2", "-2"
	 */
	private String delta;

	/**
	 * true, if only svp_kalendertag should get corrected.
	 */
	private boolean onlyCorrectCalendar = false;
	
	/**
	 * true, if type of attribute is integer or short
	 */
	private boolean isIntegerAttribute = false;

	public void setOnlyCorrectCalendar(boolean onlyCorrectCalendar) {
		this.onlyCorrectCalendar = onlyCorrectCalendar;
	}

	public boolean isOnlyCorrectCalendar() {
		return onlyCorrectCalendar;
	}

	/**
	 * Constructor
	 * 
	 * @param entity
	 *            SQL Identifier of database entity
	 * @param attribute
	 *            SQL Identifier of attribute to change
	 * @param delta
	 *            Number of years to be added to date-attribute given as String,
	 *            i.e. "1", "2", "-2"
	 */
	public DateChangeJob(String entity, String attribute, String delta,
			boolean onlyCorrectCalendar) {
		super();
		
		if(entity != null && entity.length() > 4){
			if(entity.substring(0, 4).toLowerCase().equals("int:")){
				entity = entity.substring(4);
				isIntegerAttribute = true;
			}
		}
		
		this.entity = entity;
		this.attribute = attribute;
		this.delta = delta;
		this.onlyCorrectCalendar = onlyCorrectCalendar;
	}

	/**
	 * Getter for SQL-Entity
	 * 
	 * @return SQL Indentifier of database entity
	 */
	public String getEntity() {
		return entity;
	}

	public void setEntity(String entity) {
		this.entity = entity;
	}

	/**
	 * Getter for SQL-Attribute
	 * 
	 * @return SQL Identifier of attribute to change
	 */
	public String getAttribute() {
		return attribute;
	}

	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}

	/**
	 * Getter for delta
	 * 
	 * @return Number of years to be added to date-attribute given as String,
	 *         i.e. "1", "2", "-2"
	 */
	public String getDelta() {
		return delta;
	}

	/**
	 * Get delta as int-value
	 * 
	 * @return Number of years to be added to date-attribute given as Integer
	 */
	public int getDeltaInt() {
		String s = delta;

		if (s.startsWith("+")) {
			s = s.substring(1);
		}
		return Integer.parseInt(s);
	}

	/**
	 * Set delta
	 * 
	 * @param delta
	 *            Number of years to be added to date-attribute given as String,
	 *            i.e. "1", "2", "-2"
	 */
	public void setDelta(String delta) {
		this.delta = delta;
	}

	/**
	 * Return String representation of DateChangeJob-Object
	 * 
	 * @return String representation of DateChangeJob-Object
	 * 
	 */
	public String toString() {
		return "DateChangeJob: " + "entity: " + entity + "; attribute: "
				+ attribute + "; delta: " + delta;
	}

	public boolean isIntegerAttribute() {
		return isIntegerAttribute;
	}

	
	
	
}
