package data;

import java.util.ArrayList;

/**
 * List of DateChangeJob-objects
 * 
 * @author Martin Pabst, 2009
 * 
 */

public class DateChangeJobList extends ArrayList<DateChangeJob> {

	/**
	 * adds given DateChangeJob object
	 * 
	 * @param dateChangeJob
	 */
	@Override
	public boolean add(DateChangeJob dateChangeJob) {

		/**
		 * make sure there are not two identical jobs in this list
		 */

		for (DateChangeJob dcj : this) {
			if (dcj.getAttribute().compareToIgnoreCase(
					dateChangeJob.getAttribute()) == 0
					&& dcj.getEntity().compareToIgnoreCase(
							dateChangeJob.getEntity()) == 0) {
				return false; // identical job found => exit without adding job
			}
		}

		return super.add(dateChangeJob);

	}
}
