package database;

import java.awt.Color;

import logging.Log;
import logging.LogLevel;

import org.w3c.dom.Element;

import tools.xml.XMLReader;
import tools.xml.XMLWriter;

/**
 * Login info for database (derby or postgres)
 * 
 * @author Martin Pabst, 2010
 * 
 */

public class DatabaseLoginInfo {

	/**
	 * type ("derby" or "postgres")
	 */
	private String type = "";

	/**
	 * path to database in file system (used for derby database)
	 */
	private String path = "";

	/**
	 * ip of database server (used for postgres database)
	 */
	private String ip = "";

	/**
	 * port (used for postgres database)
	 */
	private String port = "";

	/**
	 * username
	 */
	private String username = "";

	/**
	 * password
	 */
	private String password = "";

	/**
	 * Name of database connection ("Derby" or "Postgres")
	 */
	private String name = "";

	public String getType() {
		return type;
	}

	public String getPath() {
		return path;
	}

	public String getIp() {
		return ip;
	}

	public String getPort() {
		return port;
	}

	public String getUsername() {
		return username;
	}

	public String getPassword() {
		return password;
	}

	public void readFromXML(Element element) {
		type = XMLReader.attributeNotNull(element, "type");
		username = XMLReader.attributeNotNull(element, "username");
		password = XMLReader.attributeNotNull(element, "password");
		name = XMLReader.attributeNotNull(element, "name");

		Log.outl(" ", LogLevel.info);
		Log.outlColor("Datenbankeinstellungen gefunden: ", LogLevel.info,
				Color.blue);
		Log.out("Typ: " + type + ", Benutzername: " + username
				+ ", Datenbankkennung: " + name, LogLevel.info);

		if (type.compareToIgnoreCase("derby") == 0) {
			path = XMLReader.attributeNotNull(element, "path");
			Log.outl(", path: " + path, LogLevel.info);
		} else if (type.compareToIgnoreCase("postgres") == 0) {
			ip = XMLReader.attributeNotNull(element, "ip");
			port = XMLReader.attributeNotNull(element, "port");
			Log.outl(", ip: " + ip + ", port: " + port, LogLevel.info);
		} else {
			Log.outl("Datenbanktyp " + type + " unbekannt.", LogLevel.error);
		}

	}

	private static String getCachePath(String path) {

		while (path.charAt(path.length() - 1) != '/'
				&& path.charAt(path.length() - 1) != '\\' && path.length() > 0) {
			path = path.substring(0, path.length() - 1);
		}

		path += "cache";

		return path;

	}

	public void setAsActiveDatabase() {
		if (type.compareToIgnoreCase("derby") == 0) {
			DatabaseAccess.setActiveASVDatabase(new DerbyDatabaseAccess(name,
					username, password, path));
			DatabaseAccess.setActiveCacheDatabase(new DerbyDatabaseAccess(name,
					username, password, getCachePath(path)));
		} else if (type.compareToIgnoreCase("postgres") == 0) {
			DatabaseAccess.setActiveASVDatabase(new PostgresDatabaseAccess(
					name, username, password, ip, port, "asv"));
			DatabaseAccess.setActiveCacheDatabase(new PostgresDatabaseAccess(
					name, username, password, ip, port, "cache"));
		} else {
			Log.outl("Datenbanktyp " + type + " unbekannt.", LogLevel.error);
		}

	}

	public String getName() {
		return name;
	}

	public void writeToXML(Element settings) {
		Element element = XMLWriter.addElement("database", settings);
		XMLWriter.addAttribute(element, "name", name);
		XMLWriter.addAttribute(element, "type", type);
		XMLWriter.addAttribute(element, "username", username);
		XMLWriter.addAttribute(element, "password", password);
		if (type.compareTo("postgres") == 0) {
			XMLWriter.addAttribute(element, "ip", ip);
			XMLWriter.addAttribute(element, "port", port);
		}
		if (type.compareTo("derby") == 0) {
			XMLWriter.addAttribute(element, "path", path);
		}

	}

	public void setType(String type) {
		this.type = type;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public void setPort(String port) {
		this.port = port;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void setName(String name) {
		this.name = name;
	}

}
