package tools.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

import logging.Log;
import logging.LogLevel;

public class FileTool {

	static public boolean makeDir(String path) {
		return new File(path).mkdirs();
	}

	public static void copyfile(String srFile, String dtFile) {
		try {
			File f1 = new File(srFile);
			File f2 = new File(dtFile);
			InputStream in = new FileInputStream(f1);

			// For Append the file.
			// OutputStream out = new FileOutputStream(f2,true);

			// For Overwrite the file.
			OutputStream out = new FileOutputStream(f2);

			byte[] buf = new byte[1024];
			int len;
			while ((len = in.read(buf)) > 0) {
				out.write(buf, 0, len);
			}
			in.close();
			out.close();
			// System.out.println("File copied.");
		} catch (FileNotFoundException ex) {
			Log.outl(ex.getMessage() + " in the specified directory.",
					LogLevel.error);
			System.exit(0);
		} catch (IOException e) {
			Log.outl(e.getMessage(), LogLevel.error);
		}
	}

	public static String readTextFile(File file, String encoding)
			throws IOException {

		StringBuilder contents = new StringBuilder();
		BufferedReader input = new BufferedReader(new InputStreamReader(
				new FileInputStream(file), encoding));

		try {
			String line = null; // not declared within while loop
			/*
			 * readLine is a bit quirky : it returns the content of a line MINUS
			 * the newline. it returns null only for the END of the stream. it
			 * returns an empty String if two newlines appear in a row.
			 */
			while ((line = input.readLine()) != null) {
				contents.append(line);
				contents.append(System.getProperty("line.separator"));
			}
		} finally {
			input.close();
		}

		return contents.toString();
	}

	public static ArrayList<String> readTextFileToArrayList(File file,
			String encoding) throws IOException {

		ArrayList<String> contents = new ArrayList<String>();

		BufferedReader input = new BufferedReader(new InputStreamReader(
				new FileInputStream(file), encoding));

		try {
			String line = null; // not declared within while loop
			/*
			 * readLine is a bit quirky : it returns the content of a line MINUS
			 * the newline. it returns null only for the END of the stream. it
			 * returns an empty String if two newlines appear in a row.
			 */
			while ((line = input.readLine()) != null) {
				contents.add(line);
			}
		} finally {
			input.close();
		}

		return contents;
	}

	public static void writeTextFile(File file, String encoding,
			ArrayList<String> contents) throws UnsupportedEncodingException,
			FileNotFoundException, IOException {
		java.io.Writer writer = new OutputStreamWriter(new FileOutputStream(
				file), encoding);

		try {

			for (String s : contents) {
				writer.write(s + System.getProperty("line.separator"));
			}

		} finally {
			if (writer != null) {
				writer.close();
			}
		}

	}

	public static void writeTextFile(File file, String encoding,
			String contents, boolean append)
			throws UnsupportedEncodingException, FileNotFoundException,
			IOException {
		java.io.Writer writer = new OutputStreamWriter(new FileOutputStream(
				file, append), encoding);

		try {

			writer.write(contents);

		} finally {
			if (writer != null) {
				writer.close();
			}
		}

	}

}
