package workerthreads;

import gui.MainFrameController;

import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

import data.DatabaseSettings;
import data.DatabaseTester;

/**
 * used to test database (e.g. get metadata).
 * 
 * not used.
 * 
 * @author Martin Pabst, 2009
 * 
 */
public class TestDatabaseWorker extends SwingWorker<Void, String> {

	/**
	 * store controller object
	 */
	private MainFrameController controller;
	private DatabaseTester databaseTester;

	/**
	 * constructor, only stores controller
	 * 
	 * @param controller
	 */
	public TestDatabaseWorker(MainFrameController controller) {
		super();
		this.controller = controller;

	}

	@Override
	protected Void doInBackground() throws Exception {
		controller.setButtonsEnabled(false);
		controller.setWaitCursor(true);
		controller.enableProgressbar(true);
		controller.setProgressBarMaximum(-1);

		/**
		 * test, if database connection and cache entities are present
		 */

		testDatabase();

		// Runnable doUpdateButton = new Runnable() {
		// public void run() {
		// controller.setSNRListe(databaseTester.getSchulliste());
		// controller.updateButtons();
		// }
		// };
		//
		// SwingUtilities.invokeLater(doUpdateButton);

		controller.setWaitCursor(false);
		controller.enableProgressbar(false);

		return null;
	}

	public void testDatabase() {
		databaseTester = new DatabaseTester(controller);

		databaseTester.testASVDatabase();

		DatabaseSettings.setDatabaseConnectionOK(databaseTester.isAsvDatabaseConnectionOK());
	}

}
