package gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.WindowConstants;

import logging.Log;
import logging.LogLevel;

/**
 * Very simple text editor to edit settings-file
 * 
 * @author Martin Pabst, 2009
 * 
 */

public class EditSettingsDialog extends JDialog implements ActionListener {

	/**
	 * Textarea which holds text of xml-file
	 */
	private JTextArea textArea;

	/**
	 * button "Save"
	 */
	private JButton buttonSave;

	/**
	 * button "Cancel"
	 */
	private JButton buttonCancel;

	/**
	 * constructor
	 * 
	 * @param owner
	 *            JFrame owner window
	 * @param modal
	 *            true, if dialog should be modal
	 */
	public EditSettingsDialog(JFrame owner, boolean modal) {

		super(owner, modal);

		setIconImage(Toolkit.getDefaultToolkit().getImage("data/iconASV16.png"));

		setSize(850, 650);
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

		setTitle("ASV Hilfecompiler, Einstellungen bearbeiten");

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());

		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(mainPanel, BorderLayout.CENTER);

		textArea = new JTextArea();
		JScrollPane sp = new JScrollPane(textArea);
		mainPanel.add(sp, BorderLayout.CENTER);

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));

		buttonSave = new JButton("Einstellungen Speichern");
		buttonSave.addActionListener(this);
		buttonPanel.add(Box.createRigidArea(new Dimension(20, 0)));
		buttonPanel.add(buttonSave);

		buttonCancel = new JButton("Abbrechen");
		buttonCancel.addActionListener(this);
		buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
		buttonPanel.add(buttonCancel);

		buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

		mainPanel.add(buttonPanel, BorderLayout.NORTH);

		try {
			readFile(new File("jobs.xml"));
			textArea.setCaretPosition(0);
		} catch (Exception ex) {
			Log.outl("Kann einstellungen.xml nicht lesen: " + ex.toString(),
					LogLevel.error);
			setVisible(false);
		}
	}

	/**
	 * Read given text-file (interpreted as UTF-8) and fill textarea
	 * 
	 * @param file
	 * @throws Exception
	 */
	public void readFile(File file) throws Exception {
		Reader reader = new InputStreamReader(new FileInputStream(file),
				"UTF-8");

		String text = "";

		try {

			int c;
			while ((c = reader.read()) != -1) {
				text += (char) c;
			}
		} finally {
			if (reader != null) {
				reader.close();
			}
		}

		textArea.setText(text);

	}

	/**
	 * writes text of textarea encoded as UTF-8 into given file
	 * 
	 * @param file
	 * @throws Exception
	 */
	public void writeFile(File file) throws Exception {
		java.io.Writer writer = new OutputStreamWriter(new FileOutputStream(
				file), "UTF-8");

		try {

			String text = textArea.getText();

			for (int i = 0; i < text.length(); i++) {
				writer.write(text.charAt(i));
			}

		} finally {
			if (writer != null) {
				writer.close();
			}
		}
	}

	/**
	 * action delegator for Save- and Cancel-button
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == buttonSave) {
			try {
				writeFile(new File("jobs.xml"));
			} catch (Exception ex) {
				Log.outl(
						"Kann einstellungen.xml nicht lesen: " + ex.toString(),
						LogLevel.error);
				setVisible(false);
			}
		}

		if (e.getSource() == buttonCancel) {
			// do nothing
		}

		setVisible(false);

	}

}
