package workerthreads.changedates;

/**
 * stores information which is needed to perform update of one attribute holding
 * a reference to svp_wl_schuljahr
 * 
 * @author Martin Pabst, 2009
 * 
 */

public class SchuljahrChangeInfo {
	/**
	 * database-id of table-row
	 */
	private String id;

	/**
	 * new Schoolyear (foreign key referencing svp_wl_schuljahr)
	 */
	private String newSchoolYear;

	/**
	 * get database-id
	 * 
	 * @return
	 */
	public String getId() {
		return id;
	}

	/**
	 * set database-id
	 * 
	 * @param id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * get new schoolyear (reference to svp_wl_schuljahr)
	 * 
	 * @return
	 */
	public String getNewSchoolYear() {
		return newSchoolYear;
	}

	/**
	 * set new schoolyear (reference to svp_wl_schuljahr)
	 * 
	 * @param newSchoolYear
	 */
	public void setNewSchoolYear(String newSchoolYear) {
		this.newSchoolYear = newSchoolYear;
	}

	/**
	 * constructor
	 * 
	 * @param id
	 * @param newSchoolYear
	 */
	public SchuljahrChangeInfo(String id, String newSchoolYear) {
		super();
		this.id = id;
		this.newSchoolYear = newSchoolYear;
	}

}
