package workerthreads.fitnessescriptcorrector;

import java.util.Calendar;

public class Token {

	private TokenType tokenType;

	private String text;

	private Calendar calendar;

	private boolean betweenPipes = false;

	public Token(TokenType tokenType, String text) {
		super();
		this.tokenType = tokenType;
		this.text = text;
	}

	public TokenType getTokenType() {
		return tokenType;
	}

	public void setTokenType(TokenType tokenType) {
		this.tokenType = tokenType;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	@Override
	public String toString() {
		String s = "(" + tokenType.toString();
		s += ", bp=" + betweenPipes;
		if (tokenType != TokenType.NewLine) {
			s += ": " + text;
		}
		s += ")";

		return s;

	}

	public boolean isBetweenPipes() {
		return betweenPipes;
	}

	public void setBetweenPipes(boolean betweenPipes) {
		this.betweenPipes = betweenPipes;
	}

	public Calendar getCalendar() {
		return calendar;
	}

	public void setCalendar(Calendar calendar) {
		this.calendar = calendar;
	}
}
