package data;

import java.util.ArrayList;

import tools.string.StringTool;

/**
 * 
 * stores an SQL-script
 * 
 * @author Martin Pabst, 2009
 * 
 */

public class Script {

	/**
	 * SQL-Statements as String
	 */
	private String statements;

	/**
	 * List of single SQL statements
	 */
	private ArrayList<String> singleStatements = new ArrayList<String>();

	/**
	 * identifier of script
	 */
	private String identifier;

	/**
	 * get SQL-statements
	 * 
	 * @return SQL-statements as String
	 */
	public String getStatements() {
		return statements;
	}

	/**
	 * set SQL-statements
	 * 
	 * @param statements
	 *            SQL-Statements as String
	 */
	public void setStatements(String statements) {
		this.statements = statements;
		singleStatements = chopSQLScript(statements);
	}

	/**
	 * get indentifier for SQL script
	 * 
	 * @return identifier for SQL-script
	 */
	public String getIdentifier() {
		return identifier;
	}

	/**
	 * set identifier for SQL-script
	 * 
	 * @param identifier
	 */
	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	/**
	 * constructor
	 * 
	 * @param statements
	 *            SQL-statements as String
	 * @param identifier
	 *            Identifier of SQL-script
	 */
	public Script(String statements, String identifier) {
		super();
		setStatements(statements);
		this.identifier = identifier;
	}

	/**
	 * returns String-representation of object
	 */
	public String toString() {
		String ret = "Name: " + identifier + "\n";
		if (singleStatements.size() == 1) {
			ret += "Statements: " + statements;
		} else {
			ret += "; " + singleStatements.size() + " statements.";
		}
		ret += "\n";
		return ret;

	}

	/**
	 * chops SQL-Script into list of SQL-statements
	 * 
	 * @param script
	 * @return List of SQL-statements
	 */
	private ArrayList<String> chopSQLScript(String script) {
		boolean readInsideQuotationMarks = false;

		String statement = "";

		ArrayList<String> ret = new ArrayList<String>();

		int pos = 0;
		int a = 0;

		while (pos < script.length()) {
			switch (script.charAt(pos)) {
			case '\'':
				readInsideQuotationMarks = !readInsideQuotationMarks;
				break;
			case ';':
				if (!readInsideQuotationMarks) {
					statement = script.substring(a, pos + 1); // including ';'
					statement = deleteStartComment(statement);
					if (statement.length() > 3) {
						ret.add(statement);
					}
					a = pos + 1;
				}
				break;
			default:
				break;
			}
			pos++;
		}

		if (a < script.length() - 1) {
			statement = script.substring(a, script.length());
			statement = deleteStartComment(statement);
			if (statement.length() > 3) {
				ret.add(statement);
			}
		}

		return ret;
	}

	/**
	 * if given query starts with a comment, then this method returns this query
	 * without comment. Otherwise it returns unmodified query.
	 * 
	 * @param query
	 * @return
	 */
	private String deleteStartComment(String query) {

		query = StringTool.deleteBeginSpace(query);

		while (query.startsWith("--")) {
			int pos = 0;
			while (pos < query.length() && query.charAt(pos) != '\n') {
				pos++;
			}
			if (pos < query.length()) {
				query = query.substring(pos + 1);
			}
		}
		return query;
	}

	public ArrayList<String> getSingleStatements() {
		return singleStatements;
	}

}
