package main;

import gui.MainFrameController;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

import javax.swing.UIManager;

/**
 * Main-class; just instantiates MainframeController and shows MainFrame.
 * 
 * @author Martin
 * 
 */
public class Main {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		/**
		 * is program invoked with switch -commandline?
		 */
		if (args.length > 0 && args[0].compareToIgnoreCase("-commandline") == 0) {

			/**
			 * Set Console to cp850-charset
			 */
			try {
				System.setOut(new PrintStream(System.out, true, "cp850"));
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
			}

			CommandlineStarter cs = new CommandlineStarter(args);

			/*
			 * Application logic is done by CommandlineStarte.start()
			 */
			cs.start();

		} else {
			/*
			 * We are not started with switch -commandline, so show window!
			 * 
			 * 
			 * set SystemLookAndFeel -> looks most nice
			 */
			try {
				UIManager.setLookAndFeel(UIManager
						.getSystemLookAndFeelClassName());
			} catch (Exception e) {
			}

			/**
			 * MVC-Pattern: setup controller and show main frame. Application
			 * flow will be event triggered from this point on.
			 */
			MainFrameController mfc = new MainFrameController();

			mfc.showMainFrame();
		}

	}

}
