/*
 * Decompiled with CFR 0.152.
 */
package gui.settings;

import data.DatabaseSettings;
import database.DatabaseLoginInfo;
import gui.settings.SettingsFrame;

public class SettingsController {
    private SettingsFrame sf = new SettingsFrame(this);
    private boolean exitCancel = true;

    public boolean isExitCancel() {
        return this.exitCancel;
    }

    public void setExitCancel(boolean exitCancel) {
        this.exitCancel = exitCancel;
    }

    public SettingsController() {
        this.writeValuesToGUI();
        this.sf.setModal(true);
        this.sf.setVisible(true);
    }

    public void writeValuesToGUI() {
        if (DatabaseSettings.getActiveDatabase().compareTo("Derby") == 0) {
            this.sf.getRbDerby().setSelected(true);
            this.sf.setDatabaseType("derby");
        } else {
            this.sf.getRbPostgres().setSelected(true);
            this.sf.setDatabaseType("postgres");
        }
        DatabaseLoginInfo dliDerby = DatabaseSettings.getDerbyLoginInfo();
        this.sf.getJTextFieldDerbyUsername().setText(dliDerby.getUsername());
        this.sf.getJTextFieldDerbyPath().setText(dliDerby.getPath());
        this.sf.getJPasswordFieldDerbyPassword().setText(dliDerby.getPassword());
        DatabaseLoginInfo dliPostgres = DatabaseSettings.getPostgresLoginInfo();
        this.sf.getJTextFieldPostgresUsername().setText(dliPostgres.getUsername());
        this.sf.getJTextFieldPostgresIP().setText(dliPostgres.getIp());
        this.sf.getJTextFieldPostgresPort().setText(dliPostgres.getPort());
        this.sf.getJPasswordFieldPostgresPassword().setText(dliPostgres.getPassword());
    }

    public void readValuesFromGui() {
        if (this.sf.getRbDerby().isSelected()) {
            DatabaseSettings.setActiveDatabase("Derby");
        } else {
            DatabaseSettings.setActiveDatabase("Postgres");
        }
        DatabaseLoginInfo dliDerby = DatabaseSettings.getDerbyLoginInfo();
        dliDerby.setType("derby");
        dliDerby.setName("Derby");
        dliDerby.setUsername(this.sf.getJTextFieldDerbyUsername().getText());
        dliDerby.setPassword(new String(this.sf.getJPasswordFieldDerbyPassword().getPassword()));
        dliDerby.setPath(this.sf.getJTextFieldDerbyPath().getText());
        DatabaseLoginInfo dliPostgres = DatabaseSettings.getPostgresLoginInfo();
        dliPostgres.setType("postgres");
        dliPostgres.setName("Postgres");
        dliPostgres.setUsername(this.sf.getJTextFieldPostgresUsername().getText());
        dliPostgres.setPassword(new String(this.sf.getJPasswordFieldPostgresPassword().getPassword()));
        dliPostgres.setIp(this.sf.getJTextFieldPostgresIP().getText());
        dliPostgres.setPort(this.sf.getJTextFieldPostgresPort().getText());
        DatabaseSettings.writeSettings();
    }
}

