/*
 * Decompiled with CFR 0.152.
 */
package tools.file;

import java.util.ArrayList;
import tools.file.FileTree;
import tools.file.Path;

public class FileTreeNode {
    private String name = "";
    private boolean isDirectory = false;
    private ArrayList<FileTreeNode> childNodes = new ArrayList();
    private FileTreeNode parent;

    public String getPath() {
        if (this instanceof FileTree) {
            FileTree tree = (FileTree)this;
            return tree.getBasePath().toString(false);
        }
        String s = String.valueOf(this.parent.getPath()) + this.name;
        if (this.isDirectory) {
            s = String.valueOf(s) + "/";
        }
        return s;
    }

    public FileTreeNode(String name, FileTreeNode parent, boolean isDirectory) {
        this.name = name;
        this.parent = parent;
        this.isDirectory = isDirectory;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void addChild(FileTreeNode fileTreeNode) {
        this.childNodes.add(fileTreeNode);
        fileTreeNode.parent = this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public ArrayList<FileTreeNode> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(ArrayList<FileTreeNode> childNodes) {
        this.childNodes = childNodes;
    }

    public FileTreeNode getParent() {
        return this.parent;
    }

    public void setParent(FileTreeNode parent) {
        this.parent = parent;
    }

    public Path getRelativePath() {
        if (this instanceof FileTree) {
            return new Path();
        }
        if (this.isDirectory) {
            Path path = this.parent.getRelativePath();
            path.add(this.name);
            return path;
        }
        Path path = this.parent.getRelativePath();
        path.setFilename(this.name);
        return path;
    }

    public boolean isWikiPage() {
        boolean ret = false;
        if (this.name.length() > 4 && this.name.substring(this.name.length() - 4, this.name.length()).compareToIgnoreCase(".txt") == 0) {
            ret = true;
        }
        return ret;
    }

    public int getSize() {
        int anz = 0;
        for (FileTreeNode child : this.childNodes) {
            anz += child.getSize();
        }
        if (!this.isDirectory && this.isWikiPage()) {
            ++anz;
        }
        return anz;
    }
}

