/*
 * Decompiled with CFR 0.152.
 */
package tools.xml;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import logging.Log;
import logging.LogLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tools.xml.NoResolver;

public class XMLReader {
    public static Document readFile(String file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new NoResolver());
        return builder.parse(file);
    }

    public static Document readFile(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new NoResolver());
        return builder.parse(stream);
    }

    public static Document readString(String s) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new NoResolver());
        StringReader reader = new StringReader(s);
        InputSource inSource = new InputSource(reader);
        return builder.parse(inSource);
    }

    public static Element root(Document doc) {
        return doc.getDocumentElement();
    }

    public static String text(Element element) {
        if (element == null) {
            return "";
        }
        return element.getTextContent();
    }

    public static String textTrim(Element element) {
        if (element == null) {
            return "";
        }
        return element.getTextContent().trim();
    }

    public static String attribute(Element element, String name) {
        if (element == null) {
            return null;
        }
        NamedNodeMap attributes = element.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node value = attributes.getNamedItem(name);
        if (value == null) {
            return null;
        }
        return value.getTextContent();
    }

    public static String attributeNotNull(Element element, String name) {
        String ret = XMLReader.attribute(element, name);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public static Element element(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String nodeName = children.item(i).getNodeName();
            if (nodeName.equals(name)) {
                return (Element)children.item(i);
            }
            ++i;
        }
        return null;
    }

    public static List<Element> elements(Node parent, String name) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeName().equals(name)) {
                ret.add((Element)children.item(i));
            }
            ++i;
        }
        return ret;
    }

    public static List<Element> elements(Node parent) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof Element) {
                ret.add((Element)children.item(i));
            }
            ++i;
        }
        return ret;
    }

    public static String elementText(Element parentElement, String elementName) {
        Element e = XMLReader.element(parentElement, elementName);
        if (e == null) {
            return null;
        }
        return XMLReader.text(e);
    }

    public static String elementTextNotNull(Element parentElement, String elementName) {
        return XMLReader.text(XMLReader.element(parentElement, elementName));
    }

    public static Double elementDoubleAttribute(Element element, String name) {
        Double d = null;
        String s = XMLReader.attribute(element, name);
        if (s != null) {
            try {
                d = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                Log.outl("XMLReader.elementDoubleAttribute: " + s + " is not a double value", LogLevel.warning);
            }
        }
        return d;
    }

    public static Float elementFloatAttribute(Element element, String name) {
        Float f = null;
        String s = XMLReader.attribute(element, name);
        if (s != null) {
            try {
                f = Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException e) {
                Log.outl("XMLReader.elementFloatAttribute: " + s + " is not a Float value", LogLevel.warning);
            }
        }
        return f;
    }

    public static Integer elementIntegerAttribute(Element element, String name) {
        Integer f = null;
        String s = XMLReader.attribute(element, name);
        if (s != null) {
            try {
                f = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                Log.outl("XMLReader.elementIntegerAttribute: " + s + " is not a Integer value", LogLevel.warning);
            }
        }
        return f;
    }

    public static Color elementColorAttribute(Element element, String name) {
        Color c = null;
        String s = XMLReader.attribute(element, name);
        if (s != null) {
            try {
                int r = Integer.parseInt(s.substring(2, 4), 16);
                int g = Integer.parseInt(s.substring(4, 6), 16);
                int b = Integer.parseInt(s.substring(6, 8), 16);
                int alpha = Integer.parseInt(s.substring(8, 10), 16);
                c = new Color(r, g, b, alpha);
            }
            catch (NumberFormatException e) {
                Log.outl("XMLReader.elementFloatAttribute: " + s + " is not a Float value", LogLevel.warning);
            }
        }
        return c;
    }

    public static Boolean elementBooleanAttribute(Element element, String name) {
        Boolean f = null;
        String s = XMLReader.attribute(element, name);
        if (s != null) {
            try {
                f = Boolean.parseBoolean(s);
            }
            catch (NumberFormatException e) {
                Log.outl("XMLReader.elementBooleanAttribute: " + s + " is not a Boolean value", LogLevel.warning);
            }
        }
        return f;
    }
}

