/*
 * Decompiled with CFR 0.152.
 */
package data;

import database.DatabaseLoginInfo;
import java.awt.Color;
import java.io.File;
import java.util.List;
import logging.Log;
import logging.LogLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tools.xml.XMLReader;
import tools.xml.XMLWriter;

public class DatabaseSettings {
    private static boolean databaseConnectionOK = false;
    private static String activeDatabase = "Derby";
    private static DatabaseLoginInfo derbyLoginInfo = new DatabaseLoginInfo();
    private static DatabaseLoginInfo postgresLoginInfo = new DatabaseLoginInfo();
    private static final String settingsFilename = "einstellungen.xml";

    public static boolean isDatabaseConnectionOK() {
        return databaseConnectionOK;
    }

    public static void readSettings() {
        try {
            Document doc = XMLReader.readFile(settingsFilename);
            Element root = XMLReader.root(doc);
            Log.outlColor("\nEinstellungen laden:", LogLevel.info, new Color(0, 100, 0));
            if (root.getNodeName().compareTo("settings") != 0) {
                throw new Exception("Element \"settings\" in der Datei einstellungen.xml erwartet.");
            }
            Element settings = root;
            DatabaseSettings.getDatabases(settings);
            Log.outl("", LogLevel.info);
        }
        catch (Exception e) {
            Log.outl(String.valueOf(e.toString()) + e.getStackTrace().toString(), LogLevel.error);
        }
    }

    private static void getDatabases(Element root) {
        Element activeDatabaseXML = XMLReader.element(root, "activedatabase");
        activeDatabase = XMLReader.attributeNotNull(activeDatabaseXML, "name");
        List<Element> databases = XMLReader.elements(root, "database");
        for (Element databaseXML : databases) {
            DatabaseLoginInfo dli = new DatabaseLoginInfo();
            dli.readFromXML(databaseXML);
            if (dli.getName().compareTo(activeDatabase) == 0) {
                dli.setAsActiveDatabase();
            }
            if (dli.getType().compareTo("derby") == 0) {
                derbyLoginInfo = dli;
            }
            if (dli.getType().compareTo("postgres") != 0) continue;
            postgresLoginInfo = dli;
        }
        Log.outColor("Verwendete Datenbank: ", LogLevel.useful, new Color(0, 0, 255));
        Log.outl(activeDatabase, LogLevel.useful);
        Log.outl("", LogLevel.useful);
    }

    public static void writeSettings() {
        try {
            Document doc = XMLWriter.createEmptyDocument();
            Element settings = doc.createElement("settings");
            doc.appendChild(settings);
            Element adElement = XMLWriter.addElement("activedatabase", settings);
            XMLWriter.addAttribute(adElement, "name", activeDatabase);
            postgresLoginInfo.writeToXML(settings);
            derbyLoginInfo.writeToXML(settings);
            File file = new File(settingsFilename);
            XMLWriter.writeToFile(doc, file);
        }
        catch (Exception ex) {
            Log.outlColor(ex.toString(), LogLevel.error, Color.red);
        }
    }

    public static void setDatabaseConnectionOK(boolean databaseConnectionOK) {
        DatabaseSettings.databaseConnectionOK = databaseConnectionOK;
    }

    public static String getActiveDatabase() {
        return activeDatabase;
    }

    public static void setActiveDatabase(String activeDatabase) {
        DatabaseSettings.activeDatabase = activeDatabase;
    }

    public static DatabaseLoginInfo getDerbyLoginInfo() {
        return derbyLoginInfo;
    }

    public static void setDerbyLoginInfo(DatabaseLoginInfo derbyLoginInfo) {
        DatabaseSettings.derbyLoginInfo = derbyLoginInfo;
    }

    public static DatabaseLoginInfo getPostgresLoginInfo() {
        return postgresLoginInfo;
    }

    public static void setPostgresLoginInfo(DatabaseLoginInfo postgresLoginInfo) {
        DatabaseSettings.postgresLoginInfo = postgresLoginInfo;
    }
}

