/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DatabaseAccess;
import java.awt.Color;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import logging.Log;
import logging.LogLevel;

public class DerbyDatabaseAccess
extends DatabaseAccess {
    private String path;

    public DerbyDatabaseAccess(String name, String username, String password, String path) {
        super(name, username, password);
        this.path = path;
    }

    @Override
    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
                Properties properties = new Properties();
                properties.put("user", this.username);
                properties.put("password", this.password);
                DriverManager.getConnection(String.valueOf(this.path) + ";shutdown=true", properties);
                Log.outColor("Schlie\u00dfe Derby-Datenbank.", LogLevel.useful, new Color(0, 150, 0));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void openConnection() throws Exception {
        Log.outColor("Verbinde mit Derby-Datenbank...", LogLevel.useful, new Color(0, 150, 0));
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        String path1 = "jdbc:derby:" + this.path;
        Properties properties = new Properties();
        properties.put("user", this.username);
        properties.put("password", this.password);
        properties.put("create", "true");
        this.connection = DriverManager.getConnection(path1, properties);
        Log.outlColor("OK!", LogLevel.useful, new Color(0, 150, 0));
    }
}

