/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ColorPane;
import gui.EditSettingsDialog;
import gui.MainFrameController;
import gui.settings.SettingsController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import logging.Log;
import logging.LogLevel;

public class MainFrame
extends JFrame
implements ActionListener {
    private static MainFrame instance = null;
    private JButton buttonStartScript;
    private JButton buttonChangeDates;
    private JButton buttonCorrectFitnesseScripts;
    private JButton buttonEditSettings;
    private JButton buttonOutputDateFields;
    private JButton buttonEditDatabaseSettings;
    private MainFrameController controller;
    private ColorPane textArea;
    private JSplitPane splitPane;
    private JProgressBar progressBar;
    private LogLevel[] LogLevels = new LogLevel[]{LogLevel.trace, LogLevel.info, LogLevel.useful, LogLevel.warning, LogLevel.error};
    private JRadioButton[] logLevelButtons = new JRadioButton[this.LogLevels.length];

    public ColorPane getTextArea() {
        return this.textArea;
    }

    public static MainFrame getInstance() {
        if (instance == null) {
            instance = new MainFrame();
        }
        return instance;
    }

    public void setController(MainFrameController controller) {
        this.controller = controller;
    }

    private MainFrame() {
    }

    public void init() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("data/script_go.png"));
        this.setSize(800, 750);
        this.setTitle("ASV-Zeitmaschine (M.Pabst, 25.08.2014)");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        northPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        mainPanel.add((Component)northPanel, "North");
        this.buttonStartScript = new JButton("Skripts starten");
        this.buttonStartScript.addActionListener(this);
        buttonPanel.add(this.buttonStartScript);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.buttonChangeDates = new JButton("Datumsangaben \u00e4ndern");
        this.buttonChangeDates.addActionListener(this);
        buttonPanel.add(this.buttonChangeDates);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.buttonCorrectFitnesseScripts = new JButton("Fitnesse-Scripts korrigieren");
        this.buttonCorrectFitnesseScripts.addActionListener(this);
        buttonPanel.add(this.buttonCorrectFitnesseScripts);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.buttonEditSettings = new JButton("Einstellungen bearbeiten");
        this.buttonEditSettings.addActionListener(this);
        buttonPanel.add(this.buttonEditSettings);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.buttonOutputDateFields = new JButton("Datumsfelder ausgeben");
        this.buttonOutputDateFields.addActionListener(this);
        buttonPanel.add(this.buttonOutputDateFields);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.buttonEditDatabaseSettings = new JButton("Datenbankverbindung einstellen...");
        this.buttonEditDatabaseSettings.addActionListener(this);
        buttonPanel.add(this.buttonEditDatabaseSettings);
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, 1));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        radioButtonPanel.setBorder(BorderFactory.createTitledBorder(blackline, "Logging:"));
        ButtonGroup bg = new ButtonGroup();
        int i = 0;
        while (i < this.LogLevels.length) {
            JRadioButton rb;
            LogLevel logLevel = this.LogLevels[i];
            this.logLevelButtons[i] = rb = new JRadioButton(logLevel.name());
            if (logLevel == LogLevel.info) {
                rb.setSelected(true);
                Log.setMinimumLogLevel(LogLevel.info);
            }
            bg.add(rb);
            rb.addActionListener(this);
            radioButtonPanel.add(rb);
            ++i;
        }
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        northPanel.add((Component)radioButtonPanel, "East");
        northPanel.add((Component)buttonPanel, "Center");
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        this.textArea = new ColorPane();
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        centerPanel.add((Component)scrollPane, "Center");
        JPanel progressBarPanel = new JPanel();
        progressBarPanel.setLayout(new BorderLayout());
        this.progressBar = new JProgressBar();
        progressBarPanel.add(this.progressBar);
        this.splitPane = new JSplitPane(0, true, progressBarPanel, centerPanel);
        this.splitPane.setDividerSize(0);
        this.enableProgressBar(false);
        mainPanel.add((Component)this.splitPane, "Center");
        this.setButtonsEnabled(true);
        this.setDefaultCloseOperation(3);
    }

    public void enableProgressBar(boolean enabled) {
        if (enabled) {
            this.progressBar.setStringPainted(true);
            this.splitPane.setDividerLocation(20);
        } else {
            this.splitPane.setDividerLocation(0);
        }
    }

    public void setProgressBarMaximum(int max) {
        if (max >= 0) {
            this.progressBar.setMaximum(max);
            this.progressBar.setIndeterminate(false);
        } else {
            this.progressBar.setIndeterminate(true);
        }
        this.progressBar.setString("");
    }

    public void setProgressBarPosition(int value, String text) {
        this.progressBar.setValue(value);
        this.progressBar.setString(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SettingsController sc;
        if (e.getSource() == this.buttonStartScript) {
            this.controller.startScript();
        }
        if (e.getSource() == this.buttonChangeDates) {
            this.controller.changeDates();
        }
        if (e.getSource() == this.buttonCorrectFitnesseScripts) {
            this.controller.correctFitnesseScripts();
        }
        if (e.getSource() == this.buttonEditSettings) {
            EditSettingsDialog esd = new EditSettingsDialog(this, true);
            esd.setVisible(true);
            this.controller.readSettings();
        }
        if (e.getSource() == this.buttonOutputDateFields) {
            this.controller.outputDateFields();
        }
        if (e.getSource() == this.buttonEditDatabaseSettings && !(sc = new SettingsController()).isExitCancel()) {
            this.controller.clearTextArea();
            this.controller.readSettings();
        }
        int i = 0;
        while (i < this.logLevelButtons.length) {
            if (e.getSource() == this.logLevelButtons[i]) {
                Log.setMinimumLogLevel(this.LogLevels[i]);
            }
            ++i;
        }
    }

    public void setButtonsEnabled(boolean enabled) {
        this.buttonStartScript.setEnabled(enabled);
        this.buttonChangeDates.setEnabled(enabled);
    }

    public void setWaitCursor(boolean isWait) {
        if (isWait) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.textArea.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.textArea.setCursor(Cursor.getPredefinedCursor(2));
        }
    }
}

