/*
 * Decompiled with CFR 0.152.
 */
package tools.file;

import java.util.ArrayList;

public class Path
extends ArrayList<String> {
    private String filename = "";
    private String anchor = "";
    private boolean isAbsoluteWikiLink = false;

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public Path(String path, boolean withFilename, boolean isWikiPath) {
        String part = "";
        boolean startsWithColon = false;
        if (path.length() > 0 && path.charAt(0) == ':') {
            startsWithColon = true;
        }
        if (isWikiPath && path.length() > 0 && path.charAt(0) == ':') {
            path = path.substring(1);
        }
        int i = 0;
        while (i < path.length()) {
            Character c = Character.valueOf(path.charAt(i));
            if (c.charValue() == '/' || c.charValue() == '\\' || isWikiPath && c.charValue() == ':') {
                this.add(part);
                part = "";
            } else {
                part = String.valueOf(part) + c;
            }
            ++i;
        }
        if (!part.isEmpty()) {
            this.add(part);
        }
        if (withFilename && this.size() > 0) {
            String s = (String)this.get(this.size() - 1);
            this.remove(this.size() - 1);
            this.filename = s;
        }
        if (!this.filename.isEmpty() && this.filename.contains("#")) {
            int pos = this.filename.indexOf(35);
            this.anchor = this.filename.substring(pos + 1);
            this.filename = this.filename.substring(0, pos);
        }
        this.isAbsoluteWikiLink = isWikiPath && (startsWithColon || this.size() >= 1) && this.size() > 0 && !((String)this.get(0)).equalsIgnoreCase(".") && !((String)this.get(0)).equalsIgnoreCase("..");
        this.normalize();
    }

    public void normalize() {
        int i = 0;
        while (i < this.size() - 1) {
            if (((String)this.get(i + 1)).equals("..") && !((String)this.get(i)).equals(".") && !((String)this.get(i)).equals("..")) {
                this.remove(i);
                this.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void changeTxtToHtm() {
        if (this.filename.length() > 4 && this.filename.substring(this.filename.length() - 4, this.filename.length()).compareToIgnoreCase(".txt") == 0) {
            this.filename = this.filename.substring(0, this.filename.length() - 4);
            this.filename = String.valueOf(this.filename) + ".htm";
        }
    }

    public void add(Path path) {
        int i = 0;
        while (i < path.size()) {
            if (((String)path.get(i)).compareTo("..") == 0 && this.size() > 0) {
                this.remove(this.size() - 1);
            } else {
                this.add((String)path.get(i));
            }
            ++i;
        }
    }

    public Path(String pathWithoutFilename, String onlyFilename) {
        String part = "";
        int i = 0;
        while (i < pathWithoutFilename.length()) {
            Character c = Character.valueOf(pathWithoutFilename.charAt(i));
            if (c.charValue() == '/' || c.charValue() == '\\') {
                this.add(part);
                part = "";
            } else {
                part = String.valueOf(part) + c;
            }
            ++i;
        }
        if (!part.isEmpty()) {
            this.add(part);
        }
    }

    public Path() {
    }

    public String toString(boolean withFilename) {
        String ret = "";
        int i = 0;
        while (i < this.size()) {
            ret = String.valueOf(ret) + (String)this.get(i) + "/";
            ++i;
        }
        if (withFilename) {
            ret = String.valueOf(ret) + this.filename;
        }
        if (!this.anchor.isEmpty()) {
            ret = String.valueOf(ret) + "#" + this.anchor;
        }
        return ret;
    }

    public static Path getPathFromWikiLinkRelativeToCurrentPage(Path pathToCurrentPage, Path wikiLink) {
        Path absolutePath = new Path();
        absolutePath.setFilename(wikiLink.getFilename());
        if (wikiLink.size() > 0) {
            if (((String)wikiLink.get(0)).equalsIgnoreCase(".")) {
                absolutePath.copyFrom(pathToCurrentPage);
                absolutePath.setFilename(wikiLink.getFilename());
                int indexOfDot = absolutePath.size();
                absolutePath.add(wikiLink);
                absolutePath.remove(indexOfDot);
                absolutePath.normalize();
                absolutePath = absolutePath.getPathRelativeTo(pathToCurrentPage);
            } else if (wikiLink.isAbsoluteWikiLink) {
                absolutePath = wikiLink.getPathRelativeTo(pathToCurrentPage);
            } else {
                absolutePath.copyFrom(pathToCurrentPage);
                absolutePath.add(wikiLink);
                absolutePath.normalize();
                absolutePath = absolutePath.getPathRelativeTo(pathToCurrentPage);
            }
        }
        return absolutePath;
    }

    public Path getPathRelativeTo(Path path) {
        int identicalUpto = -1;
        int i = 0;
        while (i < this.min(this.size(), path.size())) {
            if (((String)this.get(i)).compareToIgnoreCase((String)path.get(i)) != 0) break;
            identicalUpto = i++;
        }
        Path ret = new Path();
        int i2 = identicalUpto + 1;
        while (i2 < path.size()) {
            ret.add("..");
            ++i2;
        }
        i2 = identicalUpto + 1;
        while (i2 < this.size()) {
            ret.add((String)this.get(i2));
            ++i2;
        }
        ret.filename = this.filename;
        ret.anchor = this.anchor;
        return ret;
    }

    public void buildFromWikiPath(Path pathToWiki, String pathInsideWiki) {
        this.copyFrom(pathToWiki);
    }

    public void copyFrom(Path path) {
        int i = 0;
        while (i < path.size()) {
            this.add((String)path.get(i));
            ++i;
        }
        this.filename = path.filename;
    }

    int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void removeLastPart() {
        if (this.size() > 0) {
            this.remove(this.size() - 1);
        }
    }

    public static String getLeftDirectory(String s) {
        String ret = "";
        if (s.length() > 0) {
            int i = 0;
            while (i < s.length() && s.charAt(i) != '/' && s.charAt(i) != '\\') {
                ++i;
            }
            ret = s.substring(0, i);
        }
        return ret;
    }

    public static String getRightRest(String s) {
        String ret = "";
        if (s.length() > 0) {
            int i = 0;
            while (i < s.length() && s.charAt(i) != '/' && s.charAt(i) != '\\') {
                ++i;
            }
            ret = i < s.length() ? s.substring(i + 1) : "";
        }
        return ret;
    }

    public static String getRightDirectory(String s) {
        String ret = "";
        if (s.length() > 0) {
            int i = s.length() - 1;
            while (i >= 0 && s.charAt(i) != '/' && s.charAt(i) != '\\') {
                --i;
            }
            ret = s.substring(i + 1);
        }
        return ret;
    }

    public static String getLeftRest(String s) {
        String ret = "";
        if (s.length() > 0) {
            int i = s.length() - 1;
            while (i >= 0 && s.charAt(i) != '/' && s.charAt(i) != '\\') {
                --i;
            }
            ret = i > 0 ? s.substring(0, i) : "";
        }
        return ret;
    }
}

