/*
 * Decompiled with CFR 0.152.
 */
package tools.xml;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tools.xml.Base64;

public final class XMLWriter {
    private XMLWriter() {
    }

    public static Document createEmptyDocument() throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (Exception ex) {
            throw new Exception("Creating a new DOM document failed: " + ex.toString());
        }
    }

    public static void writeFile(Document doc, String path) throws IOException {
        File f = new File(path);
        XMLWriter.writeToFile(doc, f);
    }

    public static void writeToFile(Document doc, File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(fos);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            throw new IOException("Problem with XML-Transformer: " + ex.toString());
        }
    }

    public static Element addElement(String name, Node parentElement) {
        Document parentDoc = parentElement.getOwnerDocument();
        Document doc = parentDoc != null ? parentDoc : (Document)parentElement;
        Element ret = doc.createElement(name);
        parentElement.appendChild(ret);
        return ret;
    }

    public static CDATASection addCDATA(Node parentElement, String data) {
        Document parentDoc = parentElement.getOwnerDocument();
        Document doc = parentDoc != null ? parentDoc : (Document)parentElement;
        CDATASection ret = doc.createCDATASection(data);
        parentElement.appendChild(ret);
        return ret;
    }

    public static CDATASection addCDATA(Node parentElement, byte[] data) {
        Document parentDoc = parentElement.getOwnerDocument();
        Document doc = parentDoc != null ? parentDoc : (Document)parentElement;
        String dataString = Base64.encodeBytes(data);
        CDATASection ret = doc.createCDATASection(dataString);
        parentElement.appendChild(ret);
        return ret;
    }

    public static void addAttribute(Node element, String name, String value) {
        ((Element)element).setAttribute(name, value);
    }

    public static void addAttributeDouble(Node element, String name, double value) {
        ((Element)element).setAttribute(name, Double.toString(value));
    }

    public static void addAttributeFloat(Node element, String name, float value) {
        ((Element)element).setAttribute(name, Float.toString(value));
    }

    public static void addAttributeInt(Node element, String name, int value) {
        ((Element)element).setAttribute(name, Integer.toString(value));
    }

    public static void addAttributeBoolean(Node element, String name, boolean value) {
        ((Element)element).setAttribute(name, Boolean.toString(value));
    }

    public static void addAttributeColor(Node element, String name, Color value) {
        ((Element)element).setAttribute(name, "0x" + XMLWriter.toHexff(value.getRed()) + XMLWriter.toHexff(value.getGreen()) + XMLWriter.toHexff(value.getBlue()) + XMLWriter.toHexff(value.getAlpha()));
    }

    private static String toHexff(int i) {
        String s = Integer.toHexString(i);
        while (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }
}

