/*
 * Decompiled with CFR 0.152.
 */
package workerthreads.getmetadata;

import database.DatabaseAccess;
import database.PostgresDatabaseAccess;
import gui.MainFrameController;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.SwingWorker;
import logging.Log;
import logging.LogLevel;
import workerthreads.getmetadata.Attribute;

public class GetMetadataWorker
extends SwingWorker<Void, String> {
    private MainFrameController controller;
    private String path;

    public GetMetadataWorker(MainFrameController controller) {
        this.controller = controller;
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.controller.setButtonsEnabled(false);
        this.controller.setWaitCursor(true);
        this.controller.enableProgressbar(true);
        this.controller.setProgressBarMaximum(-1);
        try {
            DatabaseAccess.getActiveDatabase(false).openConnection();
            this.printMetaData();
            DatabaseAccess.getActiveDatabase(false).closeConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.controller.setWaitCursor(false);
        this.controller.setButtonsEnabled(true);
        this.controller.enableProgressbar(false);
        return null;
    }

    private void printMetaData() throws SQLException {
        String columnName;
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Connection connection = DatabaseAccess.getActiveDatabase(false).getConnection();
        DatabaseMetaData dmd = connection.getMetaData();
        String catalog = null;
        String schema = null;
        String tableName = "SVP%";
        if (DatabaseAccess.getActiveDatabase(false) instanceof PostgresDatabaseAccess) {
            tableName = tableName.toLowerCase();
        }
        String[] types = null;
        ResultSet rs = dmd.getTables(catalog, schema, tableName, types);
        while (rs.next()) {
            String id = rs.getString(3);
            tables.add(id);
        }
        rs.close();
        Log.outl("Tabellen: ", LogLevel.useful);
        Log.outl("", LogLevel.useful);
        for (String table : tables) {
            Log.outl(table, LogLevel.useful);
        }
        Log.outl("\n\n", LogLevel.useful);
        for (String table : tables) {
            catalog = null;
            schema = null;
            tableName = table;
            columnName = null;
            dmd = connection.getMetaData();
            rs = dmd.getColumns(catalog, schema, tableName, columnName);
            while (rs.next()) {
                columnName = rs.getString(4);
                int dataType = rs.getInt(5);
                if (dataType != 91) continue;
                Attribute at = new Attribute(table, columnName);
                Log.outl(String.valueOf(table) + "." + columnName, LogLevel.useful);
                attributes.add(at);
            }
        }
        rs.close();
        Log.outl("", LogLevel.useful);
        for (String table : tables) {
            catalog = null;
            schema = null;
            tableName = table;
            columnName = null;
            dmd = connection.getMetaData();
            rs = dmd.getColumns(catalog, schema, tableName, columnName);
            while (rs.next()) {
                columnName = rs.getString(4);
                if (columnName.compareToIgnoreCase("schuljahr_id") != 0 && columnName.compareToIgnoreCase("pkz") != 0) continue;
                Attribute at = new Attribute(table, columnName);
                Log.outl(String.valueOf(table) + "." + columnName, LogLevel.useful);
                attributes.add(at);
            }
        }
        rs.close();
    }
}

