/**
 * Global types and values we need througout our program:
 */

/**
 * It is often necessary to store directions or to iterate
 * over directions. These definitions come quite handy:
 */
export type Direction = "up" | "right" | "down" | "left";

export const DirectionMap: { [direction: string]: { dx: number, dy: number } } =
{
    "left": { dx: -1, dy: 0 },
    "right": { dx: 1, dy: 0 },
    "up": { dx: 0, dy: -1 },
    "down": { dx: 0, dy: 1 }
};

export const Directions: Direction[] = ["up", "right", "down", "left"];

/**
 * Phaser tries to achieve 60 frames per second. 
 * We have to slow down movements to a given amount of steps per second:
 */
export const framesPerStep: number = 9;
export const stepDurationInMs: number = 1000.0 / 60 * framesPerStep;

export const gameWidth: number = 1920 / 2;
export const gameHeight: number = 1080 / 2;