import { stepDurationInMs } from "../mainscene/Globals.js";
import { MainScene } from "../mainscene/MainScene.js";
import { ScoreBoard } from "./ScoreBoard.js";

/**
 * This scene displays score, number of gems to collect, lives, ...
 * It is visible whenever MainScene is visible and doesn't scroll with MainScene
 * as it has it's own camera.
 */
export class ScoreScene extends Phaser.Scene {

    scoreboard: ScoreBoard;

    constructor(){
        super({
            key: "ScoreScene"
        });
    }

    preload(){
        this.load.atlas('spritesheet1', 'assets/graphics/spritesheet.png', 'assets/graphics/spritesheet.json');    

    }

    create(){

        this.scoreboard = new ScoreBoard(this);
        let mainScene: MainScene = <MainScene>this.scene.get("MainScene");

        /**
         * callback MainScene so that it can show first level
         */
        mainScene.onScoreSceneReady();

    }

    update(time: number, delta: number){
       
    }

    getScoreBoard(){
        return this.scoreboard;
    }

    /**
     * Each time the player collects a gem it "flys" to top-left screen corner.
     * This movement must not be affected by scrolling camera of main scene and has to be 
     * on top of all mainscene-tiles, therefore we instantiate the flying gem in this scene.
     * @param x 
     * @param y 
     * @param callback 
     */
    animatePlayerCollectingGem(x: number, y: number, callback: (points: number) => void){
        let flyingGem = this.add.sprite(x, y, "spritesheet1", "Boulder#4");

        this.tweens.add({
            targets: flyingGem,
            alpha: 0.8,
            x: this.scoreboard.gem.x,
            y: this.scoreboard.gem.y,
            scale: 0.5,
            duration: stepDurationInMs * 4,
            onComplete: () => {
                flyingGem.destroy();
                this.scoreboard.removeGems(1);
                callback(this.scoreboard.gems);
            }
        })

    }

}