import { Tile } from "./Tile.js";
import { DirectionMap, Directions, framesPerStep, stepDurationInMs } from "./Globals.js";
/**
 * Moving Enemy
 */
export class Enemy1 extends Tile {
    constructor(mainScene, column, row, level) {
        super(mainScene, column, row, "enemy1", level);
        this.mainScene = mainScene;
        this.column = column;
        this.row = row;
        this.level = level;
        this.currentDirection = "down"; // direction, in which enemy moves currently
        /**
         * Store, after how many frames this objects moves again:
         */
        this.frameNumber = framesPerStep;
        // This makes scene.update call the update-method of this class each 1/60 s.
        // Beware: Don't forget to remove Listener when this object gets destroyed!
        this.scene.events.addListener('update', this.update, this);
    }
    update() {
        this.frameNumber--;
        if (this.frameNumber <= 0) {
            this.frameNumber = framesPerStep;
            let i = 0;
            let currentDirectionIndex = Directions.indexOf(this.currentDirection);
            /**
             * Look at all four directions relative to currentDirection in this order:
             */
            let prios = [-1, 0, 1, 2];
            while (i < 4) {
                let newDirection = Directions[(currentDirectionIndex + prios[i] + 4) % 4];
                let tile = this.getTile(newDirection);
                if (tile == null) {
                    let directionMapEntry = DirectionMap[newDirection];
                    this.goTo(this.column + directionMapEntry.dx, this.row + directionMapEntry.dy);
                    this.currentDirection = newDirection;
                    break;
                }
                else if (tile.kind == "player") {
                    this.mainScene.gameOver();
                    break;
                }
                i++;
            }
        }
    }
    getTile(direction) {
        let directionMapEntry = DirectionMap[direction];
        return this.level.tiles[this.column + directionMapEntry.dx][this.row + directionMapEntry.dy];
    }
    destroyTile(tile) {
        this.scene.tweens.add({
            targets: tile,
            alpha: 0,
            duration: stepDurationInMs,
            onComplete: () => {
                tile.destroy();
            }
        });
    }
    destroy() {
        this.scene.events.removeListener('update', this.update);
        super.destroy();
    }
}
//# sourceMappingURL=Enemy1.js.map