/**
 * Global types and values we need througout our program:
 */
export const DirectionMap = {
    "left": { dx: -1, dy: 0 },
    "right": { dx: 1, dy: 0 },
    "up": { dx: 0, dy: -1 },
    "down": { dx: 0, dy: 1 }
};
export const Directions = ["up", "right", "down", "left"];
/**
 * Phaser tries to achieve 60 frames per second.
 * We have to slow down movements to a given amount of steps per second:
 */
export const framesPerStep = 9;
export const stepDurationInMs = 1000.0 / 60 * framesPerStep;
export const gameWidth = 1920 / 2;
export const gameHeight = 1080 / 2;
//# sourceMappingURL=Globals.js.map