export class ScoreBoard {
    constructor(scene) {
        this.scene = scene;
        this.objects = [];
        this.background = scene.add.rectangle(5 + 32, 5 + 16, 400, 30, 0x808080, 0.4);
        this.score = scene.add.text(8, 8, "12345", { color: "#ffff00", fontSize: "32px", fontFamily: "sans-serif" });
        this.objects = [this.background, this.score];
        this.objects.forEach(obj => obj.setScrollFactor(0));
        this.camera = scene.cameras.add(0, 0);
    }
    bringToFront() {
        this.objects.forEach((obj) => { this.scene.children.bringToTop(obj); });
    }
    destroy() {
        this.objects.forEach((obj) => { obj.destroy(); });
    }
}
//# sourceMappingURL=ScoreBoard.js.map