import { GameOverScene } from "./gameoverscene/GameOverScene.js";
import { gameHeight, gameWidth } from "./mainscene/Globals.js";
import { MainScene } from "./mainscene/MainScene.js";
import { ScoreScene } from "./scorescene/ScoreScene.js";
import { StartScene } from "./startscene/StartScene.js";

// Game config, see https://photonstorm.github.io/phaser3-docs/Phaser.Types.Core.html#.GameConfig
var config: Phaser.Types.Core.GameConfig = {
    type: Phaser.AUTO,
    scale: {
        mode: Phaser.Scale.FIT,
        parent: 'game',
        autoCenter: Phaser.Scale.CENTER_BOTH,
        width: gameWidth,
        height: gameHeight
    },
    antialias: false,
    scene: [
        new StartScene(),
         new MainScene(),
         new ScoreScene(),
         new GameOverScene()
    ],
    physics: {
        default: "arcade",
        arcade: {
            debug: false
        }
    },
    input: {
        gamepad: true
    }

};

new Phaser.Game(config);
