var SPACE = 0x00;
var DIRT = 0x01;
var BRICK = 0x02;
var MAGIC = 0x03;
var STEEL = 0x07;
var FIREFLY = 0x08;
var BOULDER = 0x10;
var DIAMOND = 0x14;
var BUTTERFLY = 0x30;
var ROCKFORD = 0x38;
var AMOEBA = 0x3A;

function convertToString(a) {
  let map = {
    0x00: " ", 0x01: "s", 0x02: "w", 0x03: "m", 0x07: "e", 0x08: "f",
    0x10: "b", 0x14: "g", 0x30: "F", 0x38: "r", 0x3a: "a", 0x04: "d", 37: "r"
  };

  let s = "let leveldata: string[] = [\n";
  for (let row = 0; row < a[0].length; row++) {
    s += '                 "';
    for (let column = 0; column < a.length; column++) {
      let c = map[a[column][row]];
      if(c != null){
        s += c;
      } else {
        s += "X";
      }
    }
    s += '"' + (row < a[0].length - 1 ? ',\n' : '');
  }
  return s + "];";
}


var CAVES = function () { // ported from c version available at http://www.bd-fans.com/Files/FanStuff/Programming/decodecaves.c

  var DIR = { UP: 0, UPRIGHT: 1, RIGHT: 2, DOWNRIGHT: 3, DOWN: 4, DOWNLEFT: 5, LEFT: 6, UPLEFT: 7 };

  var SPACE = 0x00;
  var DIRT = 0x01;
  var BRICK = 0x02;
  var MAGIC = 0x03;
  var STEEL = 0x07;
  var FIREFLY = 0x08;
  var BOULDER = 0x10;
  var DIAMOND = 0x14;
  var BUTTERFLY = 0x30;
  var ROCKFORD = 0x38;
  var AMOEBA = 0x3A;


  var COLORS = { // converted c64 colors - see http://en.wikipedia.org/wiki/List_of_8-bit_computer_hardware_palettes#C-64
    BLACK: { n: 0x00, rgb: 0x000000 },
    WHITE: { n: 0x01, rgb: 0xFFFFFF },
    RED: { n: 0x02, rgb: 0x984B43 },
    CYAN: { n: 0x03, rgb: 0x79C1C8 },
    PURPLE: { n: 0x04, rgb: 0x9B51A5 },
    GREEN: { n: 0x05, rgb: 0x68AE5C },
    BLUE: { n: 0x06, rgb: 0x52429D },
    YELLOW: { n: 0x07, rgb: 0xC9D684 },
    ORANGE: { n: 0x08, rgb: 0x9B6739 },
    BROWN: { n: 0x09, rgb: 0x6A5400 },
    LIGHTRED: { n: 0x0A, rgb: 0xC37B75 },
    DARKGRAY: { n: 0x0B, rgb: 0x636363 },
    GRAY: { n: 0x0C, rgb: 0x8A8A8A },
    LIGHTGREEN: { n: 0x0D, rgb: 0xA3E599 },
    LIGHTBLUE: { n: 0x0E, rgb: 0x8A7BCE },
    LIGHTGRAY: { n: 0x0F, rgb: 0xADADAD }
  }
  for (var name in COLORS)
    COLORS[COLORS[name].n] = COLORS[name]; // allow lookup by either index or name

  var DATA = [
    [0x01, 0x14, 0x0A, 0x0F, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x96, 0x6E, 0x46, 0x28, 0x1E, 0x08, 0x0B, 0x09, 0xD4, 0x20, 0x00, 0x10, 0x14, 0x00, 0x3C, 0x32, 0x09, 0x00, 0x42, 0x01, 0x09, 0x1E, 0x02, 0x42, 0x09, 0x10, 0x1E, 0x02, 0x25, 0x03, 0x04, 0x04, 0x26, 0x12, 0xFF],
    [0x02, 0x14, 0x14, 0x32, 0x03, 0x00, 0x01, 0x57, 0x58, 0x0A, 0x0C, 0x09, 0x0D, 0x0A, 0x96, 0x6E, 0x46, 0x46, 0x46, 0x0A, 0x04, 0x09, 0x00, 0x00, 0x00, 0x10, 0x14, 0x08, 0x3C, 0x32, 0x09, 0x02, 0x42, 0x01, 0x08, 0x26, 0x02, 0x42, 0x01, 0x0F, 0x26, 0x02, 0x42, 0x08, 0x03, 0x14, 0x04, 0x42, 0x10, 0x03, 0x14, 0x04, 0x42, 0x18, 0x03, 0x14, 0x04, 0x42, 0x20, 0x03, 0x14, 0x04, 0x40, 0x01, 0x05, 0x26, 0x02, 0x40, 0x01, 0x0B, 0x26, 0x02, 0x40, 0x01, 0x12, 0x26, 0x02, 0x40, 0x14, 0x03, 0x14, 0x04, 0x25, 0x12, 0x15, 0x04, 0x12, 0x16, 0xFF],
    [0x03, 0x00, 0x0F, 0x00, 0x00, 0x32, 0x36, 0x34, 0x37, 0x18, 0x17, 0x18, 0x17, 0x15, 0x96, 0x64, 0x5A, 0x50, 0x46, 0x09, 0x08, 0x09, 0x04, 0x00, 0x02, 0x10, 0x14, 0x00, 0x64, 0x32, 0x09, 0x00, 0x25, 0x03, 0x04, 0x04, 0x27, 0x14, 0xFF],
    [0x04, 0x14, 0x05, 0x14, 0x00, 0x6E, 0x70, 0x73, 0x77, 0x24, 0x24, 0x24, 0x24, 0x24, 0x78, 0x64, 0x50, 0x3C, 0x32, 0x04, 0x08, 0x09, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x25, 0x01, 0x03, 0x04, 0x26, 0x16, 0x81, 0x08, 0x0A, 0x04, 0x04, 0x00, 0x30, 0x0A, 0x0B, 0x81, 0x10, 0x0A, 0x04, 0x04, 0x00, 0x30, 0x12, 0x0B, 0x81, 0x18, 0x0A, 0x04, 0x04, 0x00, 0x30, 0x1A, 0x0B, 0x81, 0x20, 0x0A, 0x04, 0x04, 0x00, 0x30, 0x22, 0x0B, 0xFF],
    [0x05, 0x14, 0x32, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x05, 0x06, 0x07, 0x08, 0x96, 0x78, 0x5A, 0x3C, 0x1E, 0x09, 0x0A, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x01, 0x03, 0x04, 0x27, 0x16, 0x80, 0x08, 0x0A, 0x03, 0x03, 0x00, 0x80, 0x10, 0x0A, 0x03, 0x03, 0x00, 0x80, 0x18, 0x0A, 0x03, 0x03, 0x00, 0x80, 0x20, 0x0A, 0x03, 0x03, 0x00, 0x14, 0x09, 0x0C, 0x08, 0x0A, 0x0A, 0x14, 0x11, 0x0C, 0x08, 0x12, 0x0A, 0x14, 0x19, 0x0C, 0x08, 0x1A, 0x0A, 0x14, 0x21, 0x0C, 0x08, 0x22, 0x0A, 0x80, 0x08, 0x10, 0x03, 0x03, 0x00, 0x80, 0x10, 0x10, 0x03, 0x03, 0x00, 0x80, 0x18, 0x10, 0x03, 0x03, 0x00, 0x80, 0x20, 0x10, 0x03, 0x03, 0x00, 0x14, 0x09, 0x12, 0x08, 0x0A, 0x10, 0x14, 0x11, 0x12, 0x08, 0x12, 0x10, 0x14, 0x19, 0x12, 0x08, 0x1A, 0x10, 0x14, 0x21, 0x12, 0x08, 0x22, 0x10, 0xFF],
    [0x06, 0x14, 0x28, 0x3C, 0x00, 0x14, 0x15, 0x16, 0x17, 0x04, 0x06, 0x07, 0x08, 0x08, 0x96, 0x78, 0x64, 0x5A, 0x50, 0x0E, 0x0A, 0x09, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x82, 0x01, 0x03, 0x0A, 0x04, 0x00, 0x82, 0x01, 0x06, 0x0A, 0x04, 0x00, 0x82, 0x01, 0x09, 0x0A, 0x04, 0x00, 0x82, 0x01, 0x0C, 0x0A, 0x04, 0x00, 0x41, 0x0A, 0x03, 0x0D, 0x04, 0x14, 0x03, 0x05, 0x08, 0x04, 0x05, 0x14, 0x03, 0x08, 0x08, 0x04, 0x08, 0x14, 0x03, 0x0B, 0x08, 0x04, 0x0B, 0x14, 0x03, 0x0E, 0x08, 0x04, 0x0E, 0x82, 0x1D, 0x03, 0x0A, 0x04, 0x00, 0x82, 0x1D, 0x06, 0x0A, 0x04, 0x00, 0x82, 0x1D, 0x09, 0x0A, 0x04, 0x00, 0x82, 0x1D, 0x0C, 0x0A, 0x04, 0x00, 0x41, 0x1D, 0x03, 0x0D, 0x04, 0x14, 0x24, 0x05, 0x08, 0x23, 0x05, 0x14, 0x24, 0x08, 0x08, 0x23, 0x08, 0x14, 0x24, 0x0B, 0x08, 0x23, 0x0B, 0x14, 0x24, 0x0E, 0x08, 0x23, 0x0E, 0x25, 0x03, 0x14, 0x04, 0x26, 0x14, 0xFF],
    [0x07, 0x4B, 0x0A, 0x14, 0x02, 0x07, 0x08, 0x0A, 0x09, 0x0F, 0x14, 0x19, 0x19, 0x19, 0x78, 0x78, 0x78, 0x78, 0x78, 0x09, 0x0A, 0x0D, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x64, 0x28, 0x02, 0x00, 0x42, 0x01, 0x07, 0x0C, 0x02, 0x42, 0x1C, 0x05, 0x0B, 0x02, 0x7A, 0x13, 0x15, 0x02, 0x02, 0x14, 0x04, 0x06, 0x14, 0x04, 0x0E, 0x14, 0x04, 0x16, 0x14, 0x22, 0x04, 0x14, 0x22, 0x0C, 0x14, 0x22, 0x16, 0x25, 0x14, 0x03, 0x04, 0x27, 0x07, 0xFF],
    [0x08, 0x14, 0x0A, 0x14, 0x01, 0x03, 0x04, 0x05, 0x06, 0x0A, 0x0F, 0x14, 0x14, 0x14, 0x78, 0x6E, 0x64, 0x5A, 0x50, 0x02, 0x0E, 0x09, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x5A, 0x32, 0x02, 0x00, 0x14, 0x04, 0x06, 0x14, 0x22, 0x04, 0x14, 0x22, 0x0C, 0x04, 0x00, 0x05, 0x25, 0x14, 0x03, 0x42, 0x01, 0x07, 0x0C, 0x02, 0x42, 0x01, 0x0F, 0x0C, 0x02, 0x42, 0x1C, 0x05, 0x0B, 0x02, 0x42, 0x1C, 0x0D, 0x0B, 0x02, 0x43, 0x0E, 0x11, 0x08, 0x02, 0x14, 0x0C, 0x10, 0x00, 0x0E, 0x12, 0x14, 0x13, 0x12, 0x41, 0x0E, 0x0F, 0x08, 0x02, 0xFF],
    [0x09, 0x14, 0x05, 0x0A, 0x64, 0x89, 0x8C, 0xFB, 0x33, 0x4B, 0x4B, 0x50, 0x55, 0x5A, 0x96, 0x96, 0x82, 0x82, 0x78, 0x08, 0x04, 0x09, 0x00, 0x00, 0x10, 0x14, 0x00, 0x00, 0xF0, 0x78, 0x00, 0x00, 0x82, 0x05, 0x0A, 0x0D, 0x0D, 0x00, 0x01, 0x0C, 0x0A, 0x82, 0x19, 0x0A, 0x0D, 0x0D, 0x00, 0x01, 0x1F, 0x0A, 0x42, 0x11, 0x12, 0x09, 0x02, 0x40, 0x11, 0x13, 0x09, 0x02, 0x25, 0x07, 0x0C, 0x04, 0x08, 0x0C, 0xFF],
    [0x0A, 0x14, 0x19, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x96, 0x82, 0x78, 0x6E, 0x64, 0x06, 0x08, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x0D, 0x03, 0x04, 0x27, 0x16, 0x54, 0x05, 0x04, 0x11, 0x03, 0x54, 0x15, 0x04, 0x11, 0x05, 0x80, 0x05, 0x0B, 0x11, 0x03, 0x08, 0xC2, 0x01, 0x04, 0x15, 0x11, 0x00, 0x0D, 0x04, 0xC2, 0x07, 0x06, 0x0D, 0x0D, 0x00, 0x0D, 0x06, 0xC2, 0x09, 0x08, 0x09, 0x09, 0x00, 0x0D, 0x08, 0xC2, 0x0B, 0x0A, 0x05, 0x05, 0x00, 0x0D, 0x0A, 0x82, 0x03, 0x06, 0x03, 0x0F, 0x08, 0x00, 0x04, 0x06, 0x54, 0x04, 0x10, 0x04, 0x04, 0xFF],
    [0x0B, 0x14, 0x32, 0x00, 0x00, 0x04, 0x66, 0x97, 0x64, 0x06, 0x06, 0x06, 0x06, 0x06, 0x78, 0x78, 0x96, 0x96, 0xF0, 0x0B, 0x08, 0x09, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x64, 0x50, 0x02, 0x00, 0x42, 0x0A, 0x03, 0x09, 0x04, 0x42, 0x14, 0x03, 0x09, 0x04, 0x42, 0x1E, 0x03, 0x09, 0x04, 0x42, 0x09, 0x16, 0x09, 0x00, 0x42, 0x0C, 0x0F, 0x11, 0x02, 0x42, 0x05, 0x0B, 0x09, 0x02, 0x42, 0x0F, 0x0B, 0x09, 0x02, 0x42, 0x19, 0x0B, 0x09, 0x02, 0x42, 0x1C, 0x13, 0x0B, 0x01, 0x14, 0x04, 0x03, 0x14, 0x0E, 0x03, 0x14, 0x18, 0x03, 0x14, 0x22, 0x03, 0x14, 0x04, 0x16, 0x14, 0x23, 0x15, 0x25, 0x14, 0x14, 0x04, 0x26, 0x11, 0xFF],
    [0x0C, 0x14, 0x14, 0x00, 0x00, 0x3C, 0x02, 0x3B, 0x66, 0x13, 0x13, 0x0E, 0x10, 0x15, 0xB4, 0xAA, 0xA0, 0xA0, 0xA0, 0x0C, 0x0A, 0x09, 0x00, 0x00, 0x00, 0x10, 0x14, 0x00, 0x3C, 0x32, 0x09, 0x00, 0x42, 0x0A, 0x05, 0x12, 0x04, 0x42, 0x0E, 0x05, 0x12, 0x04, 0x42, 0x12, 0x05, 0x12, 0x04, 0x42, 0x16, 0x05, 0x12, 0x04, 0x42, 0x02, 0x06, 0x0B, 0x02, 0x42, 0x02, 0x0A, 0x0B, 0x02, 0x42, 0x02, 0x0E, 0x0F, 0x02, 0x42, 0x02, 0x12, 0x0B, 0x02, 0x81, 0x1E, 0x04, 0x04, 0x04, 0x00, 0x08, 0x20, 0x05, 0x81, 0x1E, 0x09, 0x04, 0x04, 0x00, 0x08, 0x20, 0x0A, 0x81, 0x1E, 0x0E, 0x04, 0x04, 0x00, 0x08, 0x20, 0x0F, 0x25, 0x03, 0x14, 0x04, 0x27, 0x16, 0xFF],
    [0x0D, 0x8C, 0x05, 0x08, 0x00, 0x01, 0x02, 0x03, 0x04, 0x32, 0x37, 0x3C, 0x46, 0x50, 0xA0, 0x9B, 0x96, 0x91, 0x8C, 0x06, 0x08, 0x0D, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x25, 0x12, 0x03, 0x04, 0x0A, 0x03, 0x3A, 0x14, 0x03, 0x42, 0x05, 0x12, 0x1E, 0x02, 0x70, 0x05, 0x13, 0x1E, 0x02, 0x50, 0x05, 0x14, 0x1E, 0x02, 0xC1, 0x05, 0x15, 0x1E, 0x02, 0xFF],
    [0x0E, 0x14, 0x0A, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x23, 0x28, 0x2A, 0x2D, 0x96, 0x91, 0x8C, 0x87, 0x82, 0x0C, 0x08, 0x09, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x0A, 0x0A, 0x0D, 0x0D, 0x00, 0x70, 0x0B, 0x0B, 0x0C, 0x03, 0xC1, 0x0C, 0x0A, 0x03, 0x0D, 0xC1, 0x10, 0x0A, 0x03, 0x0D, 0xC1, 0x14, 0x0A, 0x03, 0x0D, 0x50, 0x16, 0x08, 0x0C, 0x02, 0x48, 0x16, 0x07, 0x0C, 0x02, 0xC1, 0x17, 0x06, 0x03, 0x04, 0xC1, 0x1B, 0x06, 0x03, 0x04, 0xC1, 0x1F, 0x06, 0x03, 0x04, 0x25, 0x03, 0x03, 0x04, 0x27, 0x14, 0xFF],
    [0x0F, 0x08, 0x0A, 0x14, 0x01, 0x1D, 0x1E, 0x1F, 0x20, 0x0F, 0x14, 0x14, 0x19, 0x1E, 0x78, 0x78, 0x78, 0x78, 0x8C, 0x08, 0x0E, 0x09, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x64, 0x50, 0x02, 0x00, 0x42, 0x02, 0x04, 0x0A, 0x03, 0x42, 0x0F, 0x0D, 0x0A, 0x01, 0x41, 0x0C, 0x0E, 0x03, 0x02, 0x43, 0x0C, 0x0F, 0x03, 0x02, 0x04, 0x14, 0x16, 0x25, 0x14, 0x03, 0xFF],
    [0x10, 0x14, 0x0A, 0x14, 0x01, 0x78, 0x81, 0x7E, 0x7B, 0x0C, 0x0F, 0x0F, 0x0F, 0x0C, 0x96, 0x96, 0x96, 0x96, 0x96, 0x09, 0x0A, 0x09, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x25, 0x01, 0x03, 0x04, 0x27, 0x04, 0x81, 0x08, 0x13, 0x04, 0x04, 0x00, 0x08, 0x0A, 0x14, 0xC2, 0x07, 0x0A, 0x06, 0x08, 0x43, 0x07, 0x0A, 0x06, 0x02, 0x81, 0x10, 0x13, 0x04, 0x04, 0x00, 0x08, 0x12, 0x14, 0xC2, 0x0F, 0x0A, 0x06, 0x08, 0x43, 0x0F, 0x0A, 0x06, 0x02, 0x81, 0x18, 0x13, 0x04, 0x04, 0x00, 0x08, 0x1A, 0x14, 0x81, 0x20, 0x13, 0x04, 0x04, 0x00, 0x08, 0x22, 0x14, 0xFF],
    [0x11, 0x14, 0x1E, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0E, 0x02, 0x09, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0xFF, 0x09, 0x00, 0x00, 0x87, 0x00, 0x02, 0x28, 0x16, 0x07, 0x87, 0x00, 0x02, 0x14, 0x0C, 0x00, 0x32, 0x0A, 0x0C, 0x10, 0x0A, 0x04, 0x01, 0x0A, 0x05, 0x25, 0x03, 0x05, 0x04, 0x12, 0x0C, 0xFF],
    [0x12, 0x14, 0x0A, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x06, 0x0F, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0x00, 0x02, 0x28, 0x16, 0x07, 0x87, 0x00, 0x02, 0x14, 0x0C, 0x01, 0x50, 0x01, 0x03, 0x09, 0x03, 0x48, 0x02, 0x03, 0x08, 0x03, 0x54, 0x01, 0x05, 0x08, 0x03, 0x50, 0x01, 0x06, 0x07, 0x03, 0x50, 0x12, 0x03, 0x09, 0x05, 0x54, 0x12, 0x05, 0x08, 0x05, 0x50, 0x12, 0x06, 0x07, 0x05, 0x25, 0x01, 0x04, 0x04, 0x12, 0x04, 0xFF],
    [0x13, 0x04, 0x0A, 0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x14, 0x14, 0x14, 0x14, 0x14, 0x06, 0x08, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0x00, 0x02, 0x28, 0x16, 0x07, 0x87, 0x00, 0x02, 0x14, 0x0C, 0x00, 0x54, 0x01, 0x0C, 0x12, 0x02, 0x88, 0x0F, 0x09, 0x04, 0x04, 0x08, 0x25, 0x08, 0x03, 0x04, 0x12, 0x07, 0xFF],
    [0x14, 0x03, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x14, 0x14, 0x14, 0x14, 0x14, 0x06, 0x08, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0x00, 0x02, 0x28, 0x16, 0x07, 0x87, 0x00, 0x02, 0x14, 0x0C, 0x01, 0xD0, 0x0B, 0x03, 0x03, 0x02, 0x80, 0x0B, 0x07, 0x03, 0x06, 0x00, 0x43, 0x0B, 0x06, 0x03, 0x02, 0x43, 0x0B, 0x0A, 0x03, 0x02, 0x50, 0x08, 0x07, 0x03, 0x03, 0x25, 0x03, 0x03, 0x04, 0x09, 0x0A, 0xFF]
  ]

  var NAMES = [
    "Intro", "Rooms", "Maze", "Butterflies",
    "Guards", "Firefly dens", "Amoeba", "Enchanted wall",
    "Greed", "Tracks", "Crowd", "Walls",
    "Apocalypse", "Zigzag", "Funnel", "Enchanted boxes",
    "Interval 1", "Interval 2", "Interval 3", "Interval 4",
  ]

  var DESCRIPTIONS = [
    "Pick up jewels and exit before time is up",
    "Pick up jewels, but you must move boulders to get all jewels",
    "Pick up jewels. You must get every jewel to exit",
    "Drop boulders on butterflies to create jewels",
    "The jewels are there for grabbing, but they are guarded by the deadly fireflies",
    "Each firefly is guarding a jewel",
    "Surround the amoeba with boulders. Pick up jewels when it suffocates",
    "Activate the enchanted wall and create as many jewels as you can",
    "You have to get a lot of jewels here, lucky there are so many",
    "Get the jewels, avoid the fireflies",
    "You must move a lot of boulders around in some tight spaces",
    "Drop a boulder on a firefly at the right time to blast through walls",
    "Bring the butterflies and amoeba together and watch the jewels fly",
    "Magically transform the butterflies into jewels, but don't waste any boulders",
    "There is an enchanted wall at the bottom of the rock tunnel",
    "The top of each room is an enchanted wall, but you'll have to blast your way inside",
    "Interval 1",
    "Interval 2",
    "Interval 3",
    "Interval 4"
  ]

  function assert(condition, msg) {
    if (!condition)
      throw msg;
  };

  function decodeCave(cave) {
    var n, x, y, seeds, object, kind, prob, index = cave[0x00];
    assert(cave.length > 0x20, 'cave is too short');
    var result = {
      index: index - 1,
      name: NAMES[index - 1],
      description: DESCRIPTIONS[index - 1],
      width: 40, // all caves in BD1 were 40x22
      height: 22, // all caves in BD1 were 40x22 
      magicWallMillingTime: cave[0x01],
      amoebaSlowGrowthTime: cave[0x01], // same as magicWallMillingTime
      initialDiamondValue: cave[0x02],
      extraDiamondValue: cave[0x03],
      randomSeed: cave[0x04], // at other difficulty levels: cave[0x05], cave[0x06], cave[0x07], cave[0x08]],
      diamondsNeeded: cave[0x09], // at other difficulty levels: cave[0x0A], cave[0x0B], cave[0x0C], cave[0x0D]],
      caveTime: cave[0x0E], // at other difficulty levels: cave[0x0F], cave[0x10], cave[0x11], cave[0x12]],
      color1: COLORS[cave[0x13]].rgb,
      color2: COLORS[cave[0x14]].rgb,
      randomObjects: [cave[0x18], cave[0x19], cave[0x1A], cave[0x1B]],
      randomObjectProb: [cave[0x1C], cave[0x1D], cave[0x1E], cave[0x1F]],
      amoebaMaxSize: 200, // hard coded for a 40x22 cave (based on c64 version)
      map: []
    };

    seeds = [0, result.randomSeed];

    for (y = 0; y < result.height; ++y)
      for (x = 0; x < result.width; ++x)
        drawSingleObject(result, SPACE, x, y);

    for (y = 1; y < result.height - 1; ++y) {
      for (x = 0; x < result.width; ++x) {
        object = DIRT;
        bdrandom(seeds);
        for (n = 0; n < result.randomObjects.length; ++n)
          if (seeds[0] < result.randomObjectProb[n])
            object = result.randomObjects[n];
        drawSingleObject(result, object, x, y);
      }
    }

    drawRect(result, STEEL, 0, 0, result.width, result.height);

    n = 0x20;
    while ((n < cave.length) && (cave[n] < 0xFF)) {
      object = (cave[n] & 0x3F);       //  low 6 bits
      kind = (cave[n] & 0xC0) >> 6;  // high 2 bits
      n++;
      x = cave[n++];
      y = cave[n++] - 2; // raw data assumes top 2 lines are for displaying scores
      switch (kind) {
        case 0: drawSingleObject(result, object, x, y); break;
        case 1: drawLine(result, object, x, y, cave[n++], cave[n++]); break;
        case 2: drawFilledRect(result, object, x, y, cave[n++], cave[n++], cave[n++]); break;
        case 3: drawRect(result, object, x, y, cave[n++], cave[n++]); break;
        default:
          assert(false, 'unexpected kind' + kind);
      }
    }

    return result;
  }

  function drawSingleObject(result, object, x, y) {
    result.map[x] = result.map[x] || [];
    result.map[x][y] = object;
  }

  function drawLine(result, object, x, y, length, dir) {
    var dx = [0, 1, 1, 1, 0, -1, -1, -1][dir],
      dy = [-1, -1, 0, 1, 1, 1, 0, -1][dir];
    for (var n = 0; n < length; n++) {
      drawSingleObject(result, object, x, y);
      x += dx;
      y += dy;
    }
  }

  function drawFilledRect(result, object, x, y, width, height, fill) {
    drawRect(result, object, x, y, width, height);
    var minx = x + 1, maxx = x + width - 1,
      miny = y + 1, maxy = y + height - 1;
    for (x = minx; x < maxx; x++)
      for (y = miny; y < maxy; y++)
        drawSingleObject(result, fill, x, y);
  }

  function drawRect(result, object, x, y, width, height) {
    drawLine(result, object, x, y, width, DIR.RIGHT);
    drawLine(result, object, x, y + height - 1, width, DIR.RIGHT);
    drawLine(result, object, x, y, height, DIR.DOWN);
    drawLine(result, object, x + width - 1, y, height, DIR.DOWN);
  }

  function bdrandom(seeds) {   // ported from c version that was ported from original C64 6510 assembler - see http://www.bd-fans.com/Files/FanStuff/Programming/decodecaves.c
    var tmp1, tmp2, carry, result;

    assert(seeds.length === 2, 'expected 2 seed numbers');
    assert((seeds[0] >= 0) && (seeds[0] <= 0xFF), 'expected seed 0 to be between 0 and 0xFF');
    assert((seeds[1] >= 0) && (seeds[1] <= 0xFF), 'expected seed 1 to be between 0 and 0xFF');

    tmp1 = (seeds[0] & 0x0001) * 0x0080;
    tmp2 = (seeds[1] >> 1) & 0x007F;

    result = seeds[1] + (seeds[1] & 0x0001) * 0x0080;
    carry = (result > 0x00FF);
    result = result & 0x00FF;
    result = result + carry + 0x13;
    carry = (result > 0x00FF);
    seeds[1] = result & 0x00FF;
    result = seeds[0] + carry + tmp1;
    carry = (result > 0x00FF);
    result = result & 0x00FF;
    result = result + carry + tmp2;
    seeds[0] = result & 0x00FF;

    assert((seeds[0] >= 0) && (seeds[0] <= 0xFF), 'expected seed 0 to STILL be between 0 and 0xFF');
    assert((seeds[1] >= 0) && (seeds[1] <= 0xFF), 'expected seed 0 to STILL be between 0 and 0xFF');
  }

  var caves = [];
  for (var n = 0; n < DATA.length; n++)
    caves.push(decodeCave(DATA[n]));

  return caves;

}();

for(let i = 0; i < CAVES.length; i++){
  console.log(convertToString(CAVES[i].map));
}