import { Tile } from "./Tile.js";
import { DirectionMap, Directions, framesPerStep, stepDurationInMs } from "./Globals.js";
/**
 * Comments: See Enemy1
 */
export class Enemy2 extends Tile {
    constructor(mainScene, column, row, level) {
        super(mainScene, column, row, "enemy2", level);
        this.mainScene = mainScene;
        this.column = column;
        this.row = row;
        this.level = level;
        this.currentDirection = "down";
        this.frameNumber = framesPerStep;
        this.scene.events.addListener('update', this.update, this);
    }
    update() {
        this.frameNumber--;
        if (this.frameNumber <= 0) {
            this.frameNumber = framesPerStep;
            let i = 0;
            let directionIndex = Directions.indexOf(this.currentDirection);
            let deltas = [0, -1, 1, 2];
            while (i < 4) {
                let newDirection = Directions[(directionIndex + deltas[i] + 4) % 4];
                let tile = this.getTile(newDirection);
                if (tile == null) {
                    let directionMapEntry = DirectionMap[newDirection];
                    this.goTo(this.column + directionMapEntry.dx, this.row + directionMapEntry.dy);
                    this.currentDirection = newDirection;
                    break;
                }
                else if (tile.kind == "player") {
                    this.mainScene.gameOver();
                    break;
                }
                i++;
            }
        }
    }
    getTile(direction) {
        let directionMapEntry = DirectionMap[direction];
        return this.level.tiles[this.column + directionMapEntry.dx][this.row + directionMapEntry.dy];
    }
    destroyTile(tile) {
        this.scene.tweens.add({
            targets: tile,
            alpha: 0,
            duration: stepDurationInMs,
            onComplete: () => {
                tile.destroy();
            }
        });
    }
    destroy() {
        this.scene.events.removeListener('update', this.update);
        super.destroy();
    }
}
//# sourceMappingURL=Enemy2.js.map