import { WebSocketController } from "./WebSocketController.js";
export class MainScene extends Phaser.Scene {
    constructor() {
        super({
            key: "MainScene"
        });
        this.otherPlayers = [];
        this.idToClientDataMap = new Map();
    }
    init(params) {
    }
    preload() {
    }
    create() {
        let color = Phaser.Display.Color.RandomRGB(128).color;
        this.ownData = this.createPlayer(400, 300, color, -1);
        this.cursors = this.input.keyboard.createCursorKeys();
        this.webSocketController = new WebSocketController(this, (controller) => {
            let message = {
                type: "newClient",
                x: this.ownData.x,
                y: this.ownData.y,
                color: this.ownData.color
            };
            controller.send(message);
        });
    }
    createPlayer(x, y, color, id) {
        let circle = new Phaser.Geom.Circle(x, y, 10);
        let graphics = this.add.graphics({ fillStyle: { color: color } });
        graphics.fillCircleShape(circle);
        return {
            color: color,
            x: x,
            y: y,
            graphicObject: graphics,
            id: id
        };
    }
    update(time, delta) {
        let oldX = this.ownData.x;
        let oldY = this.ownData.y;
        let d = 10;
        if (this.cursors.left.isDown) {
            this.ownData.x -= d;
        }
        else if (this.cursors.right.isDown) {
            this.ownData.x += d;
        }
        if (this.cursors.up.isDown) {
            this.ownData.y -= d;
        }
        else if (this.cursors.down.isDown) {
            this.ownData.y += d;
        }
        if (this.ownData.x != oldX || this.ownData.y != oldY) {
            this.movePlayer(this.ownData.graphicObject, this.ownData.x - oldX, this.ownData.y - oldY);
            let message = {
                type: "sendCoordinates",
                x: this.ownData.x,
                y: this.ownData.y
            };
            this.webSocketController.send(message);
        }
    }
    movePlayer(graphicObject, dx, dy) {
        graphicObject.setPosition(graphicObject.x + dx, graphicObject.y + dy);
    }
    onMessage(serverMessage) {
        let clientData;
        if (serverMessage.id != null) {
            clientData = this.idToClientDataMap.get(serverMessage.id);
        }
        switch (serverMessage.type) {
            case "newClient":
                clientData = this.createPlayer(serverMessage.x, serverMessage.y, serverMessage.color, serverMessage.id);
                this.otherPlayers.push(clientData);
                this.idToClientDataMap.set(serverMessage.id, clientData);
                break;
            case "sendCoordinates":
                this.movePlayer(clientData.graphicObject, serverMessage.x - clientData.x, serverMessage.y - clientData.y);
                clientData.x = serverMessage.x;
                clientData.y = serverMessage.y;
                break;
            case "clientGone":
                clientData.graphicObject.destroy();
                this.otherPlayers.splice(this.otherPlayers.indexOf(clientData), 1);
                this.idToClientDataMap.delete(clientData.id);
                break;
        }
    }
}
//# sourceMappingURL=MainScene.js.map