// client message types
export type ClientMessage = ClientMessageNewClient | ClientMessageSendCoordinates;

export type ClientMessageNewClient = {
    type: "newClient",
    color: number,
    x: number,
    y: number
}

export type ClientMessageSendCoordinates = {
    type: "sendCoordinates",
    x: number,
    y: number
}



// server message types
export type ServerMessage = ServerMessageNewClient | ServerMessageSendCoordinates | ServerMessageClientGone;

export type ServerMessageNewClient = {
    type: "newClient",
    id: number,
    color: number,
    x: number,
    y: number
}

export type ServerMessageSendCoordinates = {
    type: "sendCoordinates",
    id: number,
    x: number,
    y: number
}

export type ServerMessageClientGone = {
    type: "clientGone",
    id: number
}

