/*
 * Decompiled with CFR 0.152.
 */
package com.stibocatalog;

import com.stibocatalog.HunspellLibrary;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Hunspell {
    private static Hunspell hunspell = null;
    private HunspellLibrary hsl;
    private HashMap<String, Dictionary> map;

    public static Hunspell getInstance() throws Exception {
        return Hunspell.getInstance("data/hunspell");
    }

    public static Hunspell getInstance(String libDir) throws Exception {
        if (hunspell != null) {
            return hunspell;
        }
        hunspell = new Hunspell(libDir);
        return hunspell;
    }

    protected void tryLoad(String libFile) throws UnsupportedOperationException {
        this.hsl = (HunspellLibrary)Native.loadLibrary(libFile, HunspellLibrary.class);
    }

    protected Hunspell(String libDir) throws UnsatisfiedLinkError, UnsupportedOperationException {
        block18: {
            File lib;
            this.hsl = null;
            this.map = new HashMap();
            String libFile = libDir != null ? Hunspell.libName() : Hunspell.libNameBare();
            try {
                this.hsl = (HunspellLibrary)Native.loadLibrary(String.valueOf(libDir) + "/" + libFile, HunspellLibrary.class);
                break block18;
            }
            catch (UnsatisfiedLinkError urgh) {
                libFile = Hunspell.libName();
                InputStream is = Hunspell.class.getResourceAsStream("/" + libDir + "/" + libFile);
                if (is == null) {
                    throw new UnsatisfiedLinkError("Can't find " + libFile + " in the filesystem nor in the classpath\n" + urgh);
                }
                FileOutputStream fos = null;
                try {
                    try {
                        int count;
                        lib = File.createTempFile("jna", "." + libFile);
                        lib.deleteOnExit();
                        fos = new FileOutputStream(lib);
                        byte[] buf = new byte[1024];
                        while ((count = is.read(buf, 0, buf.length)) > 0) {
                            fos.write(buf, 0, count);
                        }
                    }
                    catch (IOException e) {
                        throw new Error("Failed to create temporary file for " + libFile, e);
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            this.hsl = (HunspellLibrary)Native.loadLibrary(lib.getAbsolutePath(), HunspellLibrary.class);
        }
    }

    public static String libName() throws UnsupportedOperationException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            return String.valueOf(Hunspell.libNameBare()) + ".dll";
        }
        if (os.startsWith("mac os x")) {
            return String.valueOf(Hunspell.libNameBare()) + ".jnilib";
        }
        return "lib" + Hunspell.libNameBare() + ".so";
    }

    public static String libNameBare() throws UnsupportedOperationException {
        boolean amd64;
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        boolean x86 = arch.equals("x86") || arch.equals("i386") || arch.equals("i686");
        boolean bl = amd64 = arch.equals("x86_64") || arch.equals("amd64") || arch.equals("ia64n");
        if (os.startsWith("windows")) {
            if (x86) {
                return "hunspell-win32-x86";
            }
        } else if (os.startsWith("mac os x")) {
            if (x86) {
                return "hunspell-darwin-x86-32";
            }
            if (arch.equals("ppc")) {
                return "hunspell-darwin-ppc-32";
            }
        } else if (os.startsWith("linux")) {
            if (x86) {
                return "hunspell-linux-x86-32";
            }
            if (amd64) {
                return "hunspell-linux-x86-64";
            }
        } else {
            os.startsWith("sunos");
        }
        throw new UnsupportedOperationException("Unknown OS/arch: " + os + "/" + arch);
    }

    public Dictionary getDictionary(String baseFileName) throws FileNotFoundException, UnsupportedEncodingException {
        if (this.map.containsKey(baseFileName)) {
            return this.map.get(baseFileName);
        }
        Dictionary d = new Dictionary(baseFileName);
        this.map.put(baseFileName, d);
        return d;
    }

    public void destroyDictionary(String baseFileName) {
        if (this.map.containsKey(baseFileName)) {
            this.map.remove(baseFileName);
        }
    }

    public class Dictionary {
        private Pointer hunspellDict = null;
        private String encoding;

        Dictionary(String baseFileName) throws FileNotFoundException, UnsupportedEncodingException {
            File dic = new File(String.valueOf(baseFileName) + ".dic");
            File aff = new File(String.valueOf(baseFileName) + ".aff");
            if (!dic.canRead() || !aff.canRead()) {
                throw new FileNotFoundException("The dictionary files " + baseFileName + "(.aff|.dic) could not be read");
            }
            this.hunspellDict = Hunspell.this.hsl.Hunspell_create(aff.toString(), dic.toString());
            this.encoding = Hunspell.this.hsl.Hunspell_get_dic_encoding(this.hunspellDict);
            this.stringToBytes("test");
        }

        public void destroy() {
            if (Hunspell.this.hsl != null && this.hunspellDict != null) {
                Hunspell.this.hsl.Hunspell_destroy(this.hunspellDict);
                this.hunspellDict = null;
            }
        }

        public boolean misspelled(String word) {
            try {
                return Hunspell.this.hsl.Hunspell_spell(this.hunspellDict, this.stringToBytes(word)) == 0;
            }
            catch (UnsupportedEncodingException e) {
                return true;
            }
        }

        protected byte[] stringToBytes(String str) throws UnsupportedEncodingException {
            return (String.valueOf(str) + "\u0000").getBytes(this.encoding);
        }

        public List<String> suggest(String word) {
            ArrayList<String> res = new ArrayList<String>();
            try {
                int suggestionsCount = 0;
                PointerByReference suggestions = new PointerByReference();
                suggestionsCount = Hunspell.this.hsl.Hunspell_suggest(this.hunspellDict, suggestions, this.stringToBytes(word));
                Pointer[] pointerArray = suggestions.getValue().getPointerArray(0L, suggestionsCount);
                int i = 0;
                while (i < suggestionsCount) {
                    long len = pointerArray[i].indexOf(0L, (byte)0);
                    if (len != -1L) {
                        if (len > Integer.MAX_VALUE) {
                            throw new RuntimeException("String improperly terminated: " + len);
                        }
                        byte[] data = pointerArray[i].getByteArray(0L, (int)len);
                        res.add(new String(data, this.encoding));
                    }
                    ++i;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return res;
        }
    }
}

