/*
 * Decompiled with CFR 0.152.
 */
package com.stibocatalog;

import com.stibocatalog.Hunspell;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class HunspellMain {
    static JFrame frame;
    static JLabel label;
    static String output;

    private static void println(String msg) {
        if (frame != null) {
            output = String.valueOf(output) + msg + "<br>";
            label.setText("<html>" + output + "</html>");
            frame.pack();
        }
    }

    private static void print(String msg) {
        System.err.print(msg);
        if (frame != null) {
            output = String.valueOf(output) + msg;
            label.setText("<html>" + output + "</html>");
            frame.pack();
        }
    }

    public static void main(String[] args) {
        block11: {
            try {
                if (args.length == 1 && args[0].equals("-libname")) {
                    System.out.println(Hunspell.libName());
                    break block11;
                }
                try {
                    frame = new JFrame("Testing Hunspell");
                    frame.setDefaultCloseOperation(3);
                    label = new JLabel("Output from Hunspell...");
                    output = "";
                    frame.getContentPane().add(label);
                    frame.pack();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    frame = null;
                }
                System.err.println("Loading Hunspell");
                String dir = "";
                if (System.getProperties().containsKey("root")) {
                    dir = System.getProperty("root");
                }
                Hunspell.Dictionary d = Hunspell.getInstance().getDictionary(String.valueOf(dir) + "data/dict/de_DE_frami/de_DE_frami");
                String[] words = new String[]{"Test", "\ufffdrger", "Schiffahrtsamt", "Sch\ufffdler", "Hut", "Gerangel", "grausam", "geht", "ging", "sie", "Sie", "Ohne", "ohne", "sah", "Leo", "Lebenslust", "laut", "Schulfest"};
                int i = 0;
                while (i < words.length) {
                    int j = 0;
                    while (j < 3) {
                        String word = words[i];
                        if (d.misspelled(word)) {
                            HunspellMain.print("misspelled: " + word);
                            Iterator<String> itr = d.suggest(word).iterator();
                            HunspellMain.print("\tTry:");
                            while (itr.hasNext()) {
                                String s = itr.next();
                                HunspellMain.print(" " + s);
                            }
                            HunspellMain.println("");
                        } else {
                            HunspellMain.println("ok: " + word);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                HunspellMain.println("Failed: " + e);
            }
        }
    }
}

