/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.baseclasses.AbstractCommand;
import document.MyDocument;
import document.MyPage;
import document.view.MyView;
import gui.components.pageviewport.PageViewPortController;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import javax.swing.JOptionPane;
import util.language.Lang;

public class AddQuickviewCommand
extends AbstractCommand {
    private MyDocument document;
    private MyView quickView;
    int index;
    int tabIndex;

    public AddQuickviewCommand() {
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        PageViewPortController controller = dTPC.getActivePageScrollPaneController().getPageViewPortController();
        this.document = controller.getDocument();
        if (this.document.getQuickView() == null) {
            this.quickView = this.document.addView();
            this.quickView.setDrawBorderAndShadow(false);
            this.quickView.setAutomaticZoomToFitPage(true);
            MyPage page = new MyPage(21.0, 18.0);
            this.quickView.addPage(page);
            this.quickView.setAutomaticZoomToFitPage(true);
            this.document.getCommandManager().invokeCommand(this);
        } else {
            JOptionPane.showMessageDialog(controller.getPageScrollPaneController().getPageScrollPane(), Lang.get("Es gibt bereits eine Schnelleingabeansicht."));
        }
    }

    @Override
    public final boolean doIt() {
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        MyView oldView = this.document.getViews().get(0);
        this.index = dTPC.getIndexOfView(oldView);
        this.tabIndex = dTPC.getTabIndexOfView(oldView);
        if (this.index < 0) {
            this.index = 0;
        }
        dTPC.insertView(this.quickView, this.index, this.tabIndex);
        dTPC.getTabbedPane().repaint();
        return true;
    }

    @Override
    public final boolean undoIt() {
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        dTPC.removeView(this.quickView);
        dTPC.getTabbedPane().repaint();
        return false;
    }
}

