/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.baseclasses.MarkedObjectsPreserveCommand;
import document.MyObject;
import document.Renderable;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import util.math.PointDouble;

public class StretchHorVertCommand
extends MarkedObjectsPreserveCommand {
    private MyObject object;
    private double factorHor;
    private double factorVert;
    private PointDouble center;
    private MarkedObjectsAndHandles stateInfo;

    public StretchHorVertCommand(MarkedObjectsAndHandles stateInfo, MyObject objectToStretch, PointDouble center, double factorHor, double factorVert) {
        this.factorHor = factorHor;
        this.factorVert = factorVert;
        this.object = objectToStretch;
        this.center = center.getCopy();
        this.stateInfo = stateInfo;
        if (this.object.getType() == Renderable.ObjectType.markedObjects) {
            this.saveMarkedObjects(stateInfo);
        }
        objectToStretch.getDocument().getCommandManager().invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        if (this.object.getType() == Renderable.ObjectType.markedObjects) {
            this.restoreMarkedObjects(this.stateInfo);
        }
        this.object.stretch(this.center, this.factorHor, this.factorVert);
        return Math.abs(this.factorHor) > 1.0E-6 && Math.abs(this.factorVert) > 1.0E-6;
    }

    @Override
    public final boolean undoIt() {
        if (this.object.getType() == Renderable.ObjectType.markedObjects) {
            this.restoreMarkedObjects(this.stateInfo);
        }
        this.object.stretch(this.center, 1.0 / this.factorHor, 1.0 / this.factorVert);
        return false;
    }

    public final MarkedObjectsAndHandles getStateInfo() {
        return this.stateInfo;
    }
}

