/*
 * Decompiled with CFR 0.152.
 */
package commands.changemarkfield;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.TextStyleChangeable;
import document.text.TextStyle;
import document.text.TextStyleFactory;

public class SetBoldCommand
extends AbstractCommand {
    private boolean newBold;
    private boolean oldBold;
    private TextStyleChangeable textStyleChangeable;

    public SetBoldCommand(boolean newBold, TextStyleChangeable textStyleChangeable, CommandManager commandManager) {
        this.textStyleChangeable = textStyleChangeable;
        this.newBold = newBold;
        this.oldBold = textStyleChangeable.getTextStyle().isBold();
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(ots.getFontName(), ots.getSize(), ots.getFontColor(), ots.isUnderlined(), this.newBold, ots.isItalic());
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return true;
    }

    @Override
    public final boolean undoIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(ots.getFontName(), ots.getSize(), ots.getFontColor(), ots.isUnderlined(), this.oldBold, ots.isItalic());
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return false;
    }
}

