/*
 * Decompiled with CFR 0.152.
 */
package commands.changemarkfield;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.TextStyleChangeable;
import document.text.TextStyle;
import document.text.TextStyleFactory;

public class SetUnderlinedCommand
extends AbstractCommand {
    private boolean newUnderlined;
    private boolean oldUnderlined;
    private TextStyleChangeable textStyleChangeable;

    public SetUnderlinedCommand(boolean newUnderlined, TextStyleChangeable textStyleChangeable, CommandManager commandManager) {
        this.textStyleChangeable = textStyleChangeable;
        this.newUnderlined = newUnderlined;
        this.oldUnderlined = textStyleChangeable.getTextStyle().isUnderlined();
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(ots.getFontName(), ots.getSize(), ots.getFontColor(), this.newUnderlined, ots.isBold(), ots.isItalic());
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return true;
    }

    @Override
    public final boolean undoIt() {
        TextStyle ots = this.textStyleChangeable.getTextStyle();
        TextStyle newTextStyle = TextStyleFactory.getInstance().getTextStyle(ots.getFontName(), ots.getSize(), ots.getFontColor(), this.oldUnderlined, ots.isBold(), ots.isItalic());
        this.textStyleChangeable.setTextStyle(newTextStyle);
        return false;
    }
}

