/*
 * Decompiled with CFR 0.152.
 */
package commands.changetext;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.text.AttributedText;
import document.text.TextFieldController;
import document.text.chunks.Chunk;
import document.text.textstylechanger.UnderlinedChanger;
import java.util.ArrayList;

public class ChangeTextStyleUnderlinedCommand
extends AbstractCommand {
    private int from;
    private int to;
    private boolean underlined;
    private ArrayList<Chunk> oldChunks = null;
    private TextFieldController controller;

    public ChangeTextStyleUnderlinedCommand(int from, int to, boolean italic, TextFieldController controller, CommandManager commandManager) {
        this.from = from;
        this.to = to;
        this.underlined = italic;
        this.controller = controller;
        if (from > to) {
            int z = this.from;
            this.from = to;
            this.to = z;
        }
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        UnderlinedChanger textStyleChanger = new UnderlinedChanger(this.underlined);
        this.oldChunks = attributedText.changeTextStyle(this.from, this.to, textStyleChanger);
        return true;
    }

    @Override
    public final boolean undoIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        attributedText.undoFormatChange(this.oldChunks, this.from, this.to);
        return false;
    }
}

