/*
 * Decompiled with CFR 0.152.
 */
package commands.changetext;

import commands.CommandManager;
import commands.baseclasses.AbstractCommand;
import document.text.AlignmentUndoInformation;
import document.text.AttributedText;
import document.text.HorizontalAlignment;
import document.text.TextFieldController;
import java.util.ArrayList;

public class SetAlignmentCommand
extends AbstractCommand {
    private int from;
    private int to;
    private HorizontalAlignment alignment;
    private ArrayList<AlignmentUndoInformation> undoInfo;
    private TextFieldController controller;

    public SetAlignmentCommand(int from, int to, HorizontalAlignment alignment, TextFieldController controller, CommandManager commandManager) {
        this.from = from;
        this.to = to;
        this.alignment = alignment;
        this.controller = controller;
        if (this.from > this.to && this.to > 0) {
            int z = this.from;
            this.from = this.to;
            this.to = z;
        }
        this.controller = controller;
        commandManager.invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        this.undoInfo = attributedText.setAlignment(this.alignment, this.from, this.to);
        return true;
    }

    @Override
    public final boolean undoIt() {
        AttributedText attributedText = this.controller.getAttributedText();
        attributedText.undoSetAlignment(this.undoInfo);
        return false;
    }
}

