/*
 * Decompiled with CFR 0.152.
 */
package commands.objectaligngroupzorder;

import commands.baseclasses.AbstractCommand;
import document.MyGroup;
import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import java.util.ArrayList;
import java.util.Collections;

public class ObjectsGroupCommand
extends AbstractCommand {
    private MarkedObjectsAndHandles stateInfo;
    private ArrayList<ObjectGroupInformation> groupInformation = new ArrayList();
    private MyGroup group;

    public ObjectsGroupCommand(MarkedObjectsAndHandles stateInfo) {
        this.stateInfo = stateInfo;
        this.group = new MyGroup();
        this.group.setPage(stateInfo.getMarkedObjects().getPage());
        for (MyObject object : stateInfo.getMarkedObjects().getObjects()) {
            ObjectGroupInformation ogi = new ObjectGroupInformation(object, object.getPage().getZOrder(object));
            this.groupInformation.add(ogi);
        }
        Collections.sort(this.groupInformation);
        for (ObjectGroupInformation ogi : this.groupInformation) {
            this.group.add(ogi.object);
        }
        stateInfo.getMarkedObjectsPageController().getPage().getDocument().getCommandManager().invokeCommand(this);
    }

    @Override
    public final boolean doIt() {
        MyPage page = this.group.getPage();
        for (MyObject object : this.group.getObjects()) {
            page.removeObject(object);
        }
        page.addObject(this.groupInformation.get(0).zOrderInPage, this.group);
        this.stateInfo.clearMarkedObjects();
        this.stateInfo.addMarkedObject(this.group);
        this.stateInfo.getHandlesOfMarkedObjects();
        return true;
    }

    @Override
    public final boolean undoIt() {
        MyPage page = this.group.getPage();
        page.removeObject(this.group);
        this.stateInfo.removeMarkedObject(this.group);
        for (ObjectGroupInformation ogi : this.groupInformation) {
            page.addObject(ogi.zOrderInPage, ogi.object);
            this.stateInfo.addMarkedObject(ogi.object);
        }
        this.stateInfo.getHandlesOfMarkedObjects();
        return false;
    }

    private class ObjectGroupInformation
    implements Comparable<ObjectGroupInformation> {
        private MyObject object;
        private int zOrderInPage;

        public ObjectGroupInformation(MyObject object, int zOrderInPage) {
            this.object = object;
            this.zOrderInPage = zOrderInPage;
        }

        @Override
        public int compareTo(ObjectGroupInformation o) {
            return this.zOrderInPage - o.zOrderInPage;
        }
    }
}

