/*
 * Decompiled with CFR 0.152.
 */
package data.scripting;

import bsh.EvalError;
import bsh.Interpreter;
import data.localdatabase.DBKlassenDaten;
import data.localdatabase.DBSchuelerDaten;
import data.localdatabase.DBSchuelerZeugnisDaten;
import data.localdatabase.DBSchulDaten;
import data.localdatabase.DBZeugnisDaten;
import data.scripting.ScrBausteinFenster;
import data.scripting.ScrDokument;
import data.scripting.ScrKlasse;
import data.scripting.ScrSchueler;
import data.scripting.ScrSchuelerZeugnis;
import data.scripting.ScrSchule;
import data.scripting.ScrZeugnis;
import data.scripting.Tools;
import document.MyDocument;

public class DocumentScriptingContext {
    private MyDocument document;
    private DBSchulDaten schule;
    private DBKlassenDaten klasse;
    private DBZeugnisDaten zeugnis;
    private DBSchuelerDaten schueler;
    private DBSchuelerZeugnisDaten schuelerZeugnis;
    private String schuljahr;
    private Interpreter interpreter = null;

    public DocumentScriptingContext(MyDocument document, DBSchulDaten schule, DBKlassenDaten klasse, DBZeugnisDaten zeugnis, DBSchuelerDaten schueler, DBSchuelerZeugnisDaten schuelerZeugnis, String schuljahr) {
        this.document = document;
        this.schule = schule;
        this.klasse = klasse;
        this.zeugnis = zeugnis;
        this.schueler = schueler;
        this.schuelerZeugnis = schuelerZeugnis;
        this.schuljahr = schuljahr;
        this.interpreter = new Interpreter();
        try {
            this.interpreter.set("schueler", new ScrSchueler(schueler));
            this.interpreter.set("schule", new ScrSchule(schule));
            this.interpreter.set("klasse", new ScrKlasse(klasse));
            this.interpreter.set("zeugnis", new ScrZeugnis(zeugnis));
            this.interpreter.set("schuelerzeugnis", new ScrSchuelerZeugnis(schuelerZeugnis));
            this.interpreter.set("schuljahr", schuljahr);
            this.interpreter.set("dokument", new ScrDokument(document));
            this.interpreter.set("tools", Tools.getinstance());
            this.interpreter.set("bausteinFenster", new ScrBausteinFenster(schueler, zeugnis));
        }
        catch (EvalError e) {
            e.printStackTrace();
        }
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }
}

