/*
 * Decompiled with CFR 0.152.
 */
package document;

import document.MyDataSharingObject;
import document.MyPage;
import document.text.CursorShape;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.graphiccontext.GraphicContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.w3c.dom.Element;
import util.graphics.MyGraphics;
import util.math.PointDouble;
import util.math.PointInt;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public abstract class AbstractKeyboardFocusable
extends MyDataSharingObject {
    private static int pickWidthPixel = 1;
    private int nextTabIndex = -1;
    private int previousTabIndex = -1;

    public abstract void renderActiveTextfield(GraphicContext var1, boolean var2, PageViewPortController var3);

    public static int getPickWidthPixel() {
        return pickWidthPixel;
    }

    public abstract boolean hasFocus();

    public abstract void setFocus(boolean var1, PageViewPortController var2);

    public abstract boolean keyboardpressed(KeyEvent var1, PageViewPortController var2);

    public abstract boolean keyTyped(KeyEvent var1, PageViewPortController var2);

    public abstract void mouseLeftDown(PointDouble var1, PointInt var2, boolean var3, PageViewPortController var4);

    public abstract void mouseRightDown(PointDouble var1, boolean var2, PageViewPortController var3);

    public abstract void mouseLeftUp(PointDouble var1, boolean var2, PageViewPortController var3);

    public abstract void mouseRightUp(PointDouble var1, PointInt var2, boolean var3, PageViewPortController var4);

    public abstract void mouseMoved(PointDouble var1, MouseEvent var2, PageViewPortController var3);

    public abstract void ESCPressed();

    public abstract boolean isInTextArea(PointDouble var1, double var2);

    public abstract CursorShape getCursorShape();

    public abstract boolean redoCommand();

    public abstract boolean undoCommand();

    public AbstractKeyboardFocusable getNextTabObject() {
        return (AbstractKeyboardFocusable)this.getPage().getDocument().getObjectByIndex(this.nextTabIndex);
    }

    public AbstractKeyboardFocusable getPreviousTabObject() {
        return (AbstractKeyboardFocusable)this.getPage().getDocument().getObjectByIndex(this.previousTabIndex);
    }

    public void setPreviousIndexOfNextObject() {
        AbstractKeyboardFocusable nextObject = this.getNextTabObject();
        if (nextObject != null) {
            AbstractKeyboardFocusable akf = nextObject;
            akf.setPreviousTabIndex(this.getIndex());
        }
        this.setDirty();
    }

    public void setNextTabObject(AbstractKeyboardFocusable nextAkf) {
        if (nextAkf != null) {
            this.setNextTabIndex(nextAkf.getIndex());
        } else {
            this.setNextTabIndex(-1);
        }
        this.setDirty();
    }

    public void setNextTabIndex(int index) {
        AbstractKeyboardFocusable previousAkf = this.getNextTabObject();
        if (previousAkf != null) {
            previousAkf.setPreviousTabIndex(-1);
        }
        this.nextTabIndex = index;
        this.setPreviousIndexOfNextObject();
        this.setDirty();
    }

    public void drawFocusOrderArrow(Graphics2D g2d, PageViewPortController controller) {
        AbstractKeyboardFocusable nextAkf = this.getNextTabObject();
        if (nextAkf != null) {
            MyPage pageSource = this.getPage();
            MyPage pageDest = nextAkf.getPage();
            PageViewport viewPort = controller.getPageViewport();
            PointDouble pSource = viewPort.pageCmToPixel(new PointDouble(this.getMidX(), this.getMidY()), pageSource);
            PointDouble pDest = viewPort.pageCmToPixel(new PointDouble(nextAkf.getMidX(), nextAkf.getMidY()), pageDest);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
            g2d.setColor(Color.blue);
            g2d.setStroke(new BasicStroke(3.0f));
            MyGraphics.drawArrow(pSource.x, pSource.y, pDest.x, pDest.y, 10.0, 10.0, g2d);
        }
    }

    public int getPreviousTabIndex() {
        return this.previousTabIndex;
    }

    public void setPreviousTabIndex(int previousTabkeyBoardFocusableIndex) {
        this.previousTabIndex = previousTabkeyBoardFocusableIndex;
        this.setDirty();
    }

    @Override
    public Element serialize(Element parentElement) {
        super.serialize(parentElement);
        XMLWriter.addAttributeInt(parentElement, "nexttabindex", this.nextTabIndex);
        return parentElement;
    }

    @Override
    public void deSerialize(Element element) {
        super.deSerialize(element);
        Integer nti = XMLReader.elementIntegerAttribute(element, "nexttabindex");
        this.nextTabIndex = nti != null ? nti : -1;
    }

    public boolean iconUpdateNecessary() {
        return false;
    }

    public boolean hasMarking() {
        return false;
    }

    public void copyTextToClipboard(boolean deleteCopiedText) {
    }

    public void pasteTextFromClipboard() {
    }

    public abstract Cursor getTextCursor();

    public void copyTabIndices(AbstractKeyboardFocusable sourceAkf) {
        this.previousTabIndex = sourceAkf.previousTabIndex;
        this.nextTabIndex = sourceAkf.nextTabIndex;
    }
}

