/*
 * Decompiled with CFR 0.152.
 */
package document;

import document.MyFillableObject;
import document.MyObject;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.xml.XMLDom;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public abstract class MyDataSharingObject
extends MyFillableObject {
    protected MyDataSharingObject dataSource = null;
    private int dataSourceIndex = -1;
    private String name = "Objekt_" + this.getIndex();
    private ArrayList<MyDataSharingObject> dataSharers = new ArrayList();

    public MyDataSharingObject getDataSource() {
        return this.dataSource;
    }

    public abstract void setDataSource(MyDataSharingObject var1);

    public void registerDataSharer(MyDataSharingObject dataSharer) {
        if (!this.dataSharers.contains(dataSharer)) {
            this.dataSharers.add(dataSharer);
        }
    }

    public void deregisterDataSharer(MyDataSharingObject dataSharer) {
        this.dataSharers.remove(dataSharer);
    }

    public abstract void dataChanged();

    public void fireDataChangedEvent() {
        for (MyDataSharingObject mdso : this.dataSharers) {
            mdso.dataChanged();
        }
        if (this.getDataSource() != null) {
            this.getDataSource().setData(this.getData());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Element serialize(Element parentElement) {
        super.serialize(parentElement);
        int dataSourceIndex = -1;
        if (this.getDataSource() != null) {
            dataSourceIndex = this.getDataSource().getIndex();
        }
        XMLWriter.addAttributeInt(parentElement, "datasource", dataSourceIndex);
        XMLWriter.addAttribute(parentElement, "name", this.name);
        return null;
    }

    @Override
    public void deSerialize(Element element) {
        String name;
        super.deSerialize(element);
        Integer dataSourceIndex = XMLReader.elementIntegerAttribute(element, "datasource");
        this.dataSourceIndex = dataSourceIndex != null ? dataSourceIndex : -1;
        this.name = name = XMLReader.attributeNotNull(element, "name");
    }

    public ArrayList<MyDataSharingObject> getDataSharers() {
        return this.dataSharers;
    }

    public void addDataSharer(MyDataSharingObject object) {
        if (!this.dataSharers.contains(object)) {
            this.dataSharers.add(object);
        }
    }

    public abstract Object getData();

    public abstract void setData(Object var1);

    public void setDataSourceFromIndex() {
        if (this.dataSourceIndex != -1) {
            this.setDataSource((MyDataSharingObject)this.getDocument().getObjectByIndex(this.dataSourceIndex));
        } else {
            this.setDataSource(null);
        }
    }

    public abstract boolean hasSchuelerZeugnisData();

    protected abstract void serializeSchuelerZeugnisData(Element var1);

    protected abstract void deserializeSchuelerZeugnisData(Element var1);

    public String serializeSchuelerZeugnisValue() {
        String s = "";
        try {
            Document document = XMLWriter.createEmptyDocument();
            Element element = document.createElement("data");
            this.serializeSchuelerZeugnisData(element);
            s = XMLDom.saveDocumentToString(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public void deserializeSchuelerZeugnisValue(String s) {
        try {
            Document document = XMLReader.readString(s);
            Element element = document.getDocumentElement();
            this.deserializeSchuelerZeugnisData(element);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void copyTo(MyObject object) {
        super.copyTo(object);
        MyDataSharingObject fobject = (MyDataSharingObject)object;
        fobject.dataSourceIndex = this.dataSourceIndex;
    }
}

