/*
 * Decompiled with CFR 0.152.
 */
package document;

import bsh.EvalError;
import bsh.Interpreter;
import commands.CommandManager;
import data.localdatabase.DBSchuelerZeugnisDaten;
import data.scripting.DocumentScriptingContext;
import data.scripting.ScrDokument;
import document.AbstractKeyboardFocusable;
import document.MyDataSharingObject;
import document.MyObject;
import document.MyPage;
import document.Scriptable;
import document.Serializable;
import document.events.Eventtype;
import document.events.Script;
import document.view.MyView;
import init.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.io.ImageStorer;
import util.xml.XMLDom;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyDocument
implements Serializable,
Scriptable {
    private static final Eventtype[] POSSIBLE_EVENTTYPES = new Eventtype[]{Eventtype.DOCUMENT_SETUP};
    private CommandManager commandManager = new CommandManager();
    public ArrayList<MyView> views = new ArrayList();
    private ArrayList<ImageStorer> imageResorces = new ArrayList();
    boolean dirty = false;
    private DocumentScriptingContext documentScriptingContext = null;
    private ArrayList<Script> scripts = new ArrayList();
    private String filename = "";

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public DocumentScriptingContext getDocumentScriptingContext() {
        return this.documentScriptingContext;
    }

    public void setDocumentScriptingContext(DocumentScriptingContext documentScriptingContext) {
        this.documentScriptingContext = documentScriptingContext;
    }

    public MyView addView() {
        MyView view = new MyView(this);
        this.views.add(view);
        this.setDirty(true);
        return view;
    }

    public void addView(MyView view) {
        this.views.add(view);
        this.setDirty(true);
    }

    public static String getXMLName() {
        return "document";
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public void deSerialize(Element element) {
        this.imageResorces.clear();
        List<Element> elements = XMLReader.elements(element);
        for (Element childElement : elements) {
            if (childElement.getNodeName().compareTo(MyView.getXMLName()) == 0) {
                MyView view = new MyView(this);
                this.addView(view);
                view.deSerialize(childElement);
            }
            if (childElement.getNodeName().compareTo(ImageStorer.getXMLName()) != 0) continue;
            String resourceName = XMLReader.attributeNotNull(childElement, "resourcename");
            ImageStorer is = this.getImageStorerResource(resourceName);
            is.deSerialize(childElement);
        }
        this.scripts = Script.deserializeScripts(element);
        if (this.scripts == null) {
            this.scripts = new ArrayList();
        }
        this.repairBackwardFocusReferences();
        this.repairDataSourceReferences();
        this.setDirty(false);
    }

    private void fireEventForAllObjects(Eventtype eventtype) {
        for (MyView view : this.views) {
            for (MyPage page : view.pages) {
                for (MyObject object : page.objects) {
                    object.fireEvent(eventtype);
                }
            }
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        this.imageResorces.clear();
        for (MyView view : this.views) {
            view.serialize(parentElement);
        }
        for (ImageStorer imageStorer : this.imageResorces) {
            imageStorer.serialize(parentElement);
        }
        if (this.scripts != null) {
            for (Script script : this.scripts) {
                script.serialize(parentElement);
            }
        }
        this.setDirty(false);
        return parentElement;
    }

    public String addImageStorerResource(ImageStorer imageStorer) {
        this.setDirty(true);
        if (this.imageResorces.contains(imageStorer)) {
            return imageStorer.getResourceName();
        }
        this.imageResorces.add(imageStorer);
        String resourceName = "ImageResource_" + this.imageResorces.size();
        imageStorer.setResourceName(resourceName);
        return resourceName;
    }

    public ImageStorer getImageStorerResource(String resourceName) {
        for (ImageStorer is : this.imageResorces) {
            if (is.getResourceName().compareTo(resourceName) != 0) continue;
            return is;
        }
        ImageStorer imageStorer = new ImageStorer();
        imageStorer.setResourceName(resourceName);
        this.imageResorces.add(imageStorer);
        return imageStorer;
    }

    public MyObject getObjectByIndex(int index) {
        MyObject object = null;
        for (MyView view : this.views) {
            for (MyPage page : view.pages) {
                object = page.getObjectByIndex(index);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public void repairBackwardFocusReferences() {
        for (MyView view : this.views) {
            for (MyPage page : view.pages) {
                for (MyObject object : page.objects) {
                    if (!(object instanceof AbstractKeyboardFocusable)) continue;
                    ((AbstractKeyboardFocusable)object).setPreviousIndexOfNextObject();
                }
            }
        }
    }

    public void repairDataSourceReferences() {
        for (MyView view : this.views) {
            for (MyPage page : view.pages) {
                for (MyObject object : page.objects) {
                    if (!(object instanceof MyDataSharingObject)) continue;
                    ((MyDataSharingObject)object).setDataSourceFromIndex();
                }
            }
        }
    }

    public MyView getPrintView() {
        for (MyView view : this.views) {
            if (!view.isDrawBorderAndShadow()) continue;
            return view;
        }
        return null;
    }

    public void switchEditMode(Settings.ToggleEditModus editmode) {
        for (MyView view : this.views) {
            view.switchEditMode(editmode);
        }
    }

    public MyView getQuickView() {
        for (MyView view : this.views) {
            if (!view.isAutomaticZoomToFitPage()) continue;
            return view;
        }
        return null;
    }

    public ArrayList<MyView> getViews() {
        return this.views;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void serializeSchuelerZeugnisData(DBSchuelerZeugnisDaten data) {
        String s = "";
        try {
            Document document = XMLWriter.createEmptyDocument();
            Element element = document.createElement("data");
            document.appendChild(element);
            for (MyView view : this.views) {
                for (MyPage page : view.pages) {
                    for (MyObject o : page.objects) {
                        MyDataSharingObject mdo;
                        if (!(o instanceof AbstractKeyboardFocusable) || !(mdo = (MyDataSharingObject)o).hasSchuelerZeugnisData()) continue;
                        String name = mdo.getName().replace(" ", "_");
                        Element childelement = XMLWriter.addElement(name, element);
                        mdo.serializeSchuelerZeugnisData(childelement);
                    }
                }
            }
            s = XMLDom.saveDocumentToString(document);
            data.put("data", s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deserializeSchuelerZeugnisData(DBSchuelerZeugnisDaten data) {
        HashMap<String, MyDataSharingObject> dataSharingObjects = new HashMap<String, MyDataSharingObject>();
        for (MyView view : this.views) {
            for (MyPage page : view.pages) {
                for (MyObject o : page.objects) {
                    if (!(o instanceof MyDataSharingObject)) continue;
                    MyDataSharingObject mdo = (MyDataSharingObject)o;
                    dataSharingObjects.put(mdo.getName().replace(" ", "_"), mdo);
                }
            }
        }
        String xmlData = data.getStringValueNotNull("data");
        if (!xmlData.isEmpty()) {
            try {
                Document document = XMLReader.readString(xmlData);
                Element element = document.getDocumentElement();
                List<Element> elements = XMLReader.elements(element);
                for (Element childElement : elements) {
                    String name = childElement.getNodeName();
                    MyDataSharingObject mdo = (MyDataSharingObject)dataSharingObjects.get(name);
                    if (mdo == null) continue;
                    List<Element> elements1 = XMLReader.elements(childElement);
                    if (elements1.size() > 0) {
                        mdo.deserializeSchuelerZeugnisData(elements1.get(0));
                        continue;
                    }
                    mdo.deserializeSchuelerZeugnisData(childElement);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fireEvent(Eventtype.DOCUMENT_SETUP);
        this.fireEventForAllObjects(Eventtype.OBJECT_SETUP);
    }

    public MyDocument getCopy() {
        MyDocument copy = new MyDocument();
        for (MyView view : this.views) {
            copy.views.add(view.getCopy(copy));
        }
        for (Script script : this.scripts) {
            copy.scripts.add(script.getCopy());
        }
        copy.repairDataSourceReferences();
        copy.dirty = false;
        return copy;
    }

    @Override
    public Eventtype[] getPossibleEvents() {
        return POSSIBLE_EVENTTYPES;
    }

    @Override
    public Script getScript(Eventtype eventtype) {
        if (this.scripts != null) {
            for (Script script : this.scripts) {
                if (script.getEventtype() != eventtype) continue;
                return script;
            }
            return null;
        }
        return null;
    }

    @Override
    public void fireEvent(Eventtype eventtype) {
        Script script = this.getScript(eventtype);
        if (script != null && this.getDocumentScriptingContext() != null) {
            Interpreter interpreter = this.getDocumentScriptingContext().getInterpreter();
            try {
                interpreter.set("document", new ScrDokument(this));
                interpreter.eval(script.getScript());
            }
            catch (EvalError e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setScriptText(Eventtype eventtype, String text) {
        Script script = this.getScript(eventtype);
        if (!text.isEmpty()) {
            if (script == null) {
                script = new Script(eventtype);
                this.scripts.add(script);
            }
            script.setScript(text);
        } else if (script != null) {
            this.scripts.remove(script);
        }
    }
}

